target=plain abs count digit1 digit2 minmaxconst distconst sign gcd1 gcd2 gcd3

#include "header.inc"
#include "confparm.inc"
\text{outtype=int}	% int, double, unsigned int
\text{printftype=%d}	% corresponding to outtype
\text{inttype=all}	% generated integer: all or pos
\text{zeros=yes}	% include zeros in list
\integer{limit=20}	% integer size limit: power of 2
\integer{sizelim1=3}	% smallest list
\integer{sizelim2=1000}	% biggest list
\text{size=10x70}	% textarea size
			% sizes of testing lists
\integer{decal=randint(0..4)}
\text{ns=wims(values x for x in 
	 3,5+\decal,6+\decal,7+\decal,8+\decal,9+\decal,10+\decal,
	 randint(10..20),randint(20..50),randint(50..100),
	 randint(100..200),randint(700..1000))}
\integer{ncnt=items(\ns)}

#if #TARGET (plain)
 \title{. Somme simple}
 \text{wt=sum}
 \text{formula=x}
 \text{summand=la somme de <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (abs)
 \title{Somme des valeurs absolues}
 \text{wt=sum}
 \text{formula=abs(x)}
 \text{summand=la somme randitem(
	des valeurs absolues de <tt>\ll[][\ii]</tt>,
	de <tt>|\ll[][\ii]|</tt>,
	des valeurs absolues <tt>|\ll[][\ii]|</tt>
 )}
#endif

#if #TARGET (count)
 \title{. Compte simple}
 \text{wt=count}
 \text{formula=1}
 \text{summand=le nombre de termes <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (digit1)
 \title{Somme du dernier chiffre}
 \text{wt=sum}
 \text{formula=abs(x)%10}
 \text{summand=la somme des derniers chiffres de <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (digit2)
 \title{Somme d&#39;un chiffre}
 \text{wt=sum}
 \integer{place=random(1,2,3)}
 \text{Place=item(\place,dizaines,centaines,milliers)}
 \integer{div=item(\place,10,100,1000)}
 \text{formula=floor(abs(x)/\div)%10}
 \text{summand=la somme des chiffres de \Place de <tt>\ll[][\ii]</tt>}
#endif

#if #TARGET (minmaxconst)
 \title{Somme min-max avec une constante}
 \integer{const=random(-10000..10000)}
 \text{wt=sum}
 \text{minmax=random(min,max)}
 \text{formula=\minmax(x,\const)}
\text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=la somme de <tt>\minmax(\ind)</tt>}
#endif

#if #TARGET (distconst)
 \title{Somme de distance avec une constante}
 \integer{const=random(-1000..1000)}
 \text{wt=sum}
 \text{formula=abs(x-(\const))}
 \text{ind=random(1,2)=1?\const et <tt>\ll[][\ii]</tt>:<tt>\ll[][\ii]</tt> et \const}
 \text{summand=la somme des distances entre \ind}
 \text{hint=<b>ATTENTION</b> La distance entre deux nombres n&#39;est jamais negative !}
#endif

#if #TARGET (sign)
 \title{Somme de signes}
 \text{wt=sum}
 \text{formula=sign(x)}
 \text{summand=la somme des signes de <tt>\ll[][\ii]</tt>}
 \text{hint=Le signe d&#39;un nombre x est gal  1 si x est positif,
        -1 si x est ngatif, et  0 si x=0}
#endif

#if #TARGET (gcd1)
 \title{Somme de pgcd I}
 \text{inttype=pos}
 \text{adj=positifs}
 \text{zeros=no}
 \text{wt=sum}
 \text{primes=2,3,5,7,11,13,17,19,23,29,31,37,41,43,47}
 \text{const=randitem(\primes)}
 \text{formula=gcd(x,\const)}
 \text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=la somme de <tt>pgcd(\ind)</tt>}
#endif

#if #TARGET (gcd2)
 \title{Somme de pgcd II}
 \text{inttype=pos}
 \text{adj=positifs}
 \text{zeros=no}
 \text{wt=sum}
 \text{primes=2,3,5,7,11,13,17,19,23,29,31,37,41,43,47}
 \text{p1=randitem(\primes)}
 \text{p2=randitem(\primes)}
 \integer{const=\p1*\p2}
 \text{formula=gcd(x,\const)}
 \text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=la somme de <tt>pgcd(\ind)</tt>}
#endif

#if #TARGET (gcd3)
 \title{Somme de pgcd III}
 \text{inttype=pos}
 \text{adj=positifs}
 \text{zeros=no}
 \text{wt=sum}
 \text{primes=2,3,5,7,11,13,17,19,23,29,31,37,41,43,47}
 \text{p1=randitem(\primes)}
 \text{p2=randitem(\primes)}
 \text{p3=randitem(\primes)}
 \integer{const=\p1*\p2*\p3}
 \text{formula=gcd(x,\const)}
 \text{ind=random(1,2)=1?\const,\ll[][\ii]:\ll[][\ii],\const}
 \text{summand=la somme de <tt>pgcd(\ind)</tt>}
#endif

\text{sum=}
\text{listsc=}
\for{n in \ns}{
 #include "list.inc"
 \text{listsc=wims(append item { \list } to \listsc)}
 \text{slib=slib(\selmeth \n,\wt,\formula,\list)}
 \text{condition=wims(line 2 of \slib)}
 \text{sum=\sum wims(line 3 of \slib)}
}

#include "src.inc"
#include "main.inc"

