<?php
/*
* Configuration file for the WebIssues Server.
*/

/*
* Database configuration.
*
* Create the database and set correct values below before running the setup.php script.
*/

// database engine, can be: 'mysql', 'mysqli', 'pgsql', 'mssql' or 'firebird'
$config[ 'db_engine' ]        = 'mysql';

// database server, can be: 'host', 'host:port', ':/path/to/socket' or 'host\dbinstance'
$config[ 'db_host' ]          = 'localhost';

// database name
$config[ 'db_database' ]      = 'webissues';

// optional: database user login (if blank, integrated authentication is used)
$config[ 'db_user' ]          = 'webissues';

// optional: database user password
$config[ 'db_password' ]      = 'secret';

// optional: prefix of table names (e.g. 'xyz_' so all tables will be 'xyz_table_name')
$config[ 'db_prefix' ]        = '';

/*
* Attachment storage configuration.
*
* Create the storage directory with write permissions for the HTTP server.
* The path can be absolute or relative to index.php.
*/

// optional: path of the storage folder (if blank, file storage is disabled)
$config[ 'storage_path' ]     = 'storage';

// minimum size of attachments stored as files
$config[ 'storage_min_size' ] = 4000;

/*
* Notification sending configuration.
*
* Make sure you configure the mailing engine before enabling notifications.
* You can use one of the existing e-mail templates or create your own templates
* based on them.
*/

// are notifications enabled (1 to enable, 0 to disable)
$config[ 'notify_enabled' ]   = 0;

// minimum timespan between e-mails send to a user (in minutes)
$config[ 'notify_min_span' ]  = 120;

// e-mail template to use for notifications
$config[ 'notify_template' ]  = 'templates/notify-plain.template';

/*
* General mailing configuration.
*
* These are common options used by all mailing engines. Make sure the "From"
* address is correct, otherwise sending e-mails may not work.
*
* The available engines are:
*  - standard (using the built-in PHP mail function)
*  - smtp (allowing to connect to any external SMTP server)
*/

// mailing engine, can be: 'standard' or 'smtp'
$config[ 'mail_engine' ]      = 'standard';

// address to be used as the "From" address for automatically sent e-mails
$config[ 'mail_from' ]        = 'user@example.com';

/*
* SMTP mailing engine configuration.
*
* Edit options in this section when you are using the SMTP mailing engine.
*/

// host name or IP address of the SMTP server
$config[ 'smtp_host' ]        = 'smtp.example.com';

// port number (usually 25, secure connections sometimes use port 465)
$config[ 'smtp_port' ]        = 25;

// optional: secure mode, can be 'ssl' or 'tls' (if blank, connection is unsecured)
$config[ 'smtp_secure' ]      = '';

// optional: user name if server requires authentication
$config[ 'smtp_user' ]        = 'user';

// optional: password if server requires authentication
$config[ 'smtp_password' ]    = 'secret';

/*
* Logging configuration.
*
* Enter a file path to enable the appropriate log, otherwise leave blank.
* The log directory must exist and must be writable for the HTTP server.
* Paths can be absolute or relative to index.php.
*/

// optional: logging PHP and SQL errors
$config[ 'log_errors' ]       = 'log/errors.log';

// optional: logging cron script runs
$config[ 'log_cron' ]         = 'log/cron.log';

// optional: logging commands from the client and server responses (warning: use for debugging only)
$config[ 'log_commands' ]     = '';

// optional: logging SQL queries (warning: use for debugging only)
$config[ 'log_sql' ]          = '';
