package scan

import (
	"reflect"
	"testing"

	"github.com/future-architect/vuls/config"
	"github.com/future-architect/vuls/models"
)

func TestParseApkInfo(t *testing.T) {
	var tests = []struct {
		in    string
		packs models.Packages
	}{
		{
			in: `musl-1.1.16-r14
busybox-1.26.2-r7
`,
			packs: models.Packages{
				"musl": {
					Name:    "musl",
					Version: "1.1.16-r14",
				},
				"busybox": {
					Name:    "busybox",
					Version: "1.26.2-r7",
				},
			},
		},
	}
	d := newAlpine(config.ServerInfo{})
	for i, tt := range tests {
		pkgs, _ := d.parseApkInfo(tt.in)
		if !reflect.DeepEqual(tt.packs, pkgs) {
			t.Errorf("[%d] expected %v, actual %v", i, tt.packs, pkgs)
		}
	}
}

func TestParseApkVersion(t *testing.T) {
	var tests = []struct {
		in    string
		packs models.Packages
	}{
		{
			in: `Installed:                                Available:
libcrypto1.0-1.0.1q-r0                  < 1.0.2m-r0
libssl1.0-1.0.1q-r0                     < 1.0.2m-r0
nrpe-2.14-r2                            < 2.15-r5
`,
			packs: models.Packages{
				"libcrypto1.0": {
					Name:       "libcrypto1.0",
					NewVersion: "1.0.2m-r0",
				},
				"libssl1.0": {
					Name:       "libssl1.0",
					NewVersion: "1.0.2m-r0",
				},
				"nrpe": {
					Name:       "nrpe",
					NewVersion: "2.15-r5",
				},
			},
		},
	}
	d := newAlpine(config.ServerInfo{})
	for i, tt := range tests {
		pkgs, _ := d.parseApkVersion(tt.in)
		if !reflect.DeepEqual(tt.packs, pkgs) {
			t.Errorf("[%d] expected %v, actual %v", i, tt.packs, pkgs)
		}
	}
}
