
// vbreports.cpp
// functions supporting reporting
// Copyright (c) 1998-2002 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// original version written by Dan Kimberg

using namespace std;

#include "vbutil.h"
#include <stdio.h>
#include <fstream>
// #include "vbprefs.h"
#include "vbutil.h"

void
vb_buildindex(string homedir)
{
  char tmp[STRINGLEN],indname[STRINGLEN],ldir[STRINGLEN];
  ofstream indstream;
  FILE *lfp;

  sprintf(indname,"%s/.voxbo/reports/index.html",homedir.c_str());
  sprintf(ldir,"%s/.voxbo/reports",homedir.c_str());
  lfp=lockfiledir(ldir);
  indstream.open(indname,ios::out);
  if (!indstream) {
    // FIXME do something?
    return;
  }
  // start off the html file
  indstream << "<html>\n<head>\n<title>Your VoxBo Quality Assurance Page</title>\n</head>" << endl;
  indstream << "<body bgcolor=white>\n\n";
  indstream << "<h1>Your VoxBo Quality Assurance Page</h1>\n\n";

  indstream << "<p>" << endl;
  indstream << "The table below shows your collection of VoxBo quality assurance reports," << endl;
  indstream << "generated by <b>vbqa</b>.  To delete one of these reports, type" << endl;
  indstream << "<i>vbqa -d <name></i>, where <name> is the name of the report you want to" << endl;
  indstream << "delete (if it has spaces, enclose the name in double quotes.)" << endl;
  indstream << "For more information, type <i>vbqa</i> (with no arguments) at the" << endl;
  indstream << "command line." << endl;
  indstream << "</p>" << endl;

  indstream << "<table cols=1 border=1 cellspacing=0 marginwidth=0>" << endl;
  indstream << "<tr><td bgcolor=#D0D0D0><center><b>Try one of these links:</b></center></td>" << endl;

  vglob vg(homedir+"/.voxbo/reports/*");
  for (size_t i=0; i<vg.size(); i++) {
    // is it a directory?
    if (!vb_direxists(vg[i]))
      continue;
    string fname=xfilename(vg[i]);
    indstream << "<tr><td>" << endl;
    sprintf(tmp,"<a href=\"%s/.voxbo/reports/%s/index.html\">%s</a>",
            homedir.c_str(),fname.c_str(),fname.c_str());
    indstream << tmp << endl;
  }
  indstream << "</table>\n</body>\n</html>\n" << endl;
  indstream.close();
  if (lfp)
    unlockfiledir(lfp);
  return;
}

