/*
// @HEADER
// ************************************************************************
//             FEI: Finite Element Interface to Linear Solvers
//                  Copyright (2005) Sandia Corporation.
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation, the
// U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Alan Williams (william@sandia.gov) 
//
// ************************************************************************
// @HEADER
*/

#ifndef _fei_trilinos_macros_hpp_
#define _fei_trilinos_macros_hpp_

//fei_macros.hpp includes FEI_config.h
#include "fei_macros.hpp"

#ifdef FEI_BYPASS_CONFIG_H

#undef HAVE_FEI_TEUCHOS
#ifndef HAVE_FEI_NO_TEUCHOS
#define HAVE_FEI_TEUCHOS
#endif

#undef HAVE_FEI_EPETRA
#ifndef HAVE_FEI_NO_EPETRA
#define HAVE_FEI_EPETRA
#endif

#undef HAVE_FEI_AZTECOO
#ifndef HAVE_FEI_NO_AZTECOO
#define HAVE_FEI_AZTECOO
#endif

#undef HAVE_FEI_AMESOS
#ifndef HAVE_FEI_NO_AMESOS
#define HAVE_FEI_AMESOS
#endif

#undef HAVE_FEI_ML
#ifndef HAVE_FEI_NO_ML
#define HAVE_FEI_ML
#endif

#undef HAVE_FEI_IFPACK
#ifndef HAVE_FEI_NO_IFPACK
#define HAVE_FEI_IFPACK
#endif

#ifndef HAVE_CONFIG_H
#define HAVE_CONFIG_H
#endif

#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef F77_FUNC
#undef F77_FUNC_

#endif
//FEI_BYPASS_CONFIG_H

#endif
//_fei_trilinos_macros_hpp_

