-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2017  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Ada.Text_IO;
with Interfaces.C;
with Misc;         use Misc;

package body Echo is

   pragma Linker_Options("ada-echo-c.o");

   function C_Set_Echo return Interfaces.C.int;

   pragma Import(C, C_Set_Echo, "setecho");

   function C_No_Echo return Interfaces.C.int;

   pragma Import(C, C_No_Echo, "noechoT");

   procedure Set_Echo is
      Result : Interfaces.C.Int;
      use type Interfaces.C.Int;
   begin
      Debug("Setting echo; input will be echoed");
      Result := C_Set_Echo;
      if Result /= 0 then
         raise Operation_Failed;
      end if;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Echo.Set_Echo");
         raise;
   end Set_Echo;

   procedure Clear_Echo is
      Result : Interfaces.C.Int;
      use type Interfaces.C.Int;
   begin
      Debug("Clearing echo; no input will be echoed");
      Result := C_No_Echo;
      if Result /= 0 then
         raise Operation_Failed;
      end if;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Echo.Clear_Echo");
         raise;
   end Clear_Echo;
   
   function C_Save_Terminal return Interfaces.C.int;

   pragma Import(C, C_Save_Terminal, "saveTerminal");

   function C_Restore_Terminal return Interfaces.C.int;

   pragma Import(C, C_Restore_Terminal, "restoreTerminal");

   procedure Save_Terminal is
      Result : Interfaces.C.Int;
      pragma Unreferenced(Result);
      use type Interfaces.C.Int;
   begin
      Result := C_Save_Terminal;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Echo.Save_Terminal");
         raise;
   end Save_Terminal;
   
   procedure Restore_Terminal is
      Result : Interfaces.C.Int;
      pragma Unreferenced(Result);
      use type Interfaces.C.Int;
   begin
      Result := C_Restore_Terminal;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Echo.Restore_Terminal");
         raise;
   end Restore_Terminal;
   
end Echo;
