.\" Text automatically generated by txt2man
'\"
'\" Copyright (c) 2020 Kevin Walzer/WordTech Communications LLC.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH tk sysnotify n "" Tk "Tk Built-In Commands"
.so man.macros
.BS
.SH NAME
sysnotify \- Creates a notification window with a title and message.
.SH SYNOPSIS
\fBtk sysnotify\fI title message\fR
.BE
.SH DESCRIPTION
.PP
The \fBtk sysnotify\fR command creates a platform-specific system notification
alert. Its intent is to provide a brief, unobtrusive notification to the user
by popping up a window that briefly appears in a corner of the screen.
.SH EXAMPLE
.PP
Here is an example of the \fBtk sysnotify\fR code:
.PP
.CS
tk sysnotify "Alert" \e
      "This is just a test of the Tk System Notification Code."
.CE
.SH PLATFORM NOTES
.PP
The macOS and Windows versions are native implementations using system
API's. The X11 version has a conditional dependency on libnotify, and
falls back to a Tcl-only implementation if libnotify is not installed. On
each platform the notification includes a platform-specific default image to
accompany the text.
.TP
\fBmacOS\fR
.
The macOS version will request permission from the user to authorize
notifications. This must be activated in Apple's System Preferences
Notifications section.
.RS
.PP
If deploying an application using the standalone version of Wish.app,
setting the bundle ID in the applications Info.plist file to begin with
.QW \fBcom\fR
seems necessary for notifications to work. Using a different prefix
for the bundle ID, such as something like
.QW \fBtk.tcl.tkchat\fR ,
will cause notifications to silently fail.
.RE
.TP
\fBWindows\fR
.
The image is taken from the system tray, i.e., \fBsysnotify\fR can only be
called when a \fBsystray\fR was installed.
.
.SH KEYWORDS
notify, alert
