5.6 Variables

# Variables

Algo útil para hacer con tú código es crear nombres para las cosas. Sonic Pi
hace esto muy fácil, escribes el nombre que deseas utilizar, un símbolo de
(`=`), después lo que quieres recordar:

```
sample_name = :loop_amen
```

Aquí hemos 'recordado' el símbolo `:loop_amen` en la variable `sample_name`.
Ahora podemos usar `sample_name`  en cualquier lugar donde pudiésemos usar
`:loop_amen`. Por ejemplo:

```
sample_name = :loop_amen
sample sample_name
```

Hay tres razones principales para utilizar variables en Sonic Pi:
comunicar significado, administrar repeticón y capturar los resultados
de las cosas.

## Comunicando significado

Cuando escribes código, es fácil pensar que sólo le dices a la computadora
cómo hacer algo - mientras ella entienda, todo está bien. Sin embargo, es
importante recordar que no sólo la computadora leerá el código. Otra gente
podría leerlo e intentar comprender qué es lo que sucede. También sucede 
que quieras entender tu propio código en el futuro. Aunque pueda ser obvio
para tí, ahora, ¡podría no serlo para otros o para tí en el futuro!
When you write code it's easy to just think you're telling the computer
how to do stuff - as long as the computer understands it's OK. However,
it's important to remember that it's not just the computer that reads
the code. Other people may read it too and try to understand what's going
on. Also, you're likely to read your own code in the future and try to
understand what's going on. Although it might seem obvious to you now -
it might not be so obvious to others or even your future self! 

One way to help others understand what your code is doing is to write
comments (as we saw in a previous section). Another is to use meaningful
variable names. Look at this code:

```
sleep 1.7533
```

¿Por qué utiliza el número `1.7533`? ¿de dónde proviene? ¿qué significa?
Miremos el código siguiente:

```
loop_amen_duration = 1.7533
sleep loop_amen_duration
```

Ahora está mucho más claro lo que significa `1.7533` : es la duración del
sample `:loop_amen`! claro que puedes pensar que es mucho más simple escribir:

```
sleep sample_duration(:loop_amen)
```

Lo cual es una muy buena manera de comunicar la intención del código.

## Administrando las repeticiones

a menudo ves muchas repeticiones en tu código y cuando quieres cambiar 
algo, tienes que cambiarlo enmuchos lugares. Mira este código:

```
sample :loop_amen
sleep sample_duration(:loop_amen)
sample :loop_amen, rate: 0.5
sleep sample_duration(:loop_amen, rate: 0.5)
sample :loop_amen
sleep sample_duration(:loop_amen)
```

Estamos haciendo muchas cosas con `:loop_amen`! ¿qué pasa si quisiésemos
escuchar otro sampleo como `:loop_garzul`? tendríamos que buscar y reemplazar
todos los `:loop_amen` con `:loop_garzul`. Eso estaría bien si tienes mucho 
tiempo - pero ¿qué si está en vivo? algunas veces no tendrás el lujo del tiempo - 
especialmente si quieres que la gente se mantenga bailando.

¿qué tal si hubieses escrito tú código, así?:

```
sample_name = :loop_amen
sample sample_name
sleep sample_duration(sample_name)
sample sample_name, rate: 0.5
sleep sample_duration(sample_name, rate: 0.5)
sample sample_name
sleep sample_duration(sample_name)
```
Eso hace exactamente lo mismo que lo anterior (pruébalo). también nos da
la habilidad de cambiar una línea `sample_name = :loop_amen` a
`sample_name = :loop_garzul` y podemos hacerlo en muchos lugares gracias a
las variables.

## Capturando los resultados

Un buen motivo para utilizar variables es capturar los resultados de las cosas.
Por ejemplo, quizás desees hacer algo con la duración de un sampleo:

```
sd = sample_duration(:loop_amen)
```

Ahora podemos usar `sd` en cualquier lugar donde necesitemos la duración del 
sampleo `:loop_amen`.

Más importantemente, una variable nos permite capturar el resultado de una 
llamada a `play` o `sample`:

```
s = play 50, release: 8
```

Ahora hemos atrapado y recordado `s` como una variable, lo que nos permite controlar
el sintetizador mientras corre:

```
s = play 50, release: 8
sleep 2
control s, note: 62
```
Veremos en más detalle cómo controlar los sintetizadores más tarde.
