#!/usr/bin/python3

# Copyright (C) 2019-2020
# * Felix Delattre <felix@delattre.de>
# * W. Martin Borgert <debacle@debian.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
from setuptools import setup, find_packages

with open(os.path.join("..", "VERSION")) as version_file:
    version = version_file.read().strip()

setup(
    name="sms4you-email",
    version=version,
    description="Personal gateway connecting SMS with email",
    long_description="Personal gateway connecting SMS with email",
    url="https://gitlab.com/xamanu/sms4you",
    license="AGPLv3+",
    keywords="sms email gateway",
    author="Various collaborators: https://gitlab.com/xamanu/sms4you",
    install_requires=["asgiref", "sdnotify"],
    packages=find_packages(),
    python_requires=">=3.6",
)
