import SCons.Defaults

def VersionedLibrary(env, target, major, minor, micro, source):
	major = int(major)
	minor = int(minor)
	micro = int(micro)
	targets = []
	platform = env.subst('$PLATFORM')

	libname = env.subst('$SHLIBPREFIX') + target + env.subst('$SHLIBSUFFIX')
	soname = libname + ".%d" % major
	# copy SHLINKFLAGS - [:] splices the whole list/string
	shlinkflags = env['SHLINKFLAGS'][:]
	shlibsuffix = '${SHLIBSUFFIX}' + ".%d.%d.%d" % (major, minor, micro)
	# write soname into shared library;
	# TODO: other platforms? (for examples see Richard Levitte's VersionedSharedLibrary function)
	if platform == 'posix':
		shlinkflags.append('-Wl,-soname=%s' % (soname))

	# make the shared library
	targets += env.SharedLibrary(target = target, source = source, SHLIBSUFFIX = shlibsuffix, SHLINKFLAGS = shlinkflags)

	# build symlinks
	# TODO: other platforms? (for examples see Richard Levitte's VersionedSharedLibrary function
	if platform == 'posix':
		targets += env.SymbolicLink(libname, targets[0])
		targets += env.SymbolicLink(soname, targets[0])

	return targets

def InstallVersionedLibrary(env, dir, source):
	targets = []
	targets += env.Install(dir, source[0])
	targets += env.InstallSymlinks(dir, source[1:], source[0])

	return targets

def generate(env, **kw):
	env.AddMethod(VersionedLibrary, 'VersionedLibrary')
	env.AddMethod(InstallVersionedLibrary, 'InstallVersionedLibrary')

def exists(env):
	return 1
