/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPCODE_H
#define OPCODE_H

#include "common/scummsys.h"

namespace AGDS {

enum Opcode : uint16 {
	kEnter = 5,
	kJumpZImm16 = 8,
	kJumpImm16 = 9,
	kPop = 10,
	kDup = 11,
	kExitProcess = 12,
	kSuspendProcess = 13,
	kPushImm32 = 14,
	kPushImm16 = 15,
	kPushImm8 = 16,
	kPushImm16_2 = 17,
	kPushImm8_2 = 18,
	kStub19 = 19,
	kStub20 = 20,
	kGetGlobalImm8 = 21,
	kEquals = 22,
	kNotEquals = 23,
	kGreater = 24,
	kLess = 25,
	kGreaterOrEquals = 26,
	kLessOrEquals = 27,
	kAdd = 28,
	kSub = 29,
	kMul = 30,
	kDiv = 31,
	kMod = 32,
	kAnd = 33,
	kOr = 34,
	kXor = 35,
	kNot = 36,
	kShl = 37,
	kShr = 38,
	kBoolAnd = 39,
	kBoolOr = 40,
	kBoolNot = 41,
	kNegate = 42,
	kPreIncrementGlobal = 43,
	kPreDecrementGlobal = 44,
	kPostIncrementGlobal = 45,
	kPostDecrementGlobal = 46,
	kSetGlobalWithTop = 47,
	kSetGlobal = 48,
	kIncrementGlobalByTop = 49,
	kDecrementGlobalByTop = 50,
	kMultiplyGlobalByTop = 51,
	kDivideGlobalByTop = 52,
	kModGlobalByTop = 53,
	kShlGlobalByTop = 54,
	kShrGlobalByTop = 55,
	kAndGlobalByTop = 56,
	kOrGlobalByTop = 57,
	kXorGlobalByTop = 58,
	kObjectInitialise = 59,
	kObjectRegisterLookHandler = 60,
	kObjectRegisterUseHandler = 61,
	kObjectRegisterHandlerC1 = 62,
	kObjectRegisterUseObjectHandler = 63,
	kObjectRegisterHandlerBD = 64,
	kObjectRegisterCharacterTrap = 65,
	kLoadMouseCursorFromObject = 66,
	kLoadRegionFromObject = 68,
	kLoadPictureFromObject = 69,
	kLoadAnimationFromObject = 70,
	kSetObjectZ = 71,
	kSetScreenBackground = 72,
	kLoadTextFromObject = 73,
	kScreenSetZNearFar = 74,
	kScreenLoadRegion = 75,
	kScreenLoadObject = 76,
	kScreenCloneObject = 77,
	kScreenRemoveObject = 78,
	kSetNextScreen = 79,
	kSetNextScreenSaveOrLoad = 80,
	kObjectPatchSetText = 82,
	kObjectPatchSetRegionName = 83,
	kScreenPatchSetRegionName = 84,
	kLoadCharacter = 85,
	kUnloadCharacter = 86,
	kAssociateCharacter = 87,
	kAnimateCharacter = 88,
	kHideCharacter = 89,
	kShowCharacter = 90,
	kDisableCharacter = 91,
	kEnableCharacter = 92,
	kMoveCharacterUserMove = 93,
	kLeaveCharacter = 94,
	kSetCharacter = 95,
	kSetCharacterDirection = 96,
	kPointCharacter = 97,
	kDisableUser = 98,
	kEnableUser = 99,
	kRestartSample = 100,
	kStopSample = 101,
	kStub102 = 102,
	kStub103 = 103,
	kStub104 = 104,
	kClearScreen = 105,
	kInventoryClear = 106,
	kStub107 = 107,
	kLoadMouse = 108,
	kAttachInventoryObjectToMouse0 = 109,
	kResetMousePointer = 110,
	kInventoryAddObject = 111,
	kInventoryRemoveObject = 112,
	kStub113 = 113,
	kStub114 = 114,
	kStub115 = 115,
	kStub116 = 116,
	kLoadAnimation = 117,
	kLoadSample = 118,
	kSetPhaseVarControlledFlag = 119,
	kPlayerSay120 = 120,
	kStub121 = 121,
	kPlayerSay122 = 122,
	kNPCSayNoSound = 123,
	kNPCSay = 124,
	kPlayerSay125 = 125,
	kStub126 = 126,
	kSetTimer = 127,
	kProcessResetState = 128,
	kSetAnimationZ = 129,
	kSetCycles = 130,
	kSetRandom = 131,
	kSetPeriodic = 132,
	kSetPanAndVolume = 133,
	kSetAnimationPosition = 134,
	kSetPhaseVar = 135,
	kSetAnimationLoop = 136,
	kSetAnimationSpeed = 137,
	kScreenObjectPatchIncRef = 138,
	kScreenObjectPatchDecRef = 139,
	kScreenCheckScreenPatch = 140,
	kGetFreeInventorySpace = 141,
	kSetStringSystemVariable = 142,
	kSetSystemIntegerVariable = 143,
	kGetSavedMouseX = 144,
	kGetSavedMouseY = 145,
	kGetRegionCenterX = 146,
	kGetRegionCenterY = 147,
	kGetCharacterAnimationPhase = 148,
	kGetCharacterX = 149,
	kGetCharacterY = 150,
	kCompareScreenName = 151,
	kGetPictureBaseX = 152,
	kGetPictureBaseY = 153,
	kGetObjectSurfaceX = 154,
	kGetObjectSurfaceY = 155,
	kLoadGame = 156,
	kSaveGame = 157,
	kQuit = 158,
	kStartNewGame = 159,
	kLoadSaveSlotNamePicture = 160,
	kGetSaveGameName = 161,
	kDisableInventory = 162,
	kEnableInventory = 163,
	kLoadPreviousScreen = 164,
	kMoveScreenObject = 165,
	kSetObjectRegionOffset = 166,
	kReturnCurrentInventoryObject = 167,
	kStub168 = 168,
	kGetIntegerSystemVariable = 169,
	kSetDelay = 170,
	kGetRandomNumber = 171,
	kSetSampleVolume = 172,
	kStub173 = 173,
	kStub174 = 174,
	kAppendToSharedStorage = 175,
	kCloneName = 176,
	kAppendNameToSharedStorage = 177,
	kGetCloneVar = 178,
	kSetCloneVar = 179,
	kGetObjectId = 180,
	kStub181 = 181,
	kSetTileSize = 182,
	kGenerateRegion = 183,
	kSetObjectTile = 184,
	kGetMaxInventorySize = 185,
	kInventoryHasObject = 186,
	kAppendInventoryObjectNameToSharedSpace = 187,
	kSetObjectText = 188,
	kInventoryFindObjectByName = 189,
	kSetObjectScale = 190,
	kDisableMouseAreas = 191,
	kObjectIgnoreRegion = 192,
	kRemoveGapsFromInventory = 193,
	kSampleAmbient = 194,
	kGetObjectPictureWidth = 195,
	kGetObjectPictureHeight = 196,
	kSetRotation = 197,
	kLoadPicture = 198,
	kStub199 = 199,
	kSetTileIndex = 200,
	kSetThrowHandler = 201,
	kSetUseOnHandler = 202,
	kPlayFilm = 203,
	kStub204 = 204,
	kAddMouseArea = 205,
	kModifyMouseArea = 206,
	kSetRain = 207,
	kFogOnCharacter = 208,
	kObjectRegisterUserUseHandler = 209,
	kStub210 = 210,
	kStub211 = 211,
	kSetSampleVolumeAndPan = 212,
	kStub213 = 213,
	kAddSampleToSoundGroup = 214,
	kClearSoundGroup = 215,
	kStub216 = 216,
	kStub217 = 217,
	kSetRainDensity = 218,
	kLeaveCharacterEx = 219,
	kStopCharacter = 220,
	kRestartAnimation = 221,
	kSignalAnimationEnd = 222,
	kSetShadowIntensity = 223,
	kSetNPCTellNotifyVar = 224,
	kPauseAnimation = 225,
	kFadeObject = 226,
	kLoadFont = 227,
	kMoveCharacterNoUserMove = 228,
	kOnKey = 229,
	kStub230 = 230,
	kStub231 = 231,
	kStub232 = 232,
	kObjectFreePictureAndAnimation = 233,
	kGetSampleVolume = 234,
	kFadeScreen = 235,
	kUserEnabled = 236,
	kAnimationNextFrame = 237,
	kInventoryHasObjectByName = 238,
	kStub239 = 239,
	kLoadDialog = 240,
	kStub241 = 241,
	kHasGlobal = 242,
	kStub243 = 243,
	kSetCharacterNotifyVars = 244,
	kAttachInventoryObjectToMouse1 = 245,
	kStub246 = 246,
	kSetDialogForNextFilm = 247,
	kSetCamera = 252,
	kStub251 = 251,
	kCharacterStub253 = 253,
	kStub257 = 257,
	kStub258 = 258,
	kSetFog = 263,
	kStub264 = 264,
	kStub265 = 265,
	kStub266 = 266,
	kStub267 = 267,
	kStub275 = 275,
	kStub276 = 276,
	kStub278 = 278,
	kStub279 = 279,
	kStub280 = 280,
	kStub284 = 284,
	kStub291 = 291,
	kStub292 = 292,
};

#define AGDS_OPCODE_LIST(OP, OP_C, OP_B, OP_W, OP_U, OP_UD, OP_UU)                      \
	OP_UU(kEnter, enter)                                                                \
	OP_W(kJumpZImm16, jumpz)                                                            \
	OP_W(kJumpImm16, jump)                                                              \
	OP(kPop, popNoResult)                                                               \
	OP(kDup, dup)                                                                       \
	OP(kExitProcess, exitProcess)                                                       \
	OP(kSuspendProcess, suspend)                                                        \
	OP_UD(kPushImm32, push)                                                             \
	OP_C(kPushImm8, push)                                                               \
	OP_W(kPushImm16, push)                                                              \
	OP_C(kPushImm8_2, push2)                                                            \
	OP_W(kPushImm16_2, push2)                                                           \
	OP_B(kGetGlobalImm8, getGlobal)                                                     \
	OP(kPostIncrementGlobal, postIncrementGlobal)                                       \
	OP(kPostDecrementGlobal, postDecrementGlobal)                                       \
	OP(kIncrementGlobalByTop, incrementGlobalByTop)                                     \
	OP(kDecrementGlobalByTop, decrementGlobalByTop)                                     \
	OP(kMultiplyGlobalByTop, multiplyGlobalByTop)                                       \
	OP(kDivideGlobalByTop, divideGlobalByTop)                                           \
	OP(kModGlobalByTop, modGlobalByTop)                                                 \
	OP(kShlGlobalByTop, shlGlobalByTop)                                                 \
	OP(kShrGlobalByTop, shrGlobalByTop)                                                 \
	OP(kAndGlobalByTop, andGlobalByTop)                                                 \
	OP(kOrGlobalByTop, orGlobalByTop)                                                   \
	OP(kXorGlobalByTop, xorGlobalByTop)                                                 \
	OP(kEquals, equals)                                                                 \
	OP(kNotEquals, notEquals)                                                           \
	OP(kGreater, greater)                                                               \
	OP(kLess, less)                                                                     \
	OP(kGreaterOrEquals, greaterOrEquals)                                               \
	OP(kLessOrEquals, lessOrEquals)                                                     \
	OP(kAdd, add)                                                                       \
	OP(kSub, sub)                                                                       \
	OP(kMul, mul)                                                                       \
	OP(kDiv, div)                                                                       \
	OP(kMod, mod)                                                                       \
	OP(kSetGlobalWithTop, setGlobalWithTop)                                             \
	OP(kSetGlobal, setGlobal)                                                           \
	OP(kBoolOr, boolOr)                                                                 \
	OP(kBoolAnd, boolAnd)                                                               \
	OP(kAnd, bitAnd)                                                                    \
	OP(kOr, bitOr)                                                                      \
	OP(kXor, bitXor)                                                                    \
	OP(kNot, bitNot)                                                                    \
	OP(kShl, shl)                                                                       \
	OP(kShr, shr)                                                                       \
	OP(kBoolNot, boolNot)                                                               \
	OP(kNegate, negate)                                                                 \
	OP_U(kObjectInitialise, initialise)                                                 \
	OP_U(kObjectRegisterLookHandler, onLook)                                            \
	OP_U(kObjectRegisterUseHandler, onUse)                                              \
	OP_U(kObjectRegisterHandlerC1, onObjectC1)                                          \
	OP_U(kObjectRegisterCharacterTrap, onCharacterTrap)                                 \
	OP_U(kObjectRegisterHandlerBD, onObjectBD)                                          \
	OP(kLoadMouseCursorFromObject, loadMouseCursorFromObject)                           \
	OP(kLoadRegionFromObject, loadRegionFromObject)                                     \
	OP(kLoadPictureFromObject, loadPictureFromObject)                                   \
	OP(kLoadAnimationFromObject, loadAnimationFromObject)                               \
	OP(kHideCharacter, hideCharacter)                                                   \
	OP(kShowCharacter, showCharacter)                                                   \
	OP(kEnableCharacter, enableCharacter)                                               \
	OP(kMoveCharacterUserMove, moveCharacterUserMove)                                   \
	OP(kLeaveCharacter, leaveCharacter)                                                 \
	OP(kSetCharacter, setCharacter)                                                     \
	OP(kSetCharacterDirection, setCharacterDirection)                                   \
	OP(kPointCharacter, pointCharacter)                                                 \
	OP(kDisableUser, disableUser)                                                       \
	OP(kEnableUser, enableUser)                                                         \
	OP(kRestartSample, restartSample)                                                   \
	OP(kStopSample, stopSample)                                                         \
	OP(kStub102, stub102)                                                               \
	OP(kClearScreen, clearScreen)                                                       \
	OP(kInventoryClear, inventoryClear)                                                 \
	OP(kLoadMouse, loadMouse)                                                           \
	OP(kResetMousePointer, resetMousePointer)                                           \
	OP(kInventoryAddObject, inventoryAddObject)                                         \
	OP(kInventoryRemoveObject, inventoryRemoveObject)                                   \
	OP_U(kObjectRegisterUseObjectHandler, onObjectUse)                                  \
	OP(kObjectPatchSetText, objectPatchSetText)                                         \
	OP(kObjectPatchSetRegionName, objectPatchSetRegionName)                             \
	OP(kScreenPatchSetRegionName, screenPatchSetRegionName)                             \
	OP(kAnimateCharacter, animateCharacter)                                             \
	OP(kLoadCharacter, loadCharacter)                                                   \
	OP(kAssociateCharacter, associateCharacter)                                         \
	OP(kSetObjectZ, setObjectZ)                                                         \
	OP(kSetScreenBackground, setScreenBackground)                                       \
	OP(kLoadTextFromObject, loadTextFromObject)                                         \
	OP(kCompareScreenName, compareScreenName)                                           \
	OP(kScreenSetZNearFar, screenSetZNearFar)                                           \
	OP(kScreenLoadObject, loadScreenObject)                                             \
	OP(kScreenLoadRegion, loadScreenRegion)                                             \
	OP(kScreenCloneObject, cloneObject)                                                 \
	OP(kSetNextScreen, setNextScreen)                                                   \
	OP(kSetNextScreenSaveOrLoad, setNextScreenSaveOrLoad)                               \
	OP(kScreenRemoveObject, removeScreenObject)                                         \
	OP(kLoadAnimation, loadAnimation)                                                   \
	OP(kLoadSample, loadSample)                                                         \
	OP(kSetPhaseVarControlledFlag, setPhaseVarControlledFlag)                           \
	OP(kPlayerSay120, playerSay120)                                                     \
	OP(kPlayerSay122, playerSay122)                                                     \
	OP(kPlayerSay125, playerSay125)                                                     \
	OP(kNPCSay, npcSay)                                                                 \
	OP(kNPCSayNoSound, npcSayNoSound)                                                   \
	OP(kSetTimer, setTimer)                                                             \
	OP(kProcessResetState, resetState)                                                  \
	OP(kSetAnimationZ, setAnimationZ)                                                   \
	OP(kSetCycles, setCycles)                                                           \
	OP(kSetRandom, setRandom)                                                           \
	OP(kSetPeriodic, setPeriodic)                                                       \
	OP(kSetPanAndVolume, setPanAndVolume)                                               \
	OP(kSetAnimationPosition, setAnimationPosition)                                     \
	OP(kSetPhaseVar, setPhaseVar)                                                       \
	OP(kSetAnimationLoop, setAnimationLoop)                                             \
	OP(kSetAnimationSpeed, setAnimationSpeed)                                           \
	OP(kScreenObjectPatchIncRef, screenObjectPatchIncRef)                               \
	OP(kScreenObjectPatchDecRef, screenObjectPatchDecRef)                               \
	OP(kGetSavedMouseX, getSavedMouseX)                                                 \
	OP(kGetSavedMouseY, getSavedMouseY)                                                 \
	OP(kScreenCheckScreenPatch, checkScreenPatch)                                       \
	OP(kGetFreeInventorySpace, getInventoryFreeSpace)                                   \
	OP(kSetStringSystemVariable, setStringSystemVariable)                               \
	OP(kSetSystemIntegerVariable, setIntegerSystemVariable)                             \
	OP(kGetRegionCenterX, getRegionCenterX)                                             \
	OP(kGetRegionCenterY, getRegionCenterY)                                             \
	OP(kGetCharacterAnimationPhase, getCharacterAnimationPhase)                         \
	OP(kGetCharacterX, getCharacterX)                                                   \
	OP(kGetCharacterY, getCharacterY)                                                   \
	OP(kGetIntegerSystemVariable, getIntegerSystemVariable)                             \
	OP(kGetRandomNumber, getRandomNumber)                                               \
	OP(kAppendToSharedStorage, appendToSharedStorage)                                   \
	OP(kAppendNameToSharedStorage, appendNameToSharedStorage)                           \
	OP(kCloneName, cloneName)                                                           \
	OP(kGetCloneVar, getCloneVar)                                                       \
	OP(kSetCloneVar, setCloneVar)                                                       \
	OP(kGetPictureBaseX, getPictureBaseX)                                               \
	OP(kGetPictureBaseY, getPictureBaseY)                                               \
	OP(kGetObjectSurfaceX, getObjectSurfaceX)                                           \
	OP(kGetObjectSurfaceY, getObjectSurfaceY)                                           \
	OP(kLoadGame, loadGame)                                                             \
	OP(kSaveGame, saveGame)                                                             \
	OP(kLoadSaveSlotNamePicture, loadSaveSlotNamePicture)                               \
	OP(kGetSaveGameName, getSaveGameName)                                               \
	OP(kSetObjectRegionOffset, setObjectRegionOffset)                                   \
	OP(kSetDelay, setDelay)                                                             \
	OP(kSetSampleVolume, setSampleVolume)                                               \
	OP(kStub173, stub173)                                                               \
	OP(kStub174, stub174)                                                               \
	OP(kObjectIgnoreRegion, objectIgnoreRegion)                                         \
	OP(kQuit, quit)                                                                     \
	OP(kStartNewGame, startNewGame)                                                     \
	OP(kDisableInventory, disableInventory)                                             \
	OP(kEnableInventory, enableInventory)                                               \
	OP(kLoadPreviousScreen, loadPreviousScreen)                                         \
	OP(kMoveScreenObject, moveScreenObject)                                             \
	OP(kGetObjectId, getObjectId)                                                       \
	OP(kSetTileSize, setTileSize)                                                       \
	OP(kGenerateRegion, generateRegion)                                                 \
	OP(kGetMaxInventorySize, getMaxInventorySize)                                       \
	OP(kAppendInventoryObjectNameToSharedSpace, appendInventoryObjectNameToSharedSpace) \
	OP(kSetObjectTile, setObjectTile)                                                   \
	OP(kInventoryHasObject, inventoryHasObject)                                         \
	OP(kReturnCurrentInventoryObject, returnCurrentInventoryObject)                     \
	OP(kSetObjectText, setObjectText)                                                   \
	OP(kSetObjectScale, setObjectScale)                                                 \
	OP(kDisableMouseAreas, disableMouseAreas)                                           \
	OP(kRemoveGapsFromInventory, removeGapsFromInventory)                               \
	OP(kSampleAmbient, sampleAmbient)                                                   \
	OP(kGetObjectPictureWidth, getObjectPictureWidth)                                   \
	OP(kGetObjectPictureHeight, getObjectPictureHeight)                                 \
	OP(kLoadPicture, loadPicture)                                                       \
	OP(kSetRotation, setRotation)                                                       \
	OP(kStub199, stub199)                                                               \
	OP(kSetSampleVolumeAndPan, setSampleVolumeAndPan)                                   \
	OP(kAddSampleToSoundGroup, addSampleToSoundGroup)                                   \
	OP(kClearSoundGroup, clearSoundGroup)                                               \
	OP(kStub216, stub216)                                                               \
	OP(kStub217, stub217)                                                               \
	OP(kStopCharacter, stopCharacter)                                                   \
	OP(kLeaveCharacterEx, leaveCharacterEx)                                             \
	OP(kRestartAnimation, restartAnimation)                                             \
	OP(kAnimationNextFrame, animationNextFrame)                                         \
	OP(kSignalAnimationEnd, signalAnimationEnd)                                         \
	OP(kSetShadowIntensity, setShadowIntensity)                                         \
	OP(kSetNPCTellNotifyVar, setNPCTellNotifyVar)                                       \
	OP(kPauseAnimation, pauseAnimation)                                                 \
	OP(kFadeObject, fadeObject)                                                         \
	OP(kLoadFont, loadFont)                                                             \
	OP_U(kSetThrowHandler, setThrowHandler)                                             \
	OP_U(kSetUseOnHandler, setUseOnHandler)                                             \
	OP(kPlayFilm, playFilm)                                                             \
	OP(kAddMouseArea, addMouseArea)                                                     \
	OP(kSetRain, setRain)                                                               \
	OP(kSetRainDensity, setRainDensity)                                                 \
	OP(kFogOnCharacter, fogOnCharacter)                                                 \
	OP(kSetTileIndex, setTileIndex)                                                     \
	OP(kModifyMouseArea, modifyMouseArea)                                               \
	OP_U(kObjectRegisterUserUseHandler, onObjectUserUse)                                \
	OP(kMoveCharacterNoUserMove, moveCharacterNoUserMove)                               \
	OP_U(kOnKey, onKey)                                                                 \
	OP(kGetSampleVolume, getSampleVolume)                                               \
	OP(kStub231, stub231)                                                               \
	OP(kObjectFreePictureAndAnimation, objectFreePictureAndAnimation)                   \
	OP(kFadeScreen, fadeScreen)                                                         \
	OP(kUserEnabled, userEnabled)                                                       \
	OP(kSetCharacterNotifyVars, setCharacterNotifyVars)                                 \
	OP(kInventoryFindObjectByName, inventoryFindObjectByName)                           \
	OP(kInventoryHasObjectByName, inventoryHasObjectByName)                             \
	OP(kLoadDialog, loadDialog)                                                         \
	OP(kStub241, stub241)                                                               \
	OP(kHasGlobal, hasGlobal)                                                           \
	OP(kAttachInventoryObjectToMouse0, attachInventoryObjectToMouse0)                   \
	OP(kAttachInventoryObjectToMouse1, attachInventoryObjectToMouse1)                   \
	OP(kSetDialogForNextFilm, setDialogForNextFilm)                                     \
	OP(kCharacterStub253, characterStub253)                                             \
	OP(kStub251, stub251)                                                               \
	OP(kStub257, stub257)                                                               \
	OP(kStub258, stub258)                                                               \
	OP(kStub264, stub264)                                                               \
	OP(kStub265, stub265)                                                               \
	OP(kStub266, stub266)                                                               \
	OP(kStub267, stub267)                                                               \
	OP(kStub275, stub275)                                                               \
	OP(kStub276, stub276)                                                               \
	OP(kSetCamera, setCamera)                                                           \
	OP(kSetFog, setFog)                                                                 \
	OP(kStub278, stub278)                                                               \
	OP(kStub279, stub279)                                                               \
	OP(kStub280, stub280)                                                               \
	OP(kStub284, stub284)                                                               \
	OP(kStub291, stub291)                                                               \
	OP(kStub292, stub292)

} // namespace AGDS

#endif
