#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:34:54 
# _test-domain.sh

### P A R A M S

MYVERBOSE=
redirection='> /dev/null'
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	redirection=
	shift
fi

### I N C L U D E

. ./_include.sh

### S T A R T

echo "--------------------------------------------------------------------------------"
echo "DOMAIN TEST"
echo "--------------------------------------------------------------------------------"

echo "+DOMAIN"
domain=`wbinfo --own-domain`
if [ ! -z "${domain}" ]; then
	echo "${domain}"
else
	echo "unknown"
fi

echo "+CHECK JOIN TO DOMAIN ${MYREALM}"
e="net ads testjoin -P ${redirection} 2>&1 "
#echo ${e}
eval ${e}
if [ "$?" = "0" ]; then
	echo "joined to domain"
	echo "+DOMAIN INFORMATION"
	net ads info | sed 's/[[:space:]]\+/ /g' | grep -v '^$'
	if [ ! -z "${MYVERBOSE}" ]; then
		echo "+LDAP"
		net ads lookup ldap | sed 's/[[:space:]]\+/ /g' | grep -v '^$'
		echo "+KDC"
		net ads lookup kdc | sed 's/[[:space:]]\+/ /g' | grep -v '^$'
		echo "+DC"
		net ads lookup dc | sed 's/[[:space:]]\+/ /g' | grep -v '^$'
		echo "+MASTER"
		net ads lookup master | sed 's/[[:space:]]\+/ /g' | grep -v '^$'
		echo "+CHECK TRUST SECRET"
		wbinfo --check-secret | sed 's/[[:space:]]\+/ /g' | grep -v '^$'
	fi
else
	echo "not joined to domain" >&2
	exit 1
fi

exit 0
