#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-06-07 10:53:11  
# _test-domain.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi

### I N C L U D E

. ./_include.sh

### S T A R T

echo "--------------------------------------------------------------------------------"
echo "DOMAIN INFO"
echo "--------------------------------------------------------------------------------"

echo "+WINBIND"
echo "+ping winbind"
if ! wbinfo --ping > /dev/null; then
	echo "winbind is not alive: start winbind daemon"
	exit 1
fi
echo "winbind is alive"

echo "+DOMAINS"
echo "+all domains"
wbinfo --all-domains
 
echo "+DOMAIN INFO"
echo "+own domain"
domain=
if wbinfo --own-domain; then
	domain=`wbinfo --own-domain`
fi
if [ ! -z "${domain}" ]; then
	echo "+domain info"
	wbinfo --domain-info "${domain}" | sed 's/[[:space:]]\+/ /g'
fi
echo "+trusted domains"
wbinfo --trusted-domains
echo "+sequence numbers of all known domains"
wbinfo --sequence

echo "+DOMAIN EXTRA INFOS"
echo "+separator"
wbinfo --separator

exit 0
