use serde_with::skip_serializing_none;
use struct_patch::Patch;

#[derive(Default, Patch)]
#[patch(attribute(derive(serde::Serialize, Debug, Default)))]
#[patch(attribute(skip_serializing_none))]
struct Item {
    field_bool: bool,
    field_int: usize,
    field_string: String,
}

// Generated by Patch derive macro
//
// #[derive(Debug, Default)] // pass by patch(attribute(...))
// #[skip_serializing_none] // pass by patch(attribute(...))
// struct ItemPatch {  // pass by patch(name = ...)
//     field_bool: Option<bool>,
//     field_int: Option<usize>,
//     field_string: Option<String>,
// }

fn main() {
    let patch: ItemPatch = Item::new_empty_patch();

    assert_eq!(
        format!("{patch:?}"),
        "ItemPatch { field_bool: None, field_int: None, field_string: None }"
    );
}
