require 'gem2deb/rake/testtask'

rejectlist = %w(
  test/test_inet_diag_socket.rb
  test/test_linux_all_tcp_listen_stats.rb
  test/test_linux_ipv6.rb
  test/test_watcher.rb
)

# This test passes fine in ppc64el when executed separately but when it is
# executed in conjunction with test/test_aggregate_pmq.rb it fails. This was
# causing a FTBFS.
if RUBY_PLATFORM == "powerpc64le-linux-gnu"
  rejectlist << 'test/test_last_data_recv_unicorn.rb'
end

Gem2Deb::Rake::TestTask.new do |t|
  t.libs = ['test']
  t.test_files = FileList['test/**/test_*.rb'] - rejectlist
end
