### New features

* [#5753](https://github.com/rubocop/rubocop/pull/5753): Add new `Performance/UnneededSort` cop. ([@parkerfinch][])
* Add new `Lint/SafeNavigationConsistency` cop. ([@rrosenblum][])

### Bug fixes

* [#5759](https://github.com/rubocop/rubocop/pull/5759): Fix `Performance/RegexpMatch` cop not correcting negated match operator. ([@bdewater][])
* [#5726](https://github.com/rubocop/rubocop/issues/5726): Fix false positive for `:class_name` option in Rails/InverseOf cop. ([@bdewater][])
* [#5686](https://github.com/rubocop/rubocop/issues/5686): Fix a regression for `Style/SymbolArray` and `Style/WordArray` for multiline Arrays. ([@istateside][])
* [#5730](https://github.com/rubocop/rubocop/pull/5730): Stop `Rails/InverseOf` cop allowing `inverse_of: nil` to opt-out. ([@bdewater][])
* [#5561](https://github.com/rubocop/rubocop/issues/5561): Fix `Lint/ShadowedArgument` false positive with shorthand assignments. ([@akhramov][])
* [#5403](https://github.com/rubocop/rubocop/issues/5403): Fix `Naming/HeredocDelimiterNaming` blacklist patterns. ([@mcfisch][])
* [#4298](https://github.com/rubocop/rubocop/issues/4298): Fix auto-correction of `Performance/RegexpMatch` to produce code that safe guards against the receiver being `nil`. ([@rrosenblum][])
* [#5738](https://github.com/rubocop/rubocop/issues/5738): Make `Rails/HttpStatus` ignoring hash order to fix false negative. ([@pocke][])
* [#5720](https://github.com/rubocop/rubocop/pull/5720): Fix false positive for `Style/EmptyLineAfterGuardClause` when guard clause is after heredoc. ([@koic][])
* [#5760](https://github.com/rubocop/rubocop/pull/5760): Fix incorrect offense location for `Style/EmptyLineAfterGuardClause` when guard clause is after heredoc argument. ([@koic][])
* [#5764](https://github.com/rubocop/rubocop/pull/5764): Fix `Style/Unpackfirst` false positive of `unpack('h*').take(1)`. ([@parkerfinch][])
* [#5766](https://github.com/rubocop/rubocop/issues/5766): Update `Style/FrozenStringLiteralComment` auto-correction to insert a new line between the comment and the code. ([@rrosenblum][])
* [#5551](https://github.com/rubocop/rubocop/issues/5551): Fix `Lint/Void` not detecting void context in blocks with single expression. ([@Darhazer][])

### Changes

* [#5752](https://github.com/rubocop/rubocop/pull/5752): Add `String#delete_{prefix,suffix}` to Lint/Void cop. ([@bdewater][])
* [#5734](https://github.com/rubocop/rubocop/pull/5734): Add `by`, `on`, `in` and `at` to allowed names of `Naming/UncommunicativeMethodParamName` cop in default config. ([@AlexWayfer][])
* [#5666](https://github.com/rubocop/rubocop/issues/5666): Add spaces as an `EnforcedStyle` option to `Layout/SpaceInsideParens`, allowing you to enforce spaces inside of parentheses. ([@joshuapinter][])
* [#4257](https://github.com/rubocop/rubocop/issues/4257): Allow specifying module name in `Metrics/BlockLength`'s `ExcludedMethods` configuration option. ([@akhramov][])
* [#4753](https://github.com/rubocop/rubocop/issues/4753): Add `IgnoredMethods` option to `Style/MethodCallWithoutArgsParentheses` cop. ([@Darhazer][])
* [#4517](https://github.com/rubocop/rubocop/issues/4517): Add option to allow trailing whitespaces inside heredoc strings. ([@Darhazer][])
* [#5652](https://github.com/rubocop/rubocop/issues/5652): Make `Style/OptionHash` aware of implicit parameter passing to super. ([@Wei-LiangChew][])
* [#5451](https://github.com/rubocop/rubocop/issues/5451): When using --auto-gen-config, do not output offenses unless the --output-offenses flag is also passed. ([@drewpterry][])

[@parkerfinch]: https://github.com/parkerfinch
[@rrosenblum]: https://github.com/rrosenblum
[@bdewater]: https://github.com/bdewater
[@istateside]: https://github.com/istateside
[@akhramov]: https://github.com/akhramov
[@mcfisch]: https://github.com/mcfisch
[@pocke]: https://github.com/pocke
[@koic]: https://github.com/koic
[@Darhazer]: https://github.com/Darhazer
[@AlexWayfer]: https://github.com/AlexWayfer
[@joshuapinter]: https://github.com/joshuapinter
[@Wei-LiangChew]: https://github.com/Wei-LiangChew
[@drewpterry]: https://github.com/drewpterry
