#ifndef RIPOFFTRACKLIST_H
#define RIPOFFTRACKLIST_H
#include "lib/RipOff.h"
#include "lib/RipOffTrack.h"

/* simple linked list node containing a RipOffTrack and a next pointer*/
typedef struct RipOffTrackListNode_ * RipOffTrackListNode;
struct RipOffTrackListNode_
{
	RipOffTrack track; 
	RipOffTrackListNode next;
};

/* beginning is the first node in the list, and endtoadd is where the next node will be added in 
   the list */
struct RipOffTrackList_
{
	RipOffTrackListNode beginning;
	RipOffTrackListNode end;
	RipOffTrackListNode current;
	int size;
};
typedef struct RipOffTrackList_ * RipOffTrackList;

RipOffTrackList ripoff_track_list_new();

RipOffTrack ripoff_track_list_start(RipOffTrackList list);

RipOffTrack ripoff_track_list_next_track(RipOffTrackList list);

void ripoff_track_list_add_track(RipOffTrackList list, RipOffTrack track);

gint ripoff_track_list_get_size(RipOffTrackList list);

gboolean ripoff_track_list_is_empty(RipOffTrackList list);

/* frees memory used by the track list */
void ripoff_track_list_destroy(RipOffTrackList list);

#endif

