#!/bin/bash

content=$(
    cat <<END
<!-- this part generated by update-readme.sh -->
$(cargo run --bin rga -- --rga-list-adapters)

$(help2man -N "cargo run --bin rga --" | pandoc -f man -t markdown --markdown-headings=atx | rg --multiline "## USAGE:(.|\n)*")
<!-- end of part generated by update-readme.sh -->
END
)

rg --passthrough --multiline '.*update-readme.sh(.|\n)*update-readme.sh.*' README.md --replace "$content" | sponge README.md
prettier --write README.md
