#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "poiseuille.h"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo  omega (argv[1]);
  string sys_coord = omega.coordinate_system_name();
  Float cr = omega.xmax()[1];
  space Xh (omega, "P2", "vector");
  Xh.block ("upstream");
  Xh.block ("wall");
  Xh[1].block ("axis");
  Xh[1].block ("downstream");
  space Qh  (omega, "P1");
  space Wh  (omega["upstream"], "P2");
  trial u (Xh), p (Qh);
  test  v (Xh), q (Qh);
  form a  = integrate (2*ddot(D(u),D(v)));
  form b  = integrate (-div(u)*q);
  form mp = integrate (p*q);
  solver_abtb stokes (a.uu(), b.uu(), mp.uu());
  field uh (Xh, 0);
  field ph (Qh, 0);
  uh[0]["upstream"] = interpolate (Wh, u_poiseuille(cr,sys_coord));
  stokes.solve (-(a.ub()*uh.b()), -(b.ub()*uh.b()), uh.set_u(), ph.set_u());
  dout << catchmark("inv_lambda") << 0 << endl
       << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
