% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.units}
\alias{plot.units}
\alias{make_unit_label}
\title{create axis label with appropriate labels}
\usage{
make_unit_label(lab, u, sep = units_options("sep"),
  group = units_options("group"), parse = units_options("parse"))

\method{plot}{units}(x, y, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{lab}{length one character; name of the variable to plot}

\item{u}{vector of class \code{units}}

\item{sep}{length two character vector, defaulting to \code{c("~","~")}, with
the white space between unit name and unit symbols, and between subsequent
symbols.}

\item{group}{length two character vector with grouping symbols, e.g.
\code{c("(",")")} for parenthesis, or \code{c("","")} for no group symbols}

\item{parse}{logical; indicates whether a parseable expression should be
returned (typically needed for super scripts), or a simple character string
without special formatting.}

\item{x}{object of class units, to plot along the x axis, or, if y is missing, along the y axis}

\item{y}{object to plot along the y axis, or missing}

\item{xlab}{character; x axis label}

\item{ylab}{character; y axis label}

\item{...}{other parameters, passed on to \link{plot.default}}
}
\description{
create axis label with appropriate labels

plot unit objects
}
\details{
\link{units_options} can be used to set and change the defaults for
  \code{sep}, \code{group} and \code{doParse}.
}
\examples{
oldpar = par(mar = par("mar") + c(0, .3, 0, 0))
displacement = mtcars$disp * ud_units[["in"]]^3
# an example that would break if parse were (default) TRUE, since 'in' is a reserved word:
units_options(parse=FALSE)
make_unit_label("displacement", displacement)
units_options(parse=TRUE)
units(displacement) = with(ud_units, cm^3)
weight = mtcars$wt * 1000 * with(ud_units, lb)
units(weight) = with(ud_units, kg)
plot(weight, displacement)
units_options(group = c("(", ")") )  # parenthesis instead of square brackets
plot(weight, displacement)
units_options(sep = c("~~~", "~"), group = c("", ""))  # no brackets; extra space
plot(weight, displacement)
units_options(sep = c("~", "~~"), group = c("[", "]"))
gallon = as_units("gallon")
consumption = mtcars$mpg * with(ud_units, mi/gallon)
units(consumption) = with(ud_units, km/l)
plot(displacement, consumption) # division in consumption
units_options(negative_power = TRUE) # division becomes ^-1
plot(displacement, consumption)
plot(1/displacement, 1/consumption)
par(oldpar)
}
