% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smote_impl.R
\name{smote}
\alias{smote}
\title{SMOTE algorithm}
\usage{
smote(df, var, k = 5, over_ratio = 1)
}
\arguments{
\item{df}{data.frame or tibble. Must have 1 factor variable and remaining
numeric variables.}

\item{var}{Character, name of variable containing factor variable.}

\item{k}{An integer. Number of nearest neighbor that are used
to generate the new examples of the minority class.}

\item{over_ratio}{A numeric value for the ratio of the
majority-to-minority frequencies. The default value (1) means
that all other levels are sampled up to have the same
frequency as the most occurring level. A value of 0.5 would mean
that the minority levels will have (at most) (approximately)
half as many rows than the majority level.}
}
\value{
A data.frame or tibble, depending on type of \code{df}.
}
\description{
SMOTE generates new examples of the minority class using nearest neighbors
of these cases.
}
\details{
The parameter \code{neighbors} controls the way the new examples are created.
For each currently existing minority class example X new examples will be
created (this is controlled by the parameter \code{over_ratio} as mentioned
above). These examples will be generated by using the information from the
\code{neighbors} nearest neighbor of each example of the minority class.
The parameter \code{neighbors} controls how many of these neighbor are used.
All columns used in this function must be numeric with no missing data.
}
\examples{
smote(circle_example, var = "class")

smote(circle_example, var = "class", k = 10)

smote(circle_example, var = "class", over_ratio = 0.8)
}
\references{
Chawla, N. V., Bowyer, K. W., Hall, L. O., and Kegelmeyer,
W. P. (2002). Smote: Synthetic minority over-sampling technique.
Journal of Artificial Intelligence Research, 16:321-357.
}
