% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot-value.R
\name{expect_snapshot_value}
\alias{expect_snapshot_value}
\title{Snapshot testing for values}
\usage{
expect_snapshot_value(
  x,
  style = c("json", "json2", "deparse", "serialize"),
  cran = FALSE,
  tolerance = testthat_tolerance(),
  ...,
  variant = NULL
)
}
\arguments{
\item{x}{Code to evaluate.}

\item{style}{Serialization style to use:
\itemize{
\item \code{json} uses \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} and \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}. This
produces the simplest output but only works for relatively simple
objects.
\item \code{json2} uses \code{\link[jsonlite:serializeJSON]{jsonlite::serializeJSON()}} and \code{\link[jsonlite:serializeJSON]{jsonlite::unserializeJSON()}}
which are more verbose but work for a wider range of type.
\item \code{deparse} uses \code{\link[=deparse]{deparse()}}, which generates a depiction of the object
using R code.
\item \code{serialize()} produces a binary serialization of the object using
\code{\link[=serialize]{serialize()}}. This is all but guaranteed to work for any R object,
but produces a completely opaque serialization.
}}

\item{cran}{Should these expectations be verified on CRAN? By default,
they are not, because snapshot tests tend to be fragile because they
often rely on minor details of dependencies.}

\item{tolerance}{Numerical tolerance: any differences (in the sense of
\code{\link[base:all.equal]{base::all.equal()}}) smaller than this value will be ignored.

The default tolerance is \code{sqrt(.Machine$double.eps)}, unless long doubles
are not available, in which case the test is skipped.}

\item{...}{Passed on to \code{\link[waldo:compare]{waldo::compare()}} so you can control the details of
the comparison.}

\item{variant}{If non-\code{NULL}, results will be saved in
\verb{_snaps/\{variant\}/\{test.md\}}, so \code{variant} must be a single string
suitable for use as a directory name.

You can use variants to deal with cases where the snapshot output varies
and you want to capture and test the variations. Common use cases include
variations for operating system, R version, or version of key dependency.
Variants are an advanced feature. When you use them, you'll need to
carefully think about your testing strategy to ensure that all important
variants are covered by automated tests, and ensure that you have a way
to get snapshot changes out of your CI system and back into the repo.}
}
\description{
Captures the result of function, flexibly serializing it into a text
representation that's stored in a snapshot file. See \code{\link[=expect_snapshot]{expect_snapshot()}}
for more details on snapshot testing.
}
