% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscape.R
\name{MixscapeLDA}
\alias{MixscapeLDA}
\title{Linear discriminant analysis on pooled CRISPR screen data.}
\usage{
MixscapeLDA(
  object,
  assay = NULL,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.key = "LDA_",
  seed = 42,
  pc.assay = "PRTB",
  labels = "gene",
  nt.label = "NT",
  npcs = 10,
  verbose = TRUE,
  logfc.threshold = 0.25
)
}
\arguments{
\item{object}{An object of class Seurat.}

\item{assay}{Assay to use for performing Linear Discriminant Analysis (LDA).}

\item{ndims.print}{Number of LDA dimensions to print.}

\item{nfeatures.print}{Number of features to print for each LDA component.}

\item{reduction.key}{Reduction key name.}

\item{seed}{Value for random seed}

\item{pc.assay}{Assay to use for running Principle components analysis.}

\item{labels}{Meta data column with target gene class labels.}

\item{nt.label}{Name of non-targeting cell class.}

\item{npcs}{Number of principle components to use.}

\item{verbose}{Print progress bar.}

\item{logfc.threshold}{Limit testing to genes which show, on average, at least
X-fold difference (log-scale) between the two groups of cells. Default is 0.25
Increasing logfc.threshold speeds up the function, but can miss weaker signals.}
}
\value{
Returns a Seurat object with LDA added in the reduction slot.
}
\description{
This function performs unsupervised PCA on each mixscape class separately and projects each subspace onto all
cells in the data. Finally, it uses the first 10 principle components from each projection as input to lda in MASS package together with mixscape class labels.
}
\concept{mixscape}
