% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getEventProbabilities}
\alias{getEventProbabilities}
\title{Get Event Probabilities}
\usage{
getEventProbabilities(
  time,
  ...,
  accrualTime = C_ACCRUAL_TIME_DEFAULT,
  accrualIntensity = C_ACCRUAL_INTENSITY_DEFAULT,
  kappa = 1,
  piecewiseSurvivalTime = NA_real_,
  lambda2 = NA_real_,
  lambda1 = NA_real_,
  allocationRatioPlanned = 1,
  hazardRatio = NA_real_,
  dropoutRate1 = C_DROP_OUT_RATE_1_DEFAULT,
  dropoutRate2 = C_DROP_OUT_RATE_2_DEFAULT,
  dropoutTime = C_DROP_OUT_TIME_DEFAULT,
  maxNumberOfSubjects = NA_real_
)
}
\arguments{
\item{time}{A numeric vector with time values.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{accrualTime}{The assumed accrual time intervals for the study, default is 
\code{c(0, 12)} (see details).}

\item{accrualIntensity}{A vector of accrual intensities, default is the relative 
intensity \code{0.1} (see details).}

\item{kappa}{The shape parameter of the Weibull distribution, default is \code{1}. 
The Weibull distribution cannot be used for the piecewise definition of the 
survival time distribution. 
Note that the parameters \code{shape} and \code{scale} in \code{\link[stats]{Weibull}} 
are equivalent to \code{kappa} and \code{1 / lambda}, respectively, in rpact.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for the piecewise 
definition of the exponential survival time cumulative distribution function (see details).}

\item{lambda2}{The assumed hazard rate in the reference group, there is no default.
lambda2 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{lambda1}{The assumed hazard rate in the treatment group, there is no default.
lambda1 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{allocationRatioPlanned}{The planned allocation ratio, default is \code{1}. 
If \code{allocationRatioPlanned = 0} is entered, the optimal allocation ratio yielding the 
smallest number of subjects is determined.}

\item{hazardRatio}{The vector of hazard ratios under consideration. 
If the event or hazard rates in both treatment groups are defined, the hazard ratio needs 
not to be specified as it is calculated.}

\item{dropoutRate1}{The assumed drop-out rate in the treatment group, default is \code{0}.}

\item{dropoutRate2}{The assumed drop-out rate in the control group, default is \code{0}.}

\item{dropoutTime}{The assumed time for drop-out rates in the control and the 
treatment group, default is \code{12}.}

\item{maxNumberOfSubjects}{If \code{maxNumberOfSubjects > 0} is specified, 
the end of accrual at specified \code{accrualIntensity} for the specified number of subjects is determined or
   \code{accrualIntensity} is calculated at fixed end of accrual.}
}
\value{
Returns a \code{\link{EventProbabilities}} object.
}
\description{
Returns the event probabilities for specified parameters at given time vector.
}
\details{
For details of the parameters see \code{\link{getSampleSizeSurvival}}.
}
\keyword{internal}
