% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{pairlist2}
\alias{pairlist2}
\title{Collect dynamic dots in a pairlist}
\usage{
pairlist2(...)
}
\arguments{
\item{...}{<\link[=dyn-dots]{dynamic}> Arguments stored in the
pairlist. Empty arguments are preserved.}
}
\description{
This pairlist constructor uses \link[=dyn-dots]{dynamic dots}. Use
it to manually create argument lists for calls or parameter lists
for functions.
}
\examples{
# Unlike `exprs()`, `pairlist2()` evaluates its arguments.
new_function(pairlist2(x = 1, y = 3 * 6), quote(x * y))
new_function(exprs(x = 1, y = 3 * 6), quote(x * y))

# It preserves missing arguments, which is useful for creating
# parameters without defaults:
new_function(pairlist2(x = , y = 3 * 6), quote(x * y))
}
