% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_datasets.R
\name{rdb_datasets}
\alias{rdb_datasets}
\title{Download list of datasets for DBnomics providers.}
\usage{
rdb_datasets(
  provider_code = NULL,
  use_readLines = getOption("rdbnomics.use_readLines"),
  curl_config = getOption("rdbnomics.curl_config"),
  simplify = FALSE,
  ...
)
}
\arguments{
\item{provider_code}{Character string (default \code{NULL}). DBnomics code
of one or multiple providers. If \code{NULL}, the providers are firstly
dowloaded with the function \code{\link{rdb_providers}} and then the
available datasets are requested.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines} i.e.
through the default R internet connection. This can be used to get round the
error \code{Could not resolve host: api.db.nomics.world}.}

\item{curl_config}{Named list (default \code{NULL}). If not
\code{NULL}, it is used to configure a proxy connection. This
configuration is passed to the function \code{curl_fetch_memory} of the package
\pkg{curl}. A temporary \code{curl_handle} object is created internally
with arguments equal to the provided list in \code{curl_config}.\cr
For \code{curl_fetch_memory} arguments see \code{\link[curl]{curl_fetch}}.
For available curl options see \code{\link[curl]{curl_options}},
\code{names(curl_options())} and
\href{https://curl.haxx.se/libcurl/c/curl_easy_setopt.html}{libcurl}.}

\item{simplify}{Logical (default \code{FALSE}). If \code{TRUE}, when the
datasets are requested for only one provider then a \code{data.table}
is returned, not a list of \code{data.table}s.}

\item{...}{Additionals arguments.}
}
\value{
A named list of \code{data.table}s or a \code{data.table}.
}
\description{
\code{rdb_datasets} downloads the list of available datasets for a selection
of providers (or all of them) from \href{https://db.nomics.world/}{DBnomics}.
}
\details{
By default, the function returns a named list of \code{data.table}s
containing the datasets of the providers from
\href{https://db.nomics.world/}{DBnomics}.
}
\examples{
\dontrun{
rdb_datasets(provider_code = "IMF")

rdb_datasets(provider_code = "IMF", simplify = TRUE)

rdb_datasets(provider_code = c("IMF", "BDF"))

options(rdbnomics.progress_bar_datasets = TRUE)
rdb_datasets()
options(rdbnomics.progress_bar_datasets = FALSE)


rdb_datasets(provider_code = "IMF", use_readLines = TRUE)

rdb_datasets(
  provider_code = "IMF",
  curl_config = list(proxy = "<proxy>", proxyport = <port>)
)
}
}
\seealso{
\code{\link{rdb_providers}}, \code{\link{rdb_last_updates}},
\code{\link{rdb_dimensions}}, \code{\link{rdb_series}}
}
\author{
Sebastien Galais
}
