% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportsMulticore.R
\name{supportsMulticore}
\alias{supportsMulticore}
\title{Check If Forked Processing ("multicore") is Supported}
\usage{
supportsMulticore(...)
}
\arguments{
\item{\dots}{Internal usage only.}
}
\value{
TRUE if forked processing is supported and not disabled,
otherwise FALSE.
}
\description{
Certain parallelization methods in R rely on \emph{forked} processing, e.g.
\code{parallel::mclapply()}, \code{parallel::makeCluster(n, type = "FORK")},
\code{doMC::registerDoMC()}, and \code{future::plan("multicore")}.
Process forking is done by the operating system and support for it in
\R is restricted to Unix-like operating systems such as Linux, Solaris,
and macOS.  R running on Microsoft Windows does not support forked
processing.
In R, forked processing is often referred to as "multicore" processing,
which stems from the 'mc' of the \code{mclapply()} family of functions, which
originally was in a package named \pkg{multicore} which later was
incorporated into the \pkg{parallel} package.
This function checks whether or not forked (aka "multicore") processing
is supported in the current \R session.
}
\section{Support for process forking}{

While R supports forked processing on Unix-like operating system such as
Linux and macOS, it does not on the Microsoft Windows operating system.

For some R environments it is considered unstable to perform parallel
processing based on \emph{forking}.
This is for example the case when using RStudio, cf.
\href{https://github.com/rstudio/rstudio/issues/2597#issuecomment-482187011}{RStudio Inc. recommends against using forked processing when running R from within the RStudio software}.
This function detects when running in such an environment and returns
\code{FALSE}, despite the underlying operating system supports forked processing.
A warning will also be produced informing the user about this the first
time time this function is called in an \R session.
This warning can be disabled by setting R option
\option{parallelly.supportsMulticore.unstable}, or environment variable
\env{R_PARALLELLY_SUPPORTSMULTICORE_UNSTABLE} to \code{"quiet"}.
}

\section{Enable or disable forked processing}{

It is possible to disable forked processing for futures by setting \R
option \option{parallelly.fork.enable} to \code{FALSE}.  Alternatively, one can
set environment variable \env{R_PARALLELLY_FORK_ENABLE} to \code{false}.
Analogously, it is possible to override disabled forking by setting one
of these to \code{TRUE}.
}

\examples{
## Check whether or not forked processing is supported
supportsMulticore()

}
