% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{variance}
\alias{variance}
\alias{variance.numeric}
\alias{variance.matrix}
\alias{covariance.numeric}
\title{Variance}
\usage{
variance(x, ...)

\method{variance}{numeric}(x, ...)

\method{variance}{matrix}(x, ...)

\method{covariance}{numeric}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Additional arguments used by methods.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A generic function for computing the variance of an object.
}
\details{
The implementation of \code{variance()} for numeric variables coerces the input to
a vector then uses \code{\link[stats:cor]{stats::var()}} to compute the variance. This means that,
unlike \code{\link[stats:cor]{stats::var()}}, if \code{variance()} is passed a matrix or a 2-dimensional
array, it will still return the variance (\code{\link[stats:cor]{stats::var()}} returns the
covariance matrix in that case).
}
\seealso{
\code{\link[=variance.distribution]{variance.distribution()}}, \code{\link[=covariance]{covariance()}}
}
