% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memdb.R
\name{memdb_frame}
\alias{memdb_frame}
\alias{tbl_memdb}
\alias{src_memdb}
\title{Create a database table in temporary in-memory database.}
\usage{
memdb_frame(..., .name = unique_table_name())

tbl_memdb(df, name = deparse(substitute(df)))

src_memdb()
}
\arguments{
\item{...}{A set of name-value pairs. Arguments are evaluated sequentially,
so you can refer to previously created elements. These arguments are
processed with \code{\link[rlang:quos]{rlang::quos()}} and support unquote via \code{\link{!!}} and
unquote-splice via \code{\link{!!!}}. Use \code{:=} to create columns that start with a dot.}

\item{df}{Data frame to copy}

\item{name, .name}{Name of table in database: defaults to a random name that's
unlikely to conflict with an existing table.}
}
\description{
\code{memdb_frame()} works like \code{\link[tibble:tibble]{tibble::tibble()}}, but instead of creating a new
data frame in R, it creates a table in \code{\link[=src_memdb]{src_memdb()}}.
}
\examples{
library(dplyr)
df <- memdb_frame(x = runif(100), y = runif(100))
df \%>\% arrange(x)
df \%>\% arrange(x) \%>\% show_query()

mtcars_db <- tbl_memdb(mtcars)
mtcars_db \%>\% count(cyl) \%>\% show_query()
}
