% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year-month-weekday-group}
\alias{year-month-weekday-group}
\alias{calendar_group.clock_year_month_weekday}
\title{Grouping: year-month-weekday}
\usage{
\method{calendar_group}{clock_year_month_weekday}(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[clock_year_month_weekday]}

A year-month-weekday vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
\code{x} grouped at the specified \code{precision}.
}
\description{
This is a year-month-weekday method for the \code{\link[=calendar_group]{calendar_group()}} generic.

Grouping for a year-month-weekday object can be done at any precision except
for \code{"day"}, as long as \code{x} is at least as precise as \code{precision}.
}
\details{
Grouping by \code{"day"} is undefined for a year-month-weekday because there are
two day fields, the weekday and the index, and there is no clear way to
define how to group by that.
}
\examples{
x <- year_month_weekday(2019, 1:12, clock_weekdays$sunday, 1, 00, 05, 05)
x

# Group by 3 months - drops more precise components!
calendar_group(x, "month", n = 3)
}
