% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetic.R
\name{clock-arithmetic}
\alias{clock-arithmetic}
\alias{add_years}
\alias{add_quarters}
\alias{add_months}
\alias{add_weeks}
\alias{add_days}
\alias{add_hours}
\alias{add_minutes}
\alias{add_seconds}
\alias{add_milliseconds}
\alias{add_microseconds}
\alias{add_nanoseconds}
\title{Clock arithmetic}
\usage{
add_years(x, n, ...)

add_quarters(x, n, ...)

add_months(x, n, ...)

add_weeks(x, n, ...)

add_days(x, n, ...)

add_hours(x, n, ...)

add_minutes(x, n, ...)

add_seconds(x, n, ...)

add_milliseconds(x, n, ...)

add_microseconds(x, n, ...)

add_nanoseconds(x, n, ...)
}
\arguments{
\item{x}{\verb{[object]}

An object.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} after performing the arithmetic.
}
\description{
This is the landing page for all clock arithmetic functions. There are
specific sub-pages describing how arithmetic works for different calendars
and time points, which is where you should look for more information.

Calendars are efficient at arithmetic with irregular units of time, such as
month, quarters, or years.
\itemize{
\item \link[=year-month-day-arithmetic]{year-month-day}
\item \link[=year-month-weekday-arithmetic]{year-month-weekday}
\item \link[=year-quarter-day-arithmetic]{year-quarter-day}
\item \link[=year-week-day-arithmetic]{year-week-day}
\item \link[=iso-year-week-day-arithmetic]{iso-year-week-day}
\item \link[=year-day-arithmetic]{year-day}
}

Time points, such as naive-times and sys-times, are efficient at arithmetic
with regular, well-defined units of time, such as days, hours, seconds,
or nanoseconds.
\itemize{
\item \link[=time-point-arithmetic]{time-point}
}

Durations can use any of these arithmetic functions, and return a new
duration with a precision corresponding to the common type of the
input and the function used.
\itemize{
\item \link[=duration-arithmetic]{duration}
}

Weekdays can perform day-based circular arithmetic.
\itemize{
\item \link[=weekday-arithmetic]{weekday}
}

There are also convenience methods for doing arithmetic directly on a
native R date or date-time type:
\itemize{
\item \link[=Date-arithmetic]{dates (Date)}
\item \link[=posixt-arithmetic]{date-times (POSIXct / POSIXlt)}
}
}
\details{
\code{x} and \code{n} are recycled against each other using
\link[vctrs:vector_recycling_rules]{tidyverse recycling rules}.

Months and years are considered "irregular" because some months have more
days then others (28, 29, 30, or 31), and some years have more days than
others (365 or 366).

Days are considered "regular" because they are defined as 86,400 seconds.
}
\examples{
# See each sub-page for more specific examples
x <- year_month_day(2019, 2, 1)
add_months(x, 1)
}
