% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{range.CFTime}
\alias{range.CFTime}
\title{Extreme time series values}
\usage{
\method{range}{CFTime}(x, format = "", bounds = FALSE, ..., na.rm = FALSE)
}
\arguments{
\item{x}{An instance of the \link{CFTime} class.}

\item{format}{A character string with format specifiers, optional. If it is
missing or an empty string, the most economical ISO8601 format is chosen:
"date" when no time information is present in \code{x}, "timestamp" otherwise.
Otherwise a suitable format specifier can be provided.}

\item{bounds}{Logical to indicate if the extremes from the bounds should be
used, if set. Defaults to \code{FALSE}.}

\item{...}{Ignored.}

\item{na.rm}{Ignored.}
}
\value{
Vector of two character representations of the extremes of the time
series.
}
\description{
Character representation of the extreme values in the time series.
}
\examples{
cf <- CFtime("days since 1850-01-01", "julian", 0:364)
range(cf)
range(cf, "\%Y-\%b-\%e")
}
