% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUESS_CV.R
\name{GUESS_CV}
\alias{GUESS_CV}
\title{GUESS_CV}
\usage{
GUESS_CV(actual, predicted, n_folds = 10, method_of_prediction = 2, seed,
  input)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{n_folds}{number of folds for the cross-validation, Default: 10}

\item{method_of_prediction}{PARAM_DESCRIPTION, Default: 2}

\item{seed}{random seed to alternate the split of data set partitions}

\item{input}{specify if the input was scaled or transformed, scaled=1, transformed=2}
}
\value{
list object containing the following components:
\item{error}{list object that summarizes discrimination and calibration errors obtained during the CV}
\item{type}{"GUESS"}
\item{pred_idx}{which prediction method was used during CV}
\item{probs_CV}{vector of calibrated predictions that was used during the CV}
\item{actual_CV}{respective vector of true values (0 or 1) that was used during the CV}
}
\description{
trains and evaluates the GUESS calibration model using \code{folds}-Cross-Validation (CV).
The \code{predicted} values are partitioned into n subsets. A GUESS model is constructed on (n-1) subsets; the remaining set is used
for testing the model. All test set predictions are merged and used to compute error metrics for the model.
}
