% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standata.R
\name{standata.brmsfit}
\alias{standata.brmsfit}
\title{Extract data passed to Stan from \code{brmsfit} objects}
\usage{
\method{standata}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  newdata2 = NULL,
  new_objects = NULL,
  incl_autocor = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used. \code{NA}
values within factors (excluding grouping variables) are interpreted as if
all dummy variables of this factor are zero. This allows, for instance, to
make predictions of the grand mean when using sum coding. \code{NA} values
within grouping variables are treated as a new level.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA} or \code{~0}, include no group-level effects.}

\item{newdata2}{A named \code{list} of objects containing new data, which
cannot be passed via argument \code{newdata}. Required for some objects
used in autocorrelation structures, or \code{\link{stanvars}}.}

\item{new_objects}{Deprecated alias of \code{newdata2}.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{...}{More arguments passed to
\code{\link[brms:standata.default]{standata.default}}.
and \code{\link{validate_newdata}}.}
}
\value{
A named list containing the data passed to Stan.
}
\description{
Extract all data that was used by Stan to fit a \pkg{brms} model.
}
