% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunkutil.R
\name{repfromto}
\alias{repfromto}
\alias{repfromto<-}
\title{Virtual recycling}
\usage{
repfromto(x, from, to)

repfromto(x, from, to) <- value
}
\arguments{
\item{x}{an object from which to recycle}

\item{from}{first position to return}

\item{to}{last position to return}

\item{value}{value to assign}
}
\value{
a vector of length \code{from - to + 1}
}
\description{
\code{repfromto} virtually recylcles object \code{x} and cuts out
positions \verb{from .. to}
}
\details{
\code{repfromto} is a generalization of \code{\link[=rep]{rep()}}, where
\code{rep(x, n) == repfromto(x, 1, n)}.  You can see this as an R-side
(vector) solution of the \code{mod_iterate} macro in arithmetic.c
}
\examples{

  message("a simple example")
  repfromto(0:9, 11, 20)

}
\seealso{
\code{\link[=rep]{rep()}}, \code{\link[ff:ffapply]{ff::ffvecapply()}}
}
\author{
Jens Oehlschlägel
}
\keyword{IO}
\keyword{data}
