% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AminoAcids.R
\name{isValidAASeq}
\alias{isValidAASeq}
\title{Validate amino acid sequences}
\usage{
isValidAASeq(seq)
}
\arguments{
\item{seq}{character vector of sequences to check.}
}
\value{
A logical vector with \code{TRUE} for each valid amino acid sequences 
          and \code{FALSE} for each invalid sequence.
}
\description{
\code{isValidAASeq} checks that a set of sequences are valid non-ambiguous 
amino acid sequences. A sequence is considered valid if it contains only 
characters in the the non-ambiguous IUPAC character set or any characters in 
\code{c("X", ".", "-", "*")}.
}
\examples{
seq <- c("CARDRSTPWRRGIASTTVRTSW", "XXTQMYVR--XX", "CARJ", "10") 
isValidAASeq(seq)

}
\seealso{
See \link{ABBREV_AA} for the set of non-ambiguous amino acid characters.
See \link{IUPAC_AA} for the full set of ambiguous amino acid characters.
}
