% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExperimentList-class.R,
%   R/MultiAssayExperiment-methods.R, R/MultiAssayExperiment-helpers.R,
%   R/assay-methods.R
\docType{class}
\name{ExperimentList-class}
\alias{ExperimentList-class}
\alias{show,ExperimentList-method}
\alias{coerce}
\alias{coerce,list,ExperimentList-method}
\alias{coerce,List,ExperimentList-method}
\alias{isEmpty,ExperimentList-method}
\alias{dimnames,ExperimentList-method}
\alias{mergeReplicates,ExperimentList-method}
\alias{assay,ANY,missing-method}
\alias{assays,ExperimentList-method}
\alias{assay,ExperimentList,missing-method}
\alias{assay,ExperimentList,numeric-method}
\alias{assay,ExperimentList,character-method}
\title{A container for multi-experiment data}
\usage{
\S4method{show}{ExperimentList}(object)

\S4method{isEmpty}{ExperimentList}(x)

\S4method{dimnames}{ExperimentList}(x)

\S4method{mergeReplicates}{ExperimentList}(x, replicates = list(), simplify = BiocGenerics::mean, ...)

\S4method{assay}{ANY,missing}(x, i, ...)

\S4method{assays}{ExperimentList}(x, ..., withDimnames = TRUE)

\S4method{assay}{ExperimentList,missing}(x, i, ...)

\S4method{assay}{ExperimentList,numeric}(x, i, ...)

\S4method{assay}{ExperimentList,character}(x, i, ...)
}
\arguments{
\item{object, x}{An \code{\linkS4class{ExperimentList}} object}

\item{replicates}{mergeReplicates: A \code{list} or \linkS4class{LogicalList}
where each element represents a sample and a vector of repeated measurements
for the sample}

\item{simplify}{A function for merging columns where duplicates are indicated
by replicates}

\item{...}{Additional arguments. See details for more information.}

\item{i}{A scalar \code{character} or \code{integer} index}

\item{withDimnames}{logical (default TRUE) whether to return dimension names}
}
\description{
The \code{ExperimentList} class is a container that builds on
the \code{SimpleList} with additional
checks for consistency in experiment names and length.
It contains a \code{SimpleList} of experiments with sample identifiers.
One element present per experiment performed.
}
\details{
Convert from \code{SimpleList} or \code{list}
to the multi-experiment data container. When using the
\strong{mergeReplicates} method, additional arguments are passed to the
given \code{simplify} function argument (e.g., na.rm = TRUE)
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show method for
\code{\linkS4class{ExperimentList}} class

\item \code{isEmpty}: check for zero length across all
experiments

\item \code{dimnames}: Get the dimension names for
an \code{ExperimentList} using \code{\linkS4class{CharacterList}}

\item \code{mergeReplicates}: Apply the mergeReplicates method on the
ExperimentList elements

\item \code{assay}: Obtain the specified assay with a \code{numberic}
or \code{character} reference

\item \code{assays}: Get the assay data from each element in the
\link{ExperimentList}
}}

\section{coercion}{

Convert a \code{list} or S4 \code{List} to an ExperimentList using the
\code{as()} function.

In the following example, \code{x} is either a \code{list} or
\linkS4class{List}:

\preformatted{    \code{as(x, "ExperimentList")}}
}

\examples{
ExperimentList()

}
