/***************************************************************************
                          glcontrol.hpp  -  description
                             -------------------
    begin                : Mit Sep 25 13:11:41 CEST 2002
    copyright            : (C) 2002-2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GLCONTROL_H
#define GLCONTROL_H

/**
  *@author Krippel Harald
  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui>
#include <QtOpenGL>

#include <listviews.hpp>
#include <globdefines.h>

// plib
#include <plib/ssg.h>
#include <plib/ssgAux.h>

// SPL
#include "spl_prg.hpp"

// QTScript
#include "qtscript_prg.hpp"

// Python script
#include "python_prg.hpp"

// ODE
#include <ode/ode.h>

#include "camera.hpp"
#include "player.hpp"
#include "barrier.hpp"
#include "body.hpp"
#include "cursor3d.hpp"

extern class QMutex ph_mutex;

class ssgaSky;
class phThread;
class shader;

/** Glcontrol is the base class of the project */
class Glcontrol : public QGLWidget
{
  Q_OBJECT 
  public:
    /** construtor */
    Glcontrol(QWidget* parent=0);

    virtual void	transform();

    /** destructor */
    ~Glcontrol();

    ssgTransform *globj;
    ssgRoot      *scene;

public slots:
    void    setMouseMode(int mode);

    void    setXRotation( double degrees );
    void    setYRotation( double degrees );
    void    setZRotation( double degrees );

    void    setScale( double s );

    void    setXTrans( double x );
    void    setYTrans( double y );
    void    setZTrans( double z );

    void    setXScale( double x );
    void    setYScale( double y );
    void    setZScale( double z );

    virtual void	setRotationImpulse( double x, double y, double z );
    virtual void	setTranslationImpulse( double x, double y, double z );
    virtual void	setScaleImpulse( double x, double y, double z );

    void    initFolderListItem(FolderListItem * i,const QString &path);
    void    setFocusDefault(FolderListItem * i);
    void    setFocusObject(FolderListItem * i);
    void    setFocusPlayer(FolderListItem * i);
    void    setFocusBarrier(FolderListItem * i);
    void    setFocusBody(FolderListItem * i);
    void    setFocusLamp(FolderListItem * i);
    void    setFocusFog(FolderListItem * i);
    void    setFocusFire(FolderListItem * i);
    void    setFocusScene(FolderListItem * i);
    void    setFocusSky(FolderListItem * i);
    void    setFocusSound(FolderListItem * i);
    void    setFocusMedia(FolderListItem * i);
    void    setFocusScriptprg(FolderListItem * i);
    void    setFocusCursor(FolderListItem * i);
    void    setFocusGUIText(FolderListItem * i);
    void    setFocusGUIButton(FolderListItem * i);
    void    setFocusGUIOSButton(FolderListItem * i);
    void    setFocusGUIInput(FolderListItem * i);
    void    setFocusWaveSys(FolderListItem * i);
    void    setFocusCamera(FolderListItem * i);
    void    setFocusPartSys(FolderListItem * i);

    void    StopSound();
    void    switchCamera(FolderListItem * i);
    int     loadObject(FolderListItem * i, ssgTransform *obj);
    void    addFire(FolderListItem * i, ssgTransform *obj);
    void    addLensflare(FolderListItem * i, ssgTransform *obj);
    void    addLamp(FolderListItem * i, ssgTransform *obj);
    void    addWaveSys(FolderListItem * i, ssgTransform *obj);
    void    addCamera(FolderListItem * i, ssgTransform *obj);
    void    addObjectFile(FolderListItem * i, QString path , QString file, ssgTransform *obj);
    void    addPartSys(FolderListItem * i, ssgTransform *obj);
    void    addFog(FolderListItem * i);
    void    addPlayer(FolderListItem * i, ssgTransform *obj);
    void    addPlayerFile(FolderListItem * i, QString path , QString file, ssgTransform *obj);
    void    addBarrier(FolderListItem * i, ssgTransform *obj);
    void    addBarrierFile(FolderListItem * i,QString path , QString file, ssgTransform *obj);
    void    addBody(FolderListItem * i, ssgTransform *obj);
    void    addBodyFile(FolderListItem * i,QString path , QString file, ssgTransform *obj);
    void    addSky(FolderListItem * i, ssgTransform *obj);

    int     addSpl(FolderListItem * i, ssgTransform *obj);
    int     addQTScript(FolderListItem * i, ssgTransform *obj);
    int     addPython(FolderListItem * i, ssgTransform *obj);
    int     addShader(FolderListItem * i, ssgTransform *obj);

    void    addSPLFile(FolderListItem * i, QString path , QString file, ssgTransform *obj);
    void    addQTSFile(FolderListItem * i, QString path , QString file, ssgTransform *obj);
    void    addPythonFile(FolderListItem * i, QString path , QString file, ssgTransform *obj);

    void    addShaderFile(FolderListItem * i, QString path , QString vfile, QString ffile, ssgTransform *obj);
    void    addSound(FolderListItem * i, ssgTransform *obj);
    void    addSoundFile(FolderListItem * i, QString path , QString file, ssgTransform *obj);
    void    addMedia(FolderListItem * i, ssgTransform *obj);
    void    addMediaFile(FolderListItem * i, QString path , QString file, ssgTransform *obj);
    void    addCursor(FolderListItem * i);
    void    addGUITXT(FolderListItem * i);
    void    addGUIButton(FolderListItem * i);
    void    addGUIInput(FolderListItem * i);
    void    addGUIOSButton(FolderListItem * i);
    void    addNetwork(FolderListItem * i);
    int     addTmpObject(FolderListItem * i, FolderListItem * imodel, ssgTransform *obj, sgCoord pos, int id);

    ssgTransform*    loadObjectFile(QString path , QString file, ssgTransform *obj);

    void    DeleteScene();
    void    redrawScene();
    void    gtimerDone();
    void    updatePH();
    void    puRedraw();    
    void    phDelete();
    void    changeAttribute (FolderListItem * i, char *attr, char *value);
    void    switchScene(FolderListItem * i);
    int     getPoint(int x, int y, sgVec3 *poi);
    int    compile();

    static int enableTexGen ( ssgEntity * );
    static int disableTexGen ( ssgEntity * );
    // 3D-Object Callbacks  uuugggssssss @@@ H.K.
    static int objprecall  ( ssgEntity * );
    static int objpostcall ( ssgEntity * );

 signals:
    void	msg_ph_update(const QString & msg);
    void	msg_motion_update(float dt);
    void	msg_motionplay_update(float dt);
    void        msg_predraw();
    void        msg_postdraw();
    void        msg_sound_stop();
    void        msg_compile();
protected:

    void    initializeGL();
    void    load_database ();
    void    init_graphics ();
    void    update_motion ();
    void    paintGL();
    void    resizeGL( int w, int h );
    void    mousePressEvent( QMouseEvent *e );
    void    mouseReleaseEvent( QMouseEvent *e );
    void    mouseMoveEvent( QMouseEvent * );
//    void		mouseDoubleClickEvent( QMouseEvent * );
    void    wheelEvent( QWheelEvent * );
    void    keyPressEvent(QKeyEvent *e);
    void    keyReleaseEvent ( QKeyEvent * e);
    void    initVariables();
    void    init_gui();



    bool animation;
    usercamera *usercam;
    float phfps;


protected slots:
    void    viewCamera(usercamera * usercam);

private:
    FolderListItem *focusitem;
    bool wasAnimated;
    QPoint oldPos;
    QTimer* gtimer;
    phThread *phthread;

    int delay;
    int mouse_mode;   

    int gl_player_num;
    Player  *gl_player[MAX_PLAYER];

    GLfloat xRot, yRot, zRot;
    GLfloat xTrans, yTrans, zTrans;
    GLfloat xScale, yScale, zScale;
    GLfloat scale;

    GLfloat cxRot, cyRot, czRot;
    GLfloat cxTrans, cyTrans, czTrans;
    int gllook;

    // context
    Camera *my_context;
    float mgox;
    float mgoy;
    int keylook;
    ssgaLensFlare *lensflare_obj;
    FolderListItem *sceneitem;
};

#endif
