# igraph C library changelog

## [0.8.0] - 2020-01-29

### Added

#### Trees

 - `igraph_to_prufer()` and `igraph_from_prufer()` convert labelled trees to/from Prüfer sequences
 - `igraph_tree_game()` samples uniformly from the set of labelled trees
 - `igraph_is_tree()` checks if a graph is a tree
 - `igraph_random_spanning_tree()` picks a spanning tree of a graph uniformly at random
 - `igraph_random_edge_walk()` returns the indices of edges traversed by a random walk; useful for multigraphs

#### Community detection

 - `igraph_community_fluid_communities()` detects communities based on interacting fluids
 - `igraph_community_leiden()` detects communities with the Leiden method

#### Cliques

 - `igraph_maximal_cliques_hist()` counts maximal cliques of each size
 - `igraph_maximal_cliques_callback()` calls a function for each maximal clique
 - `igraph_clique_size_hist()` counts cliques of each size
 - `igraph_cliques_callback()` calls a function for each clique
 - `igraph_weighted_cliques()` finds weighted cliques in graphs with integer vertex weights
 - `igraph_weighted_clique_number()` computes the weighted clique number
 - `igraph_largest_weighted_cliques()` finds the largest weighted cliques

#### Graph generators

 - `igraph_hsbm_game()` for a hierarchical stochastic block model
 - `igraph_hsbm_list_game()` for a more general hierarchical stochastic block model
 - `igraph_correlated_game()` generates pairs of correlated random graphs by perturbing existing adjacency matrix
 - `igraph_correlated_pair_game()` generates pairs of correlated random graphs
 - `igraph_tree_game()` samples uniformly from the set of labelled trees
 - `igraph_dot_product_game()` generates a random dot product graph
 - `igraph_realize_degree_sequence()` creates a single graph with a given degree sequence (Havel-Hakimi algorithm)

#### Graph embeddings

 - `igraph_adjacency_spectral_embedding()` and `igraph_laplacian_spectral_embedding()` provide graph embedddings 
 - `igraph_dim_select()` provides dimensionality selection for singular values using profile likelihood

#### Other

 - `igraph_simplify_and_colorize()` encodes edge and self-loop multiplicities into edge and vertex colors
 - `igraph_bridges()` finds edges whose removal would disconnect a graph
 - `igraph_vertex_coloring_greedy()` computes a vertex coloring using a greedy algorithm
 - `igraph_rewire_directed_edges()` randomly rewires only the starting points or only the endpoints of directed edges
 - Various `igraph_local_scan_*` functions provide local counts and statistics of neighborhoods
 - `igraph_sample_sphere_surface()` samples points uniformly from the surface of a sphere
 - `igraph_sample_sphere_volume()` samples points uniformly from the volume of a sphere
 - `igraph_sample_dirichlet()` samples points from a Dirichlet distribution
 - `igraph_malloc()`, to be paired with the existing `igraph_free()`

### Changed 

 - `igraph_degree_sequence_game()`: new method added for uniform sampling: `IGRAPH_DEGSEQ_SIMPLE_NO_MULTIPLE_UNIFORM`
 - `igraph_modularity_matrix()`: removed `membership` argument (PR #1194)
 - `igraph_avg_nearest_neighbor_degree()`: added `mode` and `neighbor_degree_mode` arguments (PR #1214).
 - `igraph_get_all_simple_paths()`: added `cutoff` argument (PR #1232).
 - `igraph_unfold_tree()`: no longer preserves edge ordering of original graph
 - `igraph_decompose()`: support strongly connected components

### Other

 - The [Bliss library](http://www.tcs.hut.fi/Software/bliss/) was updated to version 0.73
 - igraph now uses the high-performance [Cliquer library](https://users.aalto.fi/~pat/cliquer.html) to find (non-maximal) cliques 
 - Provide proper support for Windows, using `__declspec(dllexport)` and `__declspec(dllimport)` for `DLL`s and static usage by using `#define IGRAPH_STATIC 1`.
 - Provided integer versions of `dqueue` and `stack` data types.
