#!/usr/bin/python3
# -*- coding: utf-8 -*-

#  Copyright © 2013, 2015  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os
sys.path.insert(0, '.')
from ast import literal_eval
import polib  # to force an import error, po_isempty ignore it if polib is not installed

from buildlib.utils import po_isempty


def pprint_tranlators(translation_authors):
    print('[')
    for unused_template, langname, langcode, persons in translation_authors:
        filename = 'po/%s.po' % langcode
        if not os.path.exists(filename):
            print('not found:', filename, file=sys.stderr)
            continue
        if po_isempty(filename, verbose=False):
            print('empty:', filename, file=sys.stderr)
            continue
        print('  ({!r}, {!r}, ['.format(langname, langcode))
        for person in persons:
            #XXX: Blacklist hack
            if person[1] == 'https://launchpad.net/~barcc' and langcode not in ['de', 'en_GB']:
                continue
            print('    {!r},'.format(person))
        print('  ]),')
    print(']')
    
def main():
    data = sys.stdin.read()
    if not data.strip():
        print('\nError: empty input, require output from "bc-lp-project-translators --py LPPROJECT"', file=sys.stderr)
        return
    try:
        tranlators = literal_eval(data)
    except (SyntaxError, ValueError):
        print('\nError: invalid syntax in input, require output from "bc-lp-project-translators --py LPPROJECT"')
        return
    try:
        pprint_tranlators(tranlators)
    except (ValueError, TypeError):
        print('\nError: malformed input, require output from "bc-lp-project-translators --py LPPROJECT"')
        raise
    
    
if __name__ == '__main__':
    main()
    

