# -*- coding: utf-8 -*-
licence={}
licence['en']="""
    phPLot.py
    
    this file is part of the package pyacidobasic version %s:

    a program to simulate acido-basic equilibria
    
    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from PyQt4 import QtGui, QtCore, Qwt5, QtSvg
import re

class phPlot(Qwt5.QwtPlot):
    def __init__(self, parent=None):
        Qwt5.QwtPlot.__init__(self,parent)
        self.setMouseTracking(True)
        
        self.picker = Qwt5.QwtPlotPicker(self.canvas())
        self.picker.setRubberBand (Qwt5.QwtPlotPicker.PointSelection | Qwt5.QwtPicker.DragSelection)
        self.picker.setTrackerMode(Qwt5.QwtPicker.AlwaysOn)
        
        self.marker = Qwt5.QwtPlotMarker()
        self.marker.setLineStyle(Qwt5.QwtPlotMarker.VLine | Qwt5.QwtPlotMarker.HLine)
        self.marker.setLabelAlignment(QtCore.Qt.AlignRight | 
QtCore.Qt.AlignBottom)
        self.marker.setLinePen(QtGui.QPen(QtCore.Qt.darkGray, 1, 
QtCore.Qt.DashLine))
        #self.marker.setSymbol(QwtSymbol.XCross)
        self.marker.setValue(1.0, 0.0)
        self.marker.attach(self)

        self.exportNo=1

    def mouseMoveEvent(self, e):
        canvasPos = self.canvas().mapFrom(self, e.pos())
        xFloat = self.invTransform(Qwt5.QwtPlot.xBottom, canvasPos.x())
        yFloat = self.invTransform(Qwt5.QwtPlot.yLeft, canvasPos.y())
        self.marker.setValue(xFloat, yFloat)
        self.replot()

    def getFileName(self, fichier, ext, filtre):
        """
        Renvoie un nom de fichier à ouvrir pour un enregistrement
        @param fichier une proposition initiale pour le nom du fichier
        @param nb numero à inscrire dans le nom de fichier
        @param ext extension du nom de fichier
        @param filtre filtre les noms de fichiers visibles
        @result le nom du fichier choisi
        """
        msg=u'Nom du fichier à exporter'
        fichier="%s%03d.%s" %(fichier, self.exportNo, ext)
        fichier= QtGui.QFileDialog.getSaveFileName(self,msg,fichier,filtre)
        try:
            self.exportNo=int(re.compile('.*([0-9]).*').match(fichier).group(1))+1
        except:
            self.exportNo=1
        return fichier

    def exportSVG(self):
        fileName = self.getFileName('graphe', 'svg', 'Documents SVG (*.svg)')
        if not fileName.isEmpty():
            generator = QtSvg.QSvgGenerator()
            generator.setFileName(fileName)
            generator.setSize(QtCore.QSize(800, 600))
            self.print_(generator)
 
    def exportPDF(self):
        fileName = self.getFileName('graphe', 'pdf', 'Documents PDF (*.pdf)')
        if not fileName.isEmpty():
            printer = QtGui.QPrinter()
            printer.setOutputFormat(QtGui.QPrinter.PdfFormat)
            printer.setOrientation(QtGui.QPrinter.Landscape)
            printer.setOutputFileName(fileName)
 
            printer.setCreator('PDF example')
            self.print_(printer)
            
    def exportJPG(self):
        fileName = self.getFileName('graphe', 'jpg', 'Images JPEG (*.jpg)')
        if not fileName.isEmpty():
            QtGui.QPixmap.grabWidget(self).save(fileName, 'JPG')

    def newTitle(self):
        title = QtGui.QInputDialog.getText(self, u"Titre",
                        u"Indiquer le titre à afficher sur le graphique")
        if title[1]:
            self.setTitle(title[0])
