<?php

class TP_yyToken implements ArrayAccess
{
    public $string = '';

    public $metadata = array();

    public function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    public function __toString()
    {
        return $this->string;
    }

    public function offsetExists($offset)
    {
        return isset($this->metadata[ $offset ]);
    }

    public function offsetGet($offset)
    {
        return $this->metadata[ $offset ];
    }

    public function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[ 0 ])) {
                $x = ($value instanceof TP_yyToken) ? $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);

                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[ $offset ] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[ $offset ] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        unset($this->metadata[ $offset ]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
}

;

#line 11 "../smarty/lexer/smarty_internal_templateparser.y"

/**
 * Smarty Template Parser Class
 *
 * This is the template parser.
 * It is generated from the smarty_internal_templateparser.y file
 *
 * @author Uwe Tews <uwe.tews@googlemail.com>
 */
class Smarty_Internal_Templateparser
{
    #line 23 "../smarty/lexer/smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";

    const Err2 = "Security error: Call to dynamic object member not allowed";

    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";

    /**
     * result status
     *
     * @var bool
     */
    public $successful = true;

    /**
     * return value
     *
     * @var mixed
     */
    public $retvalue = 0;

    /**
     * counter for prefix code
     *
     * @var int
     */
    public static $prefix_number = 0;

    /**
     * @var
     */
    public $yymajor;

    /**
     * last index of array variable
     *
     * @var mixed
     */
    public $last_index;

    /**
     * last variable name
     *
     * @var string
     */
    public $last_variable;

    /**
     * root parse tree buffer
     *
     * @var Smarty_Internal_ParseTree
     */
    public $root_buffer;

    /**
     * current parse tree object
     *
     * @var Smarty_Internal_ParseTree
     */
    public $current_buffer;

    /**
     * lexer object
     *
     * @var Smarty_Internal_Templatelexer
     */
    public $lex;

    /**
     * internal error flag
     *
     * @var bool
     */
    private $internalError = false;

    /**
     * {strip} status
     *
     * @var bool
     */
    public $strip = false;

    /**
     * compiler object
     *
     * @var Smarty_Internal_TemplateCompilerBase
     */
    public $compiler = null;

    /**
     * smarty object
     *
     * @var Smarty
     */
    public $smarty = null;

    /**
     * template object
     *
     * @var Smarty_Internal_Template
     */
    public $template = null;

    /**
     * block nesting level
     *
     * @var int
     */
    public $block_nesting_level = 0;

    /**
     * security object
     *
     * @var Smarty_Security
     */
    public $security = null;

    /**
     * template prefix array
     *
     * @var \Smarty_Internal_ParseTree[]
     */
    public $template_prefix = array();

    /**
     * security object
     *
     * @var \Smarty_Internal_ParseTree[]
     */
    public $template_postfix = array();

    /**
     * constructor
     *
     * @param Smarty_Internal_Templatelexer        $lex
     * @param Smarty_Internal_TemplateCompilerBase $compiler
     */
    function __construct(Smarty_Internal_Templatelexer $lex, Smarty_Internal_TemplateCompilerBase $compiler)
    {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->template = $this->compiler->template;
        $this->smarty = $this->template->smarty;
        $this->security = isset($this->smarty->security_policy) ? $this->smarty->security_policy : false;
        $this->current_buffer = $this->root_buffer = new Smarty_Internal_ParseTree_Template();
    }

    /**
     * insert PHP code in current buffer
     *
     * @param string $code
     */
    public function insertPhpCode($code)
    {
        $this->current_buffer->append_subtree($this, new Smarty_Internal_ParseTree_Tag($this, $code));
    }

    /**
     *  merge PHP code with prefix code and return parse tree tag object
     *
     * @param string $code
     *
     * @return Smarty_Internal_ParseTree_Tag
     */
    public function mergePrefixCode($code)
    {
        $tmp = '';
        foreach ($this->compiler->prefix_code as $preCode) {
            $tmp .= $preCode;
        }
        $this->compiler->prefix_code = array();
        $tmp .= $code;
        return new Smarty_Internal_ParseTree_Tag($this, $this->compiler->processNocacheCode($tmp, true));
    }

    const TP_VERT = 1;

    const TP_COLON = 2;

    const TP_PHP = 3;

    const TP_NOCACHE = 4;

    const TP_TEXT = 5;

    const TP_STRIPON = 6;

    const TP_STRIPOFF = 7;

    const TP_LITERALSTART = 8;

    const TP_LITERALEND = 9;

    const TP_LITERAL = 10;

    const TP_RDEL = 11;

    const TP_SIMPELOUTPUT = 12;

    const TP_LDEL = 13;

    const TP_DOLLARID = 14;

    const TP_EQUAL = 15;

    const TP_SIMPLETAG = 16;

    const TP_ID = 17;

    const TP_PTR = 18;

    const TP_LDELIF = 19;

    const TP_LDELFOR = 20;

    const TP_SEMICOLON = 21;

    const TP_INCDEC = 22;

    const TP_TO = 23;

    const TP_STEP = 24;

    const TP_LDELFOREACH = 25;

    const TP_SPACE = 26;

    const TP_AS = 27;

    const TP_APTR = 28;

    const TP_LDELSETFILTER = 29;

    const TP_SMARTYBLOCKCHILDPARENT = 30;

    const TP_CLOSETAG = 31;

    const TP_LDELSLASH = 32;

    const TP_ATTR = 33;

    const TP_INTEGER = 34;

    const TP_COMMA = 35;

    const TP_OPENP = 36;

    const TP_CLOSEP = 37;

    const TP_MATH = 38;

    const TP_UNIMATH = 39;

    const TP_ISIN = 40;

    const TP_INSTANCEOF = 41;

    const TP_QMARK = 42;

    const TP_NOT = 43;

    const TP_TYPECAST = 44;

    const TP_HEX = 45;

    const TP_DOT = 46;

    const TP_SINGLEQUOTESTRING = 47;

    const TP_DOUBLECOLON = 48;

    const TP_NAMESPACE = 49;

    const TP_AT = 50;

    const TP_HATCH = 51;

    const TP_OPENB = 52;

    const TP_CLOSEB = 53;

    const TP_DOLLAR = 54;

    const TP_LOGOP = 55;

    const TP_TLOGOP = 56;

    const TP_SINGLECOND = 57;

    const TP_QUOTE = 58;

    const TP_BACKTICK = 59;

    const YY_NO_ACTION = 527;

    const YY_ACCEPT_ACTION = 526;

    const YY_ERROR_ACTION = 525;

    const YY_SZ_ACTTAB = 2021;

    static public $yy_action = array(242, 10, 131, 178, 255, 76, 157, 5, 83, 293, 12, 149, 152, 116, 292, 93, 331, 217,
                                     284, 295, 221, 331, 226, 36, 21, 169, 35, 43, 308, 99, 26, 42, 39, 294, 235, 244,
                                     30, 200, 187, 80, 1, 251, 320, 206, 442, 123, 53, 242, 10, 130, 98, 255, 194, 399,
                                     5, 83, 442, 240, 298, 107, 116, 310, 174, 220, 217, 36, 295, 221, 399, 208, 135,
                                     21, 26, 161, 43, 399, 8, 174, 42, 39, 294, 235, 218, 331, 200, 187, 80, 1, 312,
                                     320, 11, 290, 313, 53, 242, 10, 133, 306, 255, 205, 187, 5, 83, 264, 266, 267, 211,
                                     116, 353, 220, 52, 217, 298, 295, 221, 206, 226, 220, 21, 290, 290, 43, 321, 36,
                                     249, 42, 39, 294, 235, 244, 26, 200, 206, 80, 1, 11, 320, 283, 52, 52, 53, 242, 10,
                                     132, 248, 255, 205, 455, 5, 83, 84, 301, 151, 455, 116, 323, 92, 36, 217, 2, 295,
                                     221, 331, 226, 26, 21, 290, 304, 43, 137, 36, 111, 42, 39, 294, 235, 244, 26, 200,
                                     187, 80, 1, 225, 320, 320, 52, 123, 53, 242, 10, 133, 98, 255, 193, 175, 5, 83,
                                     177, 280, 273, 234, 116, 310, 23, 278, 217, 13, 295, 221, 320, 203, 223, 21, 290,
                                     442, 43, 138, 187, 326, 42, 39, 294, 235, 244, 216, 200, 442, 80, 1, 4, 320, 329,
                                     52, 15, 53, 242, 10, 134, 91, 255, 205, 176, 5, 83, 293, 12, 16, 90, 116, 292, 300,
                                     99, 217, 241, 295, 221, 320, 226, 215, 28, 213, 201, 43, 105, 187, 286, 42, 39,
                                     294, 235, 244, 215, 200, 214, 80, 1, 105, 320, 11, 135, 285, 53, 242, 10, 133, 8,
                                     255, 205, 164, 5, 83, 442, 215, 19, 239, 116, 99, 105, 331, 217, 6, 295, 221, 442,
                                     192, 311, 21, 182, 289, 43, 308, 443, 32, 42, 39, 294, 235, 244, 296, 200, 17, 80,
                                     1, 443, 320, 262, 107, 26, 53, 242, 10, 133, 122, 255, 191, 172, 5, 83, 183, 188,
                                     148, 231, 116, 223, 168, 331, 217, 181, 295, 221, 331, 226, 206, 21, 331, 141, 43,
                                     308, 206, 38, 42, 39, 294, 235, 244, 331, 200, 188, 80, 1, 187, 320, 155, 206, 308,
                                     53, 242, 10, 133, 25, 255, 198, 188, 5, 83, 206, 145, 160, 308, 116, 228, 146, 206,
                                     217, 180, 295, 221, 331, 226, 286, 21, 331, 359, 43, 179, 289, 38, 42, 39, 294,
                                     235, 244, 250, 200, 271, 80, 1, 272, 320, 122, 94, 103, 53, 242, 10, 129, 3, 255,
                                     205, 144, 5, 83, 185, 289, 170, 99, 116, 270, 322, 331, 217, 184, 295, 221, 331,
                                     226, 99, 7, 171, 35, 43, 308, 89, 105, 42, 39, 294, 235, 244, 120, 200, 328, 80, 1,
                                     187, 320, 82, 223, 4, 53, 242, 10, 134, 142, 255, 205, 107, 5, 83, 309, 324, 302,
                                     20, 116, 316, 206, 291, 217, 290, 295, 221, 33, 226, 277, 28, 399, 243, 43, 257,
                                     219, 189, 42, 39, 294, 235, 244, 110, 200, 140, 80, 399, 147, 320, 253, 327, 258,
                                     53, 399, 14, 236, 220, 207, 154, 113, 65, 108, 319, 159, 238, 311, 98, 471, 471,
                                     330, 237, 279, 471, 210, 325, 245, 299, 310, 86, 308, 143, 268, 263, 259, 260, 269,
                                     177, 204, 287, 136, 242, 10, 150, 87, 255, 320, 139, 5, 83, 293, 12, 22, 195, 116,
                                     292, 247, 258, 217, 153, 295, 221, 220, 207, 36, 126, 50, 104, 109, 112, 88, 26,
                                     98, 246, 397, 330, 237, 85, 212, 210, 325, 245, 258, 310, 102, 299, 299, 220, 207,
                                     397, 113, 65, 108, 320, 299, 134, 397, 98, 222, 442, 330, 237, 299, 299, 210, 325,
                                     245, 258, 310, 299, 299, 442, 220, 207, 299, 126, 69, 108, 299, 288, 31, 299, 98,
                                     299, 299, 330, 237, 299, 299, 210, 325, 245, 80, 310, 299, 320, 299, 258, 299, 299,
                                     209, 299, 220, 207, 299, 126, 69, 108, 206, 299, 299, 455, 98, 299, 206, 330, 237,
                                     455, 365, 210, 325, 245, 299, 310, 355, 227, 258, 299, 299, 299, 199, 220, 207, 36,
                                     126, 64, 104, 299, 214, 36, 26, 98, 299, 442, 330, 237, 26, 299, 210, 325, 245,
                                     258, 310, 471, 471, 442, 220, 207, 471, 126, 69, 108, 293, 12, 299, 299, 98, 292,
                                     299, 330, 237, 299, 299, 210, 325, 245, 36, 310, 163, 299, 258, 299, 299, 26, 202,
                                     220, 207, 299, 126, 44, 108, 471, 299, 299, 299, 98, 299, 299, 330, 237, 299, 299,
                                     210, 325, 245, 299, 310, 299, 299, 258, 134, 299, 299, 252, 220, 207, 206, 126, 72,
                                     108, 299, 299, 299, 299, 98, 299, 396, 330, 237, 299, 299, 210, 325, 245, 258, 310,
                                     299, 299, 299, 220, 207, 396, 126, 74, 108, 254, 299, 80, 396, 98, 320, 299, 330,
                                     237, 299, 297, 210, 325, 245, 299, 310, 299, 242, 9, 299, 299, 255, 299, 258, 5,
                                     83, 299, 299, 220, 207, 116, 126, 68, 108, 217, 299, 295, 221, 98, 299, 299, 330,
                                     237, 299, 299, 210, 325, 245, 299, 310, 299, 258, 299, 299, 299, 299, 220, 207,
                                     299, 100, 70, 108, 299, 303, 29, 299, 98, 299, 299, 330, 237, 299, 297, 210, 325,
                                     245, 299, 310, 299, 242, 9, 299, 299, 255, 299, 299, 5, 83, 299, 299, 299, 299,
                                     116, 299, 299, 258, 217, 299, 295, 221, 220, 207, 299, 126, 66, 108, 299, 299, 299,
                                     299, 98, 293, 12, 330, 237, 299, 292, 210, 325, 245, 299, 310, 258, 299, 299, 305,
                                     29, 220, 207, 299, 126, 60, 108, 299, 293, 12, 299, 98, 299, 292, 330, 237, 299,
                                     299, 210, 325, 245, 299, 310, 232, 299, 258, 299, 206, 299, 299, 220, 207, 299,
                                     126, 49, 108, 299, 299, 299, 299, 98, 299, 299, 330, 237, 299, 230, 210, 325, 245,
                                     299, 310, 258, 167, 299, 299, 299, 220, 207, 299, 126, 58, 108, 299, 41, 40, 37,
                                     98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 256, 275, 282,
                                     220, 97, 299, 81, 45, 106, 299, 299, 299, 299, 98, 299, 299, 330, 237, 299, 299,
                                     210, 325, 245, 299, 310, 299, 299, 258, 299, 206, 299, 299, 220, 207, 299, 126, 63,
                                     108, 299, 186, 299, 299, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310,
                                     258, 299, 299, 299, 299, 220, 197, 299, 114, 59, 108, 299, 41, 40, 37, 98, 299,
                                     299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 256, 275, 282, 220,
                                     207, 299, 126, 55, 108, 299, 299, 299, 299, 98, 299, 299, 330, 237, 299, 299, 210,
                                     325, 245, 299, 310, 299, 299, 258, 299, 206, 299, 299, 220, 207, 299, 126, 57, 108,
                                     299, 41, 40, 37, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 258,
                                     299, 256, 275, 282, 220, 95, 299, 81, 48, 106, 233, 41, 40, 37, 98, 299, 299, 330,
                                     237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 256, 275, 282, 220, 207, 299,
                                     126, 78, 108, 299, 299, 299, 299, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245,
                                     299, 310, 299, 299, 258, 299, 206, 18, 299, 220, 207, 299, 96, 61, 108, 299, 299,
                                     299, 299, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 299,
                                     299, 299, 220, 207, 299, 126, 47, 108, 299, 41, 40, 37, 98, 299, 299, 330, 237,
                                     299, 299, 210, 325, 245, 299, 310, 258, 299, 256, 275, 282, 220, 207, 299, 126, 75,
                                     108, 299, 299, 299, 299, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310,
                                     299, 299, 258, 299, 206, 299, 299, 220, 207, 299, 126, 64, 108, 299, 299, 299, 299,
                                     98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 299, 299, 299,
                                     220, 207, 299, 126, 56, 108, 317, 41, 40, 37, 98, 299, 299, 330, 237, 299, 299,
                                     210, 325, 245, 299, 310, 258, 299, 256, 275, 282, 220, 207, 299, 115, 46, 108, 299,
                                     299, 299, 299, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 299, 299,
                                     258, 299, 206, 299, 299, 220, 207, 299, 126, 79, 108, 299, 190, 299, 299, 98, 299,
                                     299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 299, 299, 299, 220,
                                     207, 299, 126, 62, 108, 299, 41, 40, 37, 98, 299, 299, 330, 237, 299, 299, 210,
                                     325, 245, 299, 310, 258, 299, 256, 275, 282, 220, 207, 299, 126, 71, 108, 299, 299,
                                     299, 299, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 299, 299, 258,
                                     299, 206, 299, 299, 220, 207, 299, 101, 67, 108, 299, 318, 299, 299, 98, 299, 299,
                                     330, 237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 299, 299, 299, 220, 207,
                                     299, 126, 77, 108, 299, 41, 40, 37, 98, 299, 299, 330, 237, 299, 299, 210, 325,
                                     245, 299, 310, 258, 299, 256, 275, 282, 220, 196, 299, 126, 54, 108, 299, 299, 299,
                                     299, 98, 299, 299, 330, 237, 299, 299, 210, 325, 245, 299, 310, 299, 299, 258, 299,
                                     206, 299, 299, 220, 207, 299, 126, 73, 108, 299, 274, 299, 299, 98, 299, 299, 330,
                                     237, 299, 299, 210, 325, 245, 299, 310, 258, 299, 299, 299, 299, 220, 224, 299,
                                     118, 299, 108, 299, 41, 40, 37, 98, 299, 299, 299, 261, 299, 299, 210, 325, 245,
                                     299, 310, 258, 299, 256, 275, 282, 220, 224, 299, 128, 299, 108, 299, 299, 299,
                                     299, 98, 299, 299, 229, 315, 206, 299, 210, 325, 245, 299, 310, 299, 471, 471, 307,
                                     27, 299, 471, 455, 526, 51, 265, 266, 267, 211, 299, 299, 220, 299, 36, 299, 409,
                                     409, 299, 299, 299, 26, 299, 299, 299, 299, 41, 40, 37, 206, 299, 455, 299, 455,
                                     299, 471, 299, 455, 299, 299, 299, 299, 299, 256, 275, 282, 229, 299, 299, 117,
                                     299, 442, 299, 409, 409, 409, 471, 471, 299, 299, 299, 471, 455, 442, 299, 299, 41,
                                     40, 37, 299, 409, 409, 409, 299, 299, 299, 299, 299, 299, 299, 299, 299, 299, 256,
                                     275, 282, 299, 299, 299, 299, 455, 299, 455, 258, 471, 299, 455, 281, 220, 224,
                                     299, 127, 299, 108, 299, 299, 299, 299, 98, 299, 299, 299, 299, 299, 299, 210, 325,
                                     245, 258, 310, 206, 156, 299, 220, 224, 175, 121, 299, 108, 299, 299, 331, 299, 98,
                                     23, 278, 299, 299, 299, 299, 210, 325, 245, 34, 310, 36, 299, 299, 187, 299, 299,
                                     299, 26, 299, 299, 258, 299, 41, 40, 37, 220, 224, 299, 125, 299, 108, 299, 299,
                                     299, 299, 98, 299, 299, 229, 256, 275, 282, 210, 325, 245, 299, 310, 299, 471, 471,
                                     258, 31, 299, 471, 455, 220, 224, 299, 124, 299, 108, 299, 299, 299, 299, 98, 299,
                                     299, 299, 299, 299, 299, 210, 325, 245, 258, 310, 206, 299, 299, 220, 224, 455,
                                     119, 455, 108, 471, 299, 455, 299, 98, 299, 299, 229, 299, 299, 24, 210, 325, 245,
                                     299, 310, 299, 471, 471, 299, 471, 471, 471, 455, 299, 471, 455, 206, 41, 40, 37,
                                     299, 299, 299, 471, 471, 299, 299, 299, 471, 455, 299, 299, 276, 299, 256, 275,
                                     282, 299, 299, 299, 455, 36, 455, 455, 471, 455, 455, 471, 26, 455, 299, 206, 403,
                                     41, 40, 37, 206, 455, 299, 455, 299, 471, 403, 455, 403, 299, 299, 403, 299, 299,
                                     256, 275, 282, 299, 403, 299, 403, 299, 403, 299, 299, 299, 299, 299, 299, 299,
                                     299, 223, 41, 40, 37, 299, 299, 41, 40, 37, 299, 299, 299, 299, 299, 299, 299, 299,
                                     173, 256, 275, 282, 175, 314, 256, 275, 282, 299, 331, 166, 299, 23, 278, 175, 162,
                                     299, 299, 299, 175, 331, 299, 299, 23, 278, 331, 187, 299, 23, 278, 158, 299, 299,
                                     299, 175, 299, 299, 187, 299, 299, 331, 165, 187, 23, 278, 175, 299, 299, 299, 299,
                                     299, 331, 299, 299, 23, 278, 299, 187, 299, 299, 299, 299, 299, 299, 299, 299, 299,
                                     299, 187,);

    static public $yy_lookahead = array(12, 13, 14, 80, 16, 17, 71, 19, 20, 12, 13, 71, 91, 25, 17, 75, 81, 29, 30, 31,
                                        32, 81, 34, 26, 36, 28, 15, 39, 93, 18, 33, 43, 44, 45, 46, 47, 28, 49, 98, 51,
                                        52, 70, 54, 1, 36, 74, 58, 12, 13, 14, 79, 16, 17, 11, 19, 20, 48, 86, 64, 48,
                                        25, 90, 75, 69, 29, 26, 31, 32, 26, 34, 46, 36, 33, 71, 39, 33, 52, 75, 43, 44,
                                        45, 46, 47, 81, 49, 98, 51, 52, 53, 54, 35, 22, 37, 58, 12, 13, 14, 103, 16, 17,
                                        98, 19, 20, 63, 64, 65, 66, 25, 11, 69, 41, 29, 64, 31, 32, 1, 34, 69, 36, 22,
                                        22, 39, 53, 26, 95, 43, 44, 45, 46, 47, 33, 49, 1, 51, 52, 35, 54, 37, 41, 41,
                                        58, 12, 13, 14, 14, 16, 17, 46, 19, 20, 102, 103, 71, 52, 25, 11, 75, 26, 29,
                                        36, 31, 32, 81, 34, 33, 36, 22, 17, 39, 14, 26, 48, 43, 44, 45, 46, 47, 33, 49,
                                        98, 51, 52, 70, 54, 54, 41, 74, 58, 12, 13, 14, 79, 16, 17, 75, 19, 20, 8, 9,
                                        10, 50, 25, 90, 84, 85, 29, 13, 31, 32, 54, 34, 46, 36, 22, 36, 39, 14, 98, 53,
                                        43, 44, 45, 46, 47, 46, 49, 48, 51, 52, 36, 54, 53, 41, 21, 58, 12, 13, 14, 36,
                                        16, 17, 75, 19, 20, 12, 13, 15, 35, 25, 17, 59, 18, 29, 22, 31, 32, 54, 34, 74,
                                        36, 76, 77, 39, 79, 98, 99, 43, 44, 45, 46, 47, 74, 49, 76, 51, 52, 79, 54, 35,
                                        46, 37, 58, 12, 13, 14, 52, 16, 17, 71, 19, 20, 36, 74, 15, 76, 25, 18, 79, 81,
                                        29, 35, 31, 32, 48, 34, 92, 36, 94, 95, 39, 93, 36, 15, 43, 44, 45, 46, 47, 53,
                                        49, 26, 51, 52, 48, 54, 89, 48, 33, 58, 12, 13, 14, 96, 16, 17, 71, 19, 20, 14,
                                        98, 71, 17, 25, 46, 71, 81, 29, 75, 31, 32, 81, 34, 1, 36, 81, 71, 39, 93, 1, 2,
                                        43, 44, 45, 46, 47, 81, 49, 98, 51, 52, 98, 54, 91, 1, 93, 58, 12, 13, 14, 28,
                                        16, 17, 98, 19, 20, 1, 91, 71, 93, 25, 18, 71, 1, 29, 80, 31, 32, 81, 34, 99,
                                        36, 81, 11, 39, 94, 95, 2, 43, 44, 45, 46, 47, 89, 49, 65, 51, 52, 68, 54, 96,
                                        80, 79, 58, 12, 13, 14, 36, 16, 17, 71, 19, 20, 94, 95, 71, 18, 25, 53, 96, 81,
                                        29, 75, 31, 32, 81, 34, 18, 36, 74, 15, 39, 93, 91, 79, 43, 44, 45, 46, 47, 17,
                                        49, 17, 51, 52, 98, 54, 17, 46, 36, 58, 12, 13, 14, 51, 16, 17, 48, 19, 20, 17,
                                        34, 17, 42, 25, 17, 1, 34, 29, 22, 31, 32, 23, 34, 37, 36, 11, 17, 39, 5, 17,
                                        17, 43, 44, 45, 46, 47, 17, 49, 51, 51, 26, 27, 54, 11, 53, 64, 58, 33, 13, 14,
                                        69, 70, 17, 72, 73, 74, 53, 91, 81, 92, 79, 12, 13, 82, 83, 9, 17, 86, 87, 88,
                                        104, 90, 79, 93, 91, 3, 4, 5, 6, 7, 8, 100, 101, 79, 12, 13, 91, 79, 16, 54, 91,
                                        19, 20, 12, 13, 13, 14, 25, 17, 17, 64, 29, 91, 31, 32, 69, 70, 26, 72, 73, 74,
                                        78, 76, 79, 33, 79, 34, 11, 82, 83, 79, 15, 86, 87, 88, 64, 90, 67, 104, 104,
                                        69, 70, 26, 72, 73, 74, 54, 104, 14, 33, 79, 17, 36, 82, 83, 104, 104, 86, 87,
                                        88, 64, 90, 104, 104, 48, 69, 70, 104, 72, 73, 74, 104, 101, 15, 104, 79, 104,
                                        104, 82, 83, 104, 104, 86, 87, 88, 51, 90, 104, 54, 104, 64, 104, 104, 97, 104,
                                        69, 70, 104, 72, 73, 74, 1, 104, 104, 46, 79, 104, 1, 82, 83, 52, 11, 86, 87,
                                        88, 104, 90, 11, 18, 64, 104, 104, 104, 97, 69, 70, 26, 72, 73, 74, 104, 76, 26,
                                        33, 79, 104, 36, 82, 83, 33, 104, 86, 87, 88, 64, 90, 12, 13, 48, 69, 70, 17,
                                        72, 73, 74, 12, 13, 104, 104, 79, 17, 104, 82, 83, 104, 104, 86, 87, 88, 26, 90,
                                        28, 104, 64, 104, 104, 33, 97, 69, 70, 104, 72, 73, 74, 50, 104, 104, 104, 79,
                                        104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 104, 104, 64, 14, 104, 104, 17,
                                        69, 70, 1, 72, 73, 74, 104, 104, 104, 104, 79, 104, 11, 82, 83, 104, 104, 86,
                                        87, 88, 64, 90, 104, 104, 104, 69, 70, 26, 72, 73, 74, 49, 104, 51, 33, 79, 54,
                                        104, 82, 83, 104, 5, 86, 87, 88, 104, 90, 104, 12, 13, 14, 104, 16, 104, 64, 19,
                                        20, 104, 104, 69, 70, 25, 72, 73, 74, 29, 104, 31, 32, 79, 104, 104, 82, 83,
                                        104, 104, 86, 87, 88, 104, 90, 104, 64, 104, 104, 104, 104, 69, 70, 104, 72, 73,
                                        74, 104, 58, 59, 104, 79, 104, 104, 82, 83, 104, 5, 86, 87, 88, 104, 90, 104,
                                        12, 13, 14, 104, 16, 104, 104, 19, 20, 104, 104, 104, 104, 25, 104, 104, 64, 29,
                                        104, 31, 32, 69, 70, 104, 72, 73, 74, 104, 104, 104, 104, 79, 12, 13, 82, 83,
                                        104, 17, 86, 87, 88, 104, 90, 64, 104, 104, 58, 59, 69, 70, 104, 72, 73, 74,
                                        104, 12, 13, 104, 79, 104, 17, 82, 83, 104, 104, 86, 87, 88, 104, 90, 50, 104,
                                        64, 104, 1, 104, 104, 69, 70, 104, 72, 73, 74, 104, 104, 104, 104, 79, 104, 104,
                                        82, 83, 104, 50, 86, 87, 88, 104, 90, 64, 27, 104, 104, 104, 69, 70, 104, 72,
                                        73, 74, 104, 38, 39, 40, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90,
                                        64, 104, 55, 56, 57, 69, 70, 104, 72, 73, 74, 104, 104, 104, 104, 79, 104, 104,
                                        82, 83, 104, 104, 86, 87, 88, 104, 90, 104, 104, 64, 104, 1, 104, 104, 69, 70,
                                        104, 72, 73, 74, 104, 11, 104, 104, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88,
                                        104, 90, 64, 104, 104, 104, 104, 69, 70, 104, 72, 73, 74, 104, 38, 39, 40, 79,
                                        104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 64, 104, 55, 56, 57, 69, 70,
                                        104, 72, 73, 74, 104, 104, 104, 104, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88,
                                        104, 90, 104, 104, 64, 104, 1, 104, 104, 69, 70, 104, 72, 73, 74, 104, 38, 39,
                                        40, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 64, 104, 55, 56, 57,
                                        69, 70, 104, 72, 73, 74, 37, 38, 39, 40, 79, 104, 104, 82, 83, 104, 104, 86, 87,
                                        88, 104, 90, 64, 104, 55, 56, 57, 69, 70, 104, 72, 73, 74, 104, 104, 104, 104,
                                        79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 104, 104, 64, 104, 1, 2,
                                        104, 69, 70, 104, 72, 73, 74, 104, 104, 104, 104, 79, 104, 104, 82, 83, 104,
                                        104, 86, 87, 88, 104, 90, 64, 104, 104, 104, 104, 69, 70, 104, 72, 73, 74, 104,
                                        38, 39, 40, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 64, 104, 55,
                                        56, 57, 69, 70, 104, 72, 73, 74, 104, 104, 104, 104, 79, 104, 104, 82, 83, 104,
                                        104, 86, 87, 88, 104, 90, 104, 104, 64, 104, 1, 104, 104, 69, 70, 104, 72, 73,
                                        74, 104, 104, 104, 104, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 64,
                                        104, 104, 104, 104, 69, 70, 104, 72, 73, 74, 37, 38, 39, 40, 79, 104, 104, 82,
                                        83, 104, 104, 86, 87, 88, 104, 90, 64, 104, 55, 56, 57, 69, 70, 104, 72, 73, 74,
                                        104, 104, 104, 104, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 104,
                                        104, 64, 104, 1, 104, 104, 69, 70, 104, 72, 73, 74, 104, 11, 104, 104, 79, 104,
                                        104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 64, 104, 104, 104, 104, 69, 70, 104,
                                        72, 73, 74, 104, 38, 39, 40, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104,
                                        90, 64, 104, 55, 56, 57, 69, 70, 104, 72, 73, 74, 104, 104, 104, 104, 79, 104,
                                        104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 104, 104, 64, 104, 1, 104, 104, 69,
                                        70, 104, 72, 73, 74, 104, 11, 104, 104, 79, 104, 104, 82, 83, 104, 104, 86, 87,
                                        88, 104, 90, 64, 104, 104, 104, 104, 69, 70, 104, 72, 73, 74, 104, 38, 39, 40,
                                        79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 64, 104, 55, 56, 57, 69,
                                        70, 104, 72, 73, 74, 104, 104, 104, 104, 79, 104, 104, 82, 83, 104, 104, 86, 87,
                                        88, 104, 90, 104, 104, 64, 104, 1, 104, 104, 69, 70, 104, 72, 73, 74, 104, 11,
                                        104, 104, 79, 104, 104, 82, 83, 104, 104, 86, 87, 88, 104, 90, 64, 104, 104,
                                        104, 104, 69, 70, 104, 72, 104, 74, 104, 38, 39, 40, 79, 104, 104, 104, 83, 104,
                                        104, 86, 87, 88, 104, 90, 64, 104, 55, 56, 57, 69, 70, 104, 72, 104, 74, 104,
                                        104, 104, 104, 79, 104, 104, 2, 83, 1, 104, 86, 87, 88, 104, 90, 104, 12, 13,
                                        11, 15, 104, 17, 18, 61, 62, 63, 64, 65, 66, 104, 104, 69, 104, 26, 104, 1, 2,
                                        104, 104, 104, 33, 104, 104, 104, 104, 38, 39, 40, 1, 104, 46, 104, 48, 104, 50,
                                        104, 52, 104, 104, 104, 104, 104, 55, 56, 57, 2, 104, 104, 21, 104, 36, 104, 38,
                                        39, 40, 12, 13, 104, 104, 104, 17, 18, 48, 104, 104, 38, 39, 40, 104, 55, 56,
                                        57, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 55, 56, 57, 104, 104, 104,
                                        104, 46, 104, 48, 64, 50, 104, 52, 53, 69, 70, 104, 72, 104, 74, 104, 104, 104,
                                        104, 79, 104, 104, 104, 104, 104, 104, 86, 87, 88, 64, 90, 1, 71, 104, 69, 70,
                                        75, 72, 104, 74, 104, 104, 81, 104, 79, 84, 85, 104, 104, 104, 104, 86, 87, 88,
                                        24, 90, 26, 104, 104, 98, 104, 104, 104, 33, 104, 104, 64, 104, 38, 39, 40, 69,
                                        70, 104, 72, 104, 74, 104, 104, 104, 104, 79, 104, 104, 2, 55, 56, 57, 86, 87,
                                        88, 104, 90, 104, 12, 13, 64, 15, 104, 17, 18, 69, 70, 104, 72, 104, 74, 104,
                                        104, 104, 104, 79, 104, 104, 104, 104, 104, 104, 86, 87, 88, 64, 90, 1, 104,
                                        104, 69, 70, 46, 72, 48, 74, 50, 104, 52, 104, 79, 104, 104, 2, 104, 104, 2, 86,
                                        87, 88, 104, 90, 104, 12, 13, 104, 12, 13, 17, 18, 104, 17, 18, 1, 38, 39, 40,
                                        104, 104, 104, 12, 13, 104, 104, 104, 17, 18, 104, 104, 53, 104, 55, 56, 57,
                                        104, 104, 104, 46, 26, 48, 46, 50, 48, 52, 50, 33, 52, 104, 1, 11, 38, 39, 40,
                                        1, 46, 104, 48, 104, 50, 21, 52, 23, 104, 104, 26, 104, 104, 55, 56, 57, 104,
                                        33, 104, 35, 104, 37, 104, 104, 104, 104, 104, 104, 104, 104, 46, 38, 39, 40,
                                        104, 104, 38, 39, 40, 104, 104, 104, 104, 104, 104, 104, 104, 71, 55, 56, 57,
                                        75, 59, 55, 56, 57, 104, 81, 71, 104, 84, 85, 75, 71, 104, 104, 104, 75, 81,
                                        104, 104, 84, 85, 81, 98, 104, 84, 85, 71, 104, 104, 104, 75, 104, 104, 98, 104,
                                        104, 81, 71, 98, 84, 85, 75, 104, 104, 104, 104, 104, 81, 104, 104, 84, 85, 104,
                                        98, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 98,);

    const YY_SHIFT_USE_DFLT = - 13;

    const YY_SHIFT_MAX = 236;

    static public $yy_shift_ofst = array(542, 364, 82, 82, 82, 411, 364, 411, 35, - 12, - 12, 82, 82, 82, 82, 82, 82,
                                         176, 82, 82, 129, 82, 82, 82, 317, 82, 82, 82, 82, 82, 82, 270, 82, 82, 82, 82,
                                         176, 223, 223, 458, 458, 458, 458, 458, 1734, 1603, 1862, 1862, 1862, 1862,
                                         1862, 542, 749, 803, 1897, 1448, 1531, 1199, 1643, 1826, 1365, 950, 1282, 1033,
                                         1116, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 660,
                                         1902, 1089, 1089, 594, 666, 131, 202, 865, - 3, 703, 551, 551, 233, 202, 202,
                                         131, 131, 357, 97, 484, 144, 920, 505, 42, 768, 189, 232, 11, 232, 278, 324,
                                         428, 39, 372, 324, 39, 351, 384, 391, 294, 155, 114, 114, 114, 114, 417, 417,
                                         114, 114, 114, 114, - 13, 1786, 1659, 1600, 1844, 1841, 1858, 552, 897, 519,
                                         618, 24, 101, 39, 101, 24, 39, 24, 39, 130, 39, 39, 24, 39, 24, 24, 193, 24,
                                         39, 39, 39, 24, 39, 39, 39, 130, 39, 39, 39, 130, 39, 130, 39, 231, 39, 39,
                                         114, 114, 114, 526, 404, 417, 404, 114, 417, 390, 114, 417, - 13, - 13, - 13,
                                         - 13, - 13, 1630, 1888, 576, 178, 694, 191, 69, 8, 100, 275, 212, 243, 297,
                                         265, 255, 150, 98, 165, 55, 123, 493, 479, 468, 456, 434, 482, 483, 473, 461,
                                         502, 489, 457, 452, 466, 422, 421, 449, 442, 444, 462, 432, 467, 440, 464, 446,
                                         390,);

    const YY_REDUCE_USE_DFLT = - 80;

    const YY_REDUCE_MAX = 190;

    static public $yy_reduce_ofst = array(1558, 451, 556, 640, 586, 506, 531, 615, 995, 939, 1078, 723, 1244, 968, 856,
                                          912, 1354, 1134, 1105, 1161, 1051, 1217, 1022, 1188, 1300, 1466, 1383, 1271,
                                          1327, 1437, 1410, 757, 698, 669, 885, 829, 785, 1493, 1520, 1761, 1706, 1669,
                                          1644, 1736, 1880, 1665, 1896, 1911, 1665, 1891, 1922, 40, - 29, 48, 119, 119,
                                          119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
                                          119, 119, 119, 119, 119, 81, 119, 119, 119, 112, 2, - 60, 184, - 6, 264, 358,
                                          - 65, 217, 213, 218, 197, 284, 269, 166, 363, - 13, 363, 295, 342, - 13, - 13,
                                          349, 281, 310, 295, 310, 323, 310, 316, 272, 236, 273, - 13, - 13, - 13, 320,
                                          374, - 13, - 13, 366, - 13, 338, 310, - 13, - 13, - 13, - 13, - 13, 465, 465,
                                          465, 465, 465, 465, 474, 450, 465, 465, 437, 469, 447, 453, 437, 447, 437,
                                          447, 463, 447, 447, 437, 447, 437, 437, 481, 437, 447, 447, 447, 437, 447,
                                          447, 447, 478, 447, 447, 447, 511, 447, 504, 447, 503, 447, 447, 241, 241,
                                          241, 530, 300, 29, 300, 241, 29, 361, 241, 29, - 79, - 77, 314, 340, 436,);

    static public $yyExpectedTokens = array(array(3, 4, 5, 6, 7, 8, 12, 13, 16, 19, 20, 25, 29, 31, 32,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 53, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 30, 31, 32, 34, 36, 39, 43, 44,
                                                  45, 46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 30, 31, 32, 34, 36, 39, 43, 44,
                                                  45, 46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 52, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 54, 58,),
                                            array(12, 13, 14, 16, 17, 19, 20, 25, 29, 31, 32, 34, 36, 39, 43, 44, 45,
                                                  46, 47, 49, 51, 54, 58,),
                                            array(1, 24, 26, 33, 38, 39, 40, 55, 56, 57,),
                                            array(1, 11, 26, 33, 38, 39, 40, 55, 56, 57,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57,),
                                            array(3, 4, 5, 6, 7, 8, 12, 13, 16, 19, 20, 25, 29, 31, 32,),
                                            array(14, 17, 49, 51, 54,),
                                            array(5, 12, 13, 14, 16, 19, 20, 25, 29, 31, 32, 58, 59,),
                                            array(1, 38, 39, 40, 55, 56, 57, 59,),
                                            array(1, 11, 38, 39, 40, 55, 56, 57,),
                                            array(1, 11, 38, 39, 40, 55, 56, 57,), array(1, 2, 38, 39, 40, 55, 56, 57,),
                                            array(1, 21, 38, 39, 40, 55, 56, 57,),
                                            array(1, 38, 39, 40, 53, 55, 56, 57,),
                                            array(1, 11, 38, 39, 40, 55, 56, 57,),
                                            array(1, 27, 38, 39, 40, 55, 56, 57,),
                                            array(1, 37, 38, 39, 40, 55, 56, 57,),
                                            array(1, 11, 38, 39, 40, 55, 56, 57,),
                                            array(1, 37, 38, 39, 40, 55, 56, 57,), array(1, 38, 39, 40, 55, 56, 57,),
                                            array(1, 38, 39, 40, 55, 56, 57,), array(1, 38, 39, 40, 55, 56, 57,),
                                            array(1, 38, 39, 40, 55, 56, 57,), array(1, 38, 39, 40, 55, 56, 57,),
                                            array(1, 38, 39, 40, 55, 56, 57,), array(1, 38, 39, 40, 55, 56, 57,),
                                            array(1, 38, 39, 40, 55, 56, 57,), array(1, 38, 39, 40, 55, 56, 57,),
                                            array(1, 38, 39, 40, 55, 56, 57,), array(1, 38, 39, 40, 55, 56, 57,),
                                            array(1, 11, 18, 26, 33, 36, 48,), array(1, 38, 39, 40, 55, 56, 57,),
                                            array(38, 39, 40, 55, 56, 57,), array(38, 39, 40, 55, 56, 57,),
                                            array(14, 17, 51, 54,), array(1, 11, 26, 33,), array(1, 26, 33,),
                                            array(14, 36, 54,),
                                            array(5, 12, 13, 14, 16, 19, 20, 25, 29, 31, 32, 58, 59,),
                                            array(12, 13, 17, 26, 28, 33,), array(12, 13, 17, 26, 28, 33,),
                                            array(12, 13, 17, 26, 33,), array(12, 13, 17, 26, 33,), array(18, 46, 52,),
                                            array(14, 36, 54,), array(14, 36, 54,), array(1, 26, 33,),
                                            array(1, 26, 33,), array(1, 2,), array(11, 22, 26, 33, 41,),
                                            array(1, 11, 26, 27, 33,), array(11, 22, 26, 33, 41,),
                                            array(12, 13, 17, 50,), array(13, 14, 17, 54,), array(1, 11, 26, 33,),
                                            array(1, 11, 26, 33,), array(8, 9, 10,), array(12, 13, 17,),
                                            array(15, 18, 48,), array(12, 13, 17,), array(15, 18, 48,), array(14, 17,),
                                            array(18, 48,), array(26, 33,), array(1, 18,), array(14, 17,),
                                            array(26, 33,), array(1, 28,), array(1, 53,), array(1, 11,), array(26, 33,),
                                            array(14, 54,), array(1,), array(1,), array(1,), array(1,), array(18,),
                                            array(18,), array(1,), array(1,), array(1,), array(1,), array(),
                                            array(2, 12, 13, 15, 17, 18, 46, 48, 50, 52,),
                                            array(2, 12, 13, 17, 18, 46, 48, 50, 52, 53,),
                                            array(2, 12, 13, 15, 17, 18, 46, 48, 50, 52,),
                                            array(2, 12, 13, 17, 18, 46, 48, 50, 52,),
                                            array(2, 12, 13, 17, 18, 46, 48, 50, 52,),
                                            array(12, 13, 17, 18, 46, 48, 50, 52,), array(13, 14, 17, 34, 54,),
                                            array(12, 13, 17, 50,), array(12, 13, 17,), array(15, 46, 52,),
                                            array(46, 52,), array(46, 52,), array(26, 33,), array(46, 52,),
                                            array(46, 52,), array(26, 33,), array(46, 52,), array(26, 33,),
                                            array(14, 54,), array(26, 33,), array(26, 33,), array(46, 52,),
                                            array(26, 33,), array(46, 52,), array(46, 52,), array(13, 36,),
                                            array(46, 52,), array(26, 33,), array(26, 33,), array(26, 33,),
                                            array(46, 52,), array(26, 33,), array(26, 33,), array(26, 33,),
                                            array(14, 54,), array(26, 33,), array(26, 33,), array(26, 33,),
                                            array(14, 54,), array(26, 33,), array(14, 54,), array(26, 33,),
                                            array(15, 22,), array(26, 33,), array(26, 33,), array(1,), array(1,),
                                            array(1,), array(9,), array(2,), array(18,), array(2,), array(1,),
                                            array(18,), array(36,), array(1,), array(18,), array(), array(), array(),
                                            array(), array(), array(1, 2, 36, 38, 39, 40, 48, 55, 56, 57,),
                                            array(11, 21, 23, 26, 33, 35, 37, 46,), array(11, 15, 26, 33, 36, 48,),
                                            array(36, 46, 48, 53,), array(12, 13, 17, 50,), array(22, 41, 59,),
                                            array(22, 41, 53,), array(28, 36, 48,), array(35, 37,), array(36, 48,),
                                            array(21, 35,), array(35, 37,), array(15, 46,), array(35, 53,),
                                            array(36, 48,), array(17, 50,), array(22, 41,), array(46, 53,),
                                            array(35, 37,), array(36, 48,), array(5,), array(17,), array(23,),
                                            array(37,), array(15,), array(17,), array(17,), array(53,), array(53,),
                                            array(11,), array(17,), array(51,), array(34,), array(22,), array(51,),
                                            array(46,), array(17,), array(17,), array(17,), array(17,), array(36,),
                                            array(17,), array(42,), array(17,), array(34,), array(36,), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(),);

    static public $yy_default = array(335, 510, 490, 490, 490, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525,
                                      525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525,
                                      525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 525, 393, 525, 360, 393,
                                      357, 393, 369, 332, 525, 525, 525, 525, 525, 525, 525, 525, 525, 398, 525, 525,
                                      525, 513, 405, 395, 404, 489, 398, 374, 400, 511, 488, 414, 432, 512, 421, 420,
                                      525, 407, 393, 525, 525, 393, 393, 393, 393, 502, 525, 525, 393, 393, 383, 422,
                                      407, 422, 455, 525, 407, 407, 525, 455, 445, 455, 445, 525, 445, 393, 387, 525,
                                      371, 407, 407, 407, 393, 525, 417, 425, 389, 410, 499, 445, 423, 411, 407, 424,
                                      497, 444, 444, 444, 444, 444, 444, 525, 457, 455, 471, 449, 448, 366, 450, 451,
                                      379, 453, 378, 525, 368, 367, 452, 364, 483, 480, 455, 481, 358, 380, 362, 482,
                                      373, 356, 361, 525, 382, 370, 377, 525, 372, 525, 354, 525, 381, 376, 439, 413,
                                      384, 348, 492, 477, 491, 388, 503, 455, 390, 500, 455, 496, 496, 496, 455, 432,
                                      428, 432, 432, 456, 422, 422, 432, 525, 440, 525, 525, 428, 525, 432, 525, 422,
                                      428, 525, 525, 340, 525, 401, 525, 525, 525, 525, 435, 525, 525, 525, 525, 430,
                                      422, 525, 428, 525, 525, 525, 525, 501, 525, 434, 525, 525, 471, 412, 391, 402,
                                      418, 375, 352, 394, 435, 436, 460, 459, 471, 479, 437, 419, 442, 351, 443, 363,
                                      504, 342, 438, 341, 343, 416, 441, 339, 334, 333, 336, 337, 338, 344, 468, 349,
                                      347, 350, 476, 505, 469, 406, 415, 345, 346, 466, 506, 486, 385, 487, 495, 508,
                                      509, 478, 426, 429, 474, 475, 427, 386, 507, 524, 523, 520, 518, 517, 493, 514,
                                      494, 515, 516, 522, 473, 446, 447, 454, 470, 485, 519, 498, 458, 434, 461, 464,
                                      472, 467, 484, 521, 431, 433, 465, 463, 409, 462, 408, 392,);

    const YYNOCODE = 105;

    const YYSTACKDEPTH = 500;

    const YYNSTATE = 332;

    const YYNRULE = 193;

    const YYERRORSYMBOL = 60;

    const YYERRSYMDT = 'yy0';

    const YYFALLBACK = 0;

    public static $yyFallback = array();

    public function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        $this->yyTraceFILE = $TraceFILE;
        $this->yyTracePrompt = $zTracePrompt;
    }

    public function PrintTrace()
    {
        $this->yyTraceFILE = fopen('php://output', 'w');
        $this->yyTracePrompt = '<br>';
    }

    public $yyTraceFILE;

    public $yyTracePrompt;

    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array('$', 'VERT', 'COLON', 'PHP', 'NOCACHE', 'TEXT', 'STRIPON', 'STRIPOFF', 'LITERALSTART',
                                'LITERALEND', 'LITERAL', 'RDEL', 'SIMPELOUTPUT', 'LDEL', 'DOLLARID', 'EQUAL',
                                'SIMPLETAG', 'ID', 'PTR', 'LDELIF', 'LDELFOR', 'SEMICOLON', 'INCDEC', 'TO', 'STEP',
                                'LDELFOREACH', 'SPACE', 'AS', 'APTR', 'LDELSETFILTER', 'SMARTYBLOCKCHILDPARENT',
                                'CLOSETAG', 'LDELSLASH', 'ATTR', 'INTEGER', 'COMMA', 'OPENP', 'CLOSEP', 'MATH',
                                'UNIMATH', 'ISIN', 'INSTANCEOF', 'QMARK', 'NOT', 'TYPECAST', 'HEX', 'DOT',
                                'SINGLEQUOTESTRING', 'DOUBLECOLON', 'NAMESPACE', 'AT', 'HATCH', 'OPENB', 'CLOSEB',
                                'DOLLAR', 'LOGOP', 'TLOGOP', 'SINGLECOND', 'QUOTE', 'BACKTICK', 'error', 'start',
                                'template', 'template_element', 'smartytag', 'literal', 'text_content',
                                'literal_elements', 'literal_element', 'tag', 'variable', 'attributes', 'value', 'expr',
                                'varindexed', 'modifierlist', 'statement', 'statements', 'foraction', 'varvar',
                                'modparameters', 'attribute', 'ternary', 'array', 'lop', 'scond', 'ns1', 'function',
                                'doublequoted_with_quotes', 'static_class_access', 'object', 'arrayindex', 'indexdef',
                                'varvarele', 'objectchain', 'objectelement', 'method', 'params', 'modifier',
                                'modparameter', 'arrayelements', 'arrayelement', 'doublequoted',
                                'doublequotedcontent',);

    public static $yyRuleName = array('start ::= template', 'template ::= template_element',
                                      'template ::= template template_element', 'template ::=',
                                      'template_element ::= smartytag', 'template_element ::= literal',
                                      'template_element ::= PHP', 'template_element ::= NOCACHE',
                                      'template_element ::= text_content', 'text_content ::= TEXT',
                                      'text_content ::= text_content TEXT', 'template_element ::= STRIPON',
                                      'template_element ::= STRIPOFF', 'literal ::= LITERALSTART LITERALEND',
                                      'literal ::= LITERALSTART literal_elements LITERALEND',
                                      'literal_elements ::= literal_elements literal_element', 'literal_elements ::=',
                                      'literal_element ::= literal', 'literal_element ::= LITERAL',
                                      'smartytag ::= tag RDEL', 'smartytag ::= SIMPELOUTPUT', 'tag ::= LDEL variable',
                                      'tag ::= LDEL variable attributes', 'tag ::= LDEL value',
                                      'tag ::= LDEL value attributes', 'tag ::= LDEL expr',
                                      'tag ::= LDEL expr attributes', 'tag ::= LDEL DOLLARID EQUAL value',
                                      'tag ::= LDEL DOLLARID EQUAL expr', 'tag ::= LDEL DOLLARID EQUAL expr attributes',
                                      'tag ::= LDEL varindexed EQUAL expr attributes', 'smartytag ::= SIMPLETAG',
                                      'tag ::= LDEL ID attributes', 'tag ::= LDEL ID',
                                      'tag ::= LDEL ID modifierlist attributes', 'tag ::= LDEL ID PTR ID attributes',
                                      'tag ::= LDEL ID PTR ID modifierlist attributes', 'tag ::= LDELIF expr',
                                      'tag ::= LDELIF expr attributes', 'tag ::= LDELIF statement',
                                      'tag ::= LDELIF statement attributes',
                                      'tag ::= LDELFOR statements SEMICOLON expr SEMICOLON varindexed foraction attributes',
                                      'foraction ::= EQUAL expr', 'foraction ::= INCDEC',
                                      'tag ::= LDELFOR statement TO expr attributes',
                                      'tag ::= LDELFOR statement TO expr STEP expr attributes',
                                      'tag ::= LDELFOREACH attributes',
                                      'tag ::= LDELFOREACH SPACE value AS varvar attributes',
                                      'tag ::= LDELFOREACH SPACE value AS varvar APTR varvar attributes',
                                      'tag ::= LDELFOREACH SPACE expr AS varvar attributes',
                                      'tag ::= LDELFOREACH SPACE expr AS varvar APTR varvar attributes',
                                      'tag ::= LDELSETFILTER ID modparameters',
                                      'tag ::= LDELSETFILTER ID modparameters modifierlist',
                                      'tag ::= LDEL SMARTYBLOCKCHILDPARENT', 'smartytag ::= CLOSETAG',
                                      'tag ::= LDELSLASH ID', 'tag ::= LDELSLASH ID modifierlist',
                                      'tag ::= LDELSLASH ID PTR ID', 'tag ::= LDELSLASH ID PTR ID modifierlist',
                                      'attributes ::= attributes attribute', 'attributes ::= attribute',
                                      'attributes ::=', 'attribute ::= SPACE ID EQUAL ID', 'attribute ::= ATTR expr',
                                      'attribute ::= ATTR value', 'attribute ::= SPACE ID', 'attribute ::= SPACE expr',
                                      'attribute ::= SPACE value', 'attribute ::= SPACE INTEGER EQUAL expr',
                                      'statements ::= statement', 'statements ::= statements COMMA statement',
                                      'statement ::= DOLLARID EQUAL INTEGER', 'statement ::= DOLLARID EQUAL expr',
                                      'statement ::= varindexed EQUAL expr', 'statement ::= OPENP statement CLOSEP',
                                      'expr ::= value', 'expr ::= ternary', 'expr ::= DOLLARID COLON ID',
                                      'expr ::= expr MATH value', 'expr ::= expr UNIMATH value', 'expr ::= array',
                                      'expr ::= expr modifierlist', 'expr ::= expr lop expr', 'expr ::= expr scond',
                                      'expr ::= expr ISIN array', 'expr ::= expr ISIN value',
                                      'expr ::= variable INSTANCEOF ns1', 'expr ::= variable INSTANCEOF variable',
                                      'ternary ::= OPENP expr CLOSEP QMARK DOLLARID COLON expr',
                                      'ternary ::= OPENP expr CLOSEP QMARK expr COLON expr', 'value ::= variable',
                                      'value ::= UNIMATH value', 'value ::= NOT value', 'value ::= TYPECAST value',
                                      'value ::= variable INCDEC', 'value ::= HEX', 'value ::= INTEGER',
                                      'value ::= INTEGER DOT INTEGER', 'value ::= INTEGER DOT', 'value ::= DOT INTEGER',
                                      'value ::= ID', 'value ::= function', 'value ::= OPENP expr CLOSEP',
                                      'value ::= SINGLEQUOTESTRING', 'value ::= doublequoted_with_quotes',
                                      'value ::= varindexed DOUBLECOLON static_class_access', 'value ::= smartytag',
                                      'value ::= value modifierlist', 'value ::= NAMESPACE',
                                      'value ::= ns1 DOUBLECOLON static_class_access', 'ns1 ::= ID',
                                      'ns1 ::= NAMESPACE', 'variable ::= DOLLARID', 'variable ::= varindexed',
                                      'variable ::= varvar AT ID', 'variable ::= object', 'variable ::= HATCH ID HATCH',
                                      'variable ::= HATCH ID HATCH arrayindex', 'variable ::= HATCH variable HATCH',
                                      'variable ::= HATCH variable HATCH arrayindex',
                                      'varindexed ::= DOLLARID arrayindex', 'varindexed ::= varvar arrayindex',
                                      'arrayindex ::= arrayindex indexdef', 'arrayindex ::=',
                                      'indexdef ::= DOT DOLLARID', 'indexdef ::= DOT varvar',
                                      'indexdef ::= DOT varvar AT ID', 'indexdef ::= DOT ID',
                                      'indexdef ::= DOT INTEGER', 'indexdef ::= DOT LDEL expr RDEL',
                                      'indexdef ::= OPENB ID CLOSEB', 'indexdef ::= OPENB ID DOT ID CLOSEB',
                                      'indexdef ::= OPENB SINGLEQUOTESTRING CLOSEB',
                                      'indexdef ::= OPENB INTEGER CLOSEB', 'indexdef ::= OPENB DOLLARID CLOSEB',
                                      'indexdef ::= OPENB variable CLOSEB', 'indexdef ::= OPENB value CLOSEB',
                                      'indexdef ::= OPENB expr CLOSEB', 'indexdef ::= OPENB CLOSEB',
                                      'varvar ::= DOLLARID', 'varvar ::= DOLLAR', 'varvar ::= varvar varvarele',
                                      'varvarele ::= ID', 'varvarele ::= SIMPELOUTPUT', 'varvarele ::= LDEL expr RDEL',
                                      'object ::= varindexed objectchain', 'objectchain ::= objectelement',
                                      'objectchain ::= objectchain objectelement',
                                      'objectelement ::= PTR ID arrayindex', 'objectelement ::= PTR varvar arrayindex',
                                      'objectelement ::= PTR LDEL expr RDEL arrayindex',
                                      'objectelement ::= PTR ID LDEL expr RDEL arrayindex',
                                      'objectelement ::= PTR method', 'function ::= ns1 OPENP params CLOSEP',
                                      'method ::= ID OPENP params CLOSEP', 'method ::= DOLLARID OPENP params CLOSEP',
                                      'params ::= params COMMA expr', 'params ::= expr', 'params ::=',
                                      'modifierlist ::= modifierlist modifier modparameters',
                                      'modifierlist ::= modifier modparameters', 'modifier ::= VERT AT ID',
                                      'modifier ::= VERT ID', 'modparameters ::= modparameters modparameter',
                                      'modparameters ::=', 'modparameter ::= COLON value',
                                      'modparameter ::= COLON array', 'static_class_access ::= method',
                                      'static_class_access ::= method objectchain', 'static_class_access ::= ID',
                                      'static_class_access ::= DOLLARID arrayindex',
                                      'static_class_access ::= DOLLARID arrayindex objectchain', 'lop ::= LOGOP',
                                      'lop ::= TLOGOP', 'scond ::= SINGLECOND', 'array ::= OPENB arrayelements CLOSEB',
                                      'arrayelements ::= arrayelement',
                                      'arrayelements ::= arrayelements COMMA arrayelement', 'arrayelements ::=',
                                      'arrayelement ::= value APTR expr', 'arrayelement ::= ID APTR expr',
                                      'arrayelement ::= expr', 'doublequoted_with_quotes ::= QUOTE QUOTE',
                                      'doublequoted_with_quotes ::= QUOTE doublequoted QUOTE',
                                      'doublequoted ::= doublequoted doublequotedcontent',
                                      'doublequoted ::= doublequotedcontent',
                                      'doublequotedcontent ::= BACKTICK variable BACKTICK',
                                      'doublequotedcontent ::= BACKTICK expr BACKTICK',
                                      'doublequotedcontent ::= DOLLARID', 'doublequotedcontent ::= LDEL variable RDEL',
                                      'doublequotedcontent ::= LDEL expr RDEL', 'doublequotedcontent ::= smartytag',
                                      'doublequotedcontent ::= TEXT',);

    public function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[ $tokenType ];
        } else {
            return "Unknown";
        }
    }

    public static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:
                break;   /* If no destructor action specified: do nothing */
        }
    }

    public function yy_pop_parser_stack()
    {
        if (empty($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if ($this->yyTraceFILE && $this->yyidx >= 0) {
            fwrite($this->yyTraceFILE, $this->yyTracePrompt . 'Popping ' . $this->yyTokenName[ $yytos->major ] . "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx --;

        return $yymajor;
    }

    public function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource($this->yyTraceFILE)) {
            fclose($this->yyTraceFILE);
        }
    }

    public function yy_get_expected_tokens($token)
    {
        static $res3 = array();
        static $res4 = array();
        $state = $this->yystack[ $this->yyidx ]->stateno;
        $expected = self::$yyExpectedTokens[ $state ];
        if (isset($res3[ $state ][ $token ])) {
            if ($res3[ $state ][ $token ]) {
                return $expected;
            }
        } else {
            if ($res3[ $state ][ $token ] = in_array($token, self::$yyExpectedTokens[ $state ], true)) {
                return $expected;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done ++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[ $yyruleno ][ 1 ];
                    $nextstate = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno,
                                                              self::$yyRuleInfo[ $yyruleno ][ 0 ]);
                    if (isset(self::$yyExpectedTokens[ $nextstate ])) {
                        $expected = array_merge($expected, self::$yyExpectedTokens[ $nextstate ]);
                        if (isset($res4[ $nextstate ][ $token ])) {
                            if ($res4[ $nextstate ][ $token ]) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        } else {
                            if ($res4[ $nextstate ][ $token ] =
                                in_array($token, self::$yyExpectedTokens[ $nextstate ], true)
                            ) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx ++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[ $yyruleno ][ 0 ];
                        $this->yystack[ $this->yyidx ] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return array_unique($expected);
    }

    public function yy_is_expected_token($token)
    {
        static $res = array();
        static $res2 = array();
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[ $this->yyidx ]->stateno;
        if (isset($res[ $state ][ $token ])) {
            if ($res[ $state ][ $token ]) {
                return true;
            }
        } else {
            if ($res[ $state ][ $token ] = in_array($token, self::$yyExpectedTokens[ $state ], true)) {
                return true;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done ++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[ $yyruleno ][ 1 ];
                    $nextstate = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno,
                                                              self::$yyRuleInfo[ $yyruleno ][ 0 ]);
                    if (isset($res2[ $nextstate ][ $token ])) {
                        if ($res2[ $nextstate ][ $token ]) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    } else {
                        if ($res2[ $nextstate ][ $token ] = (isset(self::$yyExpectedTokens[ $nextstate ]) &&
                            in_array($token, self::$yyExpectedTokens[ $nextstate ], true))
                        ) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx ++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[ $yyruleno ][ 0 ];
                        $this->yystack[ $this->yyidx ] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return true;
    }

    public function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[ $this->yyidx ]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[ $stateno ])) {
            // no shift actions
            return self::$yy_default[ $stateno ];
        }
        $i = self::$yy_shift_ofst[ $stateno ];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[ $stateno ];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB || self::$yy_lookahead[ $i ] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback) &&
                ($iFallback = self::$yyFallback[ $iLookAhead ]) != 0
            ) {
                if ($this->yyTraceFILE) {
                    fwrite($this->yyTraceFILE,
                           $this->yyTracePrompt . "FALLBACK " . $this->yyTokenName[ $iLookAhead ] . " => " .
                           $this->yyTokenName[ $iFallback ] . "\n");
                }

                return $this->yy_find_shift_action($iFallback);
            }

            return self::$yy_default[ $stateno ];
        } else {
            return self::$yy_action[ $i ];
        }
    }

    public function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[ $stateno ])) {
            return self::$yy_default[ $stateno ];
        }
        $i = self::$yy_reduce_ofst[ $stateno ];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[ $stateno ];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB || self::$yy_lookahead[ $i ] != $iLookAhead) {
            return self::$yy_default[ $stateno ];
        } else {
            return self::$yy_action[ $i ];
        }
    }

    public function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx ++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx --;
            if ($this->yyTraceFILE) {
                fprintf($this->yyTraceFILE, "%sStack Overflow!\n", $this->yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            #line 214 "../smarty/lexer/smarty_internal_templateparser.y"

            $this->internalError = true;
            $this->compiler->trigger_template_error("Stack overflow in template parser");

            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        $this->yystack[] = $yytos;
        if ($this->yyTraceFILE && $this->yyidx > 0) {
            fprintf($this->yyTraceFILE, "%sShift %d\n", $this->yyTracePrompt, $yyNewState);
            fprintf($this->yyTraceFILE, "%sStack:", $this->yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i ++) {
                fprintf($this->yyTraceFILE, " %s", $this->yyTokenName[ $this->yystack[ $i ]->major ]);
            }
            fwrite($this->yyTraceFILE, "\n");
        }
    }

    public static $yyRuleInfo = array(array(0 => 61, 1 => 1), array(0 => 62, 1 => 1), array(0 => 62, 1 => 2),
                                      array(0 => 62, 1 => 0), array(0 => 63, 1 => 1), array(0 => 63, 1 => 1),
                                      array(0 => 63, 1 => 1), array(0 => 63, 1 => 1), array(0 => 63, 1 => 1),
                                      array(0 => 66, 1 => 1), array(0 => 66, 1 => 2), array(0 => 63, 1 => 1),
                                      array(0 => 63, 1 => 1), array(0 => 65, 1 => 2), array(0 => 65, 1 => 3),
                                      array(0 => 67, 1 => 2), array(0 => 67, 1 => 0), array(0 => 68, 1 => 1),
                                      array(0 => 68, 1 => 1), array(0 => 64, 1 => 2), array(0 => 64, 1 => 1),
                                      array(0 => 69, 1 => 2), array(0 => 69, 1 => 3), array(0 => 69, 1 => 2),
                                      array(0 => 69, 1 => 3), array(0 => 69, 1 => 2), array(0 => 69, 1 => 3),
                                      array(0 => 69, 1 => 4), array(0 => 69, 1 => 4), array(0 => 69, 1 => 5),
                                      array(0 => 69, 1 => 5), array(0 => 64, 1 => 1), array(0 => 69, 1 => 3),
                                      array(0 => 69, 1 => 2), array(0 => 69, 1 => 4), array(0 => 69, 1 => 5),
                                      array(0 => 69, 1 => 6), array(0 => 69, 1 => 2), array(0 => 69, 1 => 3),
                                      array(0 => 69, 1 => 2), array(0 => 69, 1 => 3), array(0 => 69, 1 => 8),
                                      array(0 => 78, 1 => 2), array(0 => 78, 1 => 1), array(0 => 69, 1 => 5),
                                      array(0 => 69, 1 => 7), array(0 => 69, 1 => 2), array(0 => 69, 1 => 6),
                                      array(0 => 69, 1 => 8), array(0 => 69, 1 => 6), array(0 => 69, 1 => 8),
                                      array(0 => 69, 1 => 3), array(0 => 69, 1 => 4), array(0 => 69, 1 => 2),
                                      array(0 => 64, 1 => 1), array(0 => 69, 1 => 2), array(0 => 69, 1 => 3),
                                      array(0 => 69, 1 => 4), array(0 => 69, 1 => 5), array(0 => 71, 1 => 2),
                                      array(0 => 71, 1 => 1), array(0 => 71, 1 => 0), array(0 => 81, 1 => 4),
                                      array(0 => 81, 1 => 2), array(0 => 81, 1 => 2), array(0 => 81, 1 => 2),
                                      array(0 => 81, 1 => 2), array(0 => 81, 1 => 2), array(0 => 81, 1 => 4),
                                      array(0 => 77, 1 => 1), array(0 => 77, 1 => 3), array(0 => 76, 1 => 3),
                                      array(0 => 76, 1 => 3), array(0 => 76, 1 => 3), array(0 => 76, 1 => 3),
                                      array(0 => 73, 1 => 1), array(0 => 73, 1 => 1), array(0 => 73, 1 => 3),
                                      array(0 => 73, 1 => 3), array(0 => 73, 1 => 3), array(0 => 73, 1 => 1),
                                      array(0 => 73, 1 => 2), array(0 => 73, 1 => 3), array(0 => 73, 1 => 2),
                                      array(0 => 73, 1 => 3), array(0 => 73, 1 => 3), array(0 => 73, 1 => 3),
                                      array(0 => 73, 1 => 3), array(0 => 82, 1 => 7), array(0 => 82, 1 => 7),
                                      array(0 => 72, 1 => 1), array(0 => 72, 1 => 2), array(0 => 72, 1 => 2),
                                      array(0 => 72, 1 => 2), array(0 => 72, 1 => 2), array(0 => 72, 1 => 1),
                                      array(0 => 72, 1 => 1), array(0 => 72, 1 => 3), array(0 => 72, 1 => 2),
                                      array(0 => 72, 1 => 2), array(0 => 72, 1 => 1), array(0 => 72, 1 => 1),
                                      array(0 => 72, 1 => 3), array(0 => 72, 1 => 1), array(0 => 72, 1 => 1),
                                      array(0 => 72, 1 => 3), array(0 => 72, 1 => 1), array(0 => 72, 1 => 2),
                                      array(0 => 72, 1 => 1), array(0 => 72, 1 => 3), array(0 => 86, 1 => 1),
                                      array(0 => 86, 1 => 1), array(0 => 70, 1 => 1), array(0 => 70, 1 => 1),
                                      array(0 => 70, 1 => 3), array(0 => 70, 1 => 1), array(0 => 70, 1 => 3),
                                      array(0 => 70, 1 => 4), array(0 => 70, 1 => 3), array(0 => 70, 1 => 4),
                                      array(0 => 74, 1 => 2), array(0 => 74, 1 => 2), array(0 => 91, 1 => 2),
                                      array(0 => 91, 1 => 0), array(0 => 92, 1 => 2), array(0 => 92, 1 => 2),
                                      array(0 => 92, 1 => 4), array(0 => 92, 1 => 2), array(0 => 92, 1 => 2),
                                      array(0 => 92, 1 => 4), array(0 => 92, 1 => 3), array(0 => 92, 1 => 5),
                                      array(0 => 92, 1 => 3), array(0 => 92, 1 => 3), array(0 => 92, 1 => 3),
                                      array(0 => 92, 1 => 3), array(0 => 92, 1 => 3), array(0 => 92, 1 => 3),
                                      array(0 => 92, 1 => 2), array(0 => 79, 1 => 1), array(0 => 79, 1 => 1),
                                      array(0 => 79, 1 => 2), array(0 => 93, 1 => 1), array(0 => 93, 1 => 1),
                                      array(0 => 93, 1 => 3), array(0 => 90, 1 => 2), array(0 => 94, 1 => 1),
                                      array(0 => 94, 1 => 2), array(0 => 95, 1 => 3), array(0 => 95, 1 => 3),
                                      array(0 => 95, 1 => 5), array(0 => 95, 1 => 6), array(0 => 95, 1 => 2),
                                      array(0 => 87, 1 => 4), array(0 => 96, 1 => 4), array(0 => 96, 1 => 4),
                                      array(0 => 97, 1 => 3), array(0 => 97, 1 => 1), array(0 => 97, 1 => 0),
                                      array(0 => 75, 1 => 3), array(0 => 75, 1 => 2), array(0 => 98, 1 => 3),
                                      array(0 => 98, 1 => 2), array(0 => 80, 1 => 2), array(0 => 80, 1 => 0),
                                      array(0 => 99, 1 => 2), array(0 => 99, 1 => 2), array(0 => 89, 1 => 1),
                                      array(0 => 89, 1 => 2), array(0 => 89, 1 => 1), array(0 => 89, 1 => 2),
                                      array(0 => 89, 1 => 3), array(0 => 84, 1 => 1), array(0 => 84, 1 => 1),
                                      array(0 => 85, 1 => 1), array(0 => 83, 1 => 3), array(0 => 100, 1 => 1),
                                      array(0 => 100, 1 => 3), array(0 => 100, 1 => 0), array(0 => 101, 1 => 3),
                                      array(0 => 101, 1 => 3), array(0 => 101, 1 => 1), array(0 => 88, 1 => 2),
                                      array(0 => 88, 1 => 3), array(0 => 102, 1 => 2), array(0 => 102, 1 => 1),
                                      array(0 => 103, 1 => 3), array(0 => 103, 1 => 3), array(0 => 103, 1 => 1),
                                      array(0 => 103, 1 => 3), array(0 => 103, 1 => 3), array(0 => 103, 1 => 1),
                                      array(0 => 103, 1 => 1),);

    public static $yyReduceMap = array(0   => 0, 1 => 1, 2 => 2, 4 => 4, 5 => 5, 6 => 6, 7 => 7, 8 => 8, 9 => 9,
                                       17  => 9, 18 => 9, 43 => 9, 66 => 9, 67 => 9, 75 => 9, 76 => 9, 80 => 9, 90 => 9,
                                       95  => 9, 96 => 9, 101 => 9, 103 => 9, 104 => 9, 108 => 9, 110 => 9, 115 => 9,
                                       176 => 9, 181 => 9, 10 => 10, 11 => 11, 12 => 12, 13 => 13, 16 => 13, 14 => 14,
                                       74  => 14, 15 => 15, 91 => 15, 93 => 15, 94 => 15, 122 => 15, 19 => 19, 20 => 20,
                                       21  => 21, 23 => 21, 25 => 21, 22 => 22, 24 => 22, 26 => 22, 27 => 27, 28 => 27,
                                       29  => 29, 30 => 30, 31 => 31, 32 => 32, 33 => 33, 34 => 34, 35 => 35, 36 => 36,
                                       37  => 37, 38 => 38, 40 => 38, 39 => 39, 41 => 41, 42 => 42, 44 => 44, 45 => 45,
                                       46  => 46, 47 => 47, 49 => 47, 48 => 48, 50 => 48, 51 => 51, 52 => 52, 53 => 53,
                                       54  => 54, 55 => 55, 56 => 56, 57 => 57, 58 => 58, 59 => 59, 60 => 60, 69 => 60,
                                       157 => 60, 161 => 60, 165 => 60, 166 => 60, 61 => 61, 158 => 61, 164 => 61,
                                       62  => 62, 63 => 63, 64 => 63, 65 => 65, 142 => 65, 68 => 68, 70 => 70, 71 => 71,
                                       72  => 71, 73 => 73, 77 => 77, 78 => 78, 79 => 78, 81 => 81, 107 => 81, 82 => 82,
                                       83  => 83, 84 => 84, 85 => 85, 86 => 86, 87 => 86, 88 => 88, 89 => 89, 92 => 92,
                                       97  => 97, 98 => 98, 99 => 99, 100 => 100, 102 => 102, 105 => 105, 106 => 106,
                                       109 => 109, 111 => 111, 112 => 112, 113 => 113, 114 => 114, 116 => 116,
                                       117 => 117, 118 => 118, 119 => 119, 120 => 120, 121 => 121, 123 => 123,
                                       178 => 123, 124 => 124, 125 => 125, 126 => 126, 127 => 127, 128 => 128,
                                       129 => 129, 137 => 129, 130 => 130, 131 => 131, 132 => 132, 133 => 132,
                                       135 => 132, 136 => 132, 134 => 134, 138 => 138, 139 => 139, 140 => 140,
                                       182 => 140, 141 => 141, 143 => 143, 144 => 144, 145 => 145, 146 => 146,
                                       147 => 147, 148 => 148, 149 => 149, 150 => 150, 151 => 151, 152 => 152,
                                       153 => 153, 154 => 154, 155 => 155, 156 => 156, 159 => 159, 160 => 160,
                                       162 => 162, 163 => 163, 167 => 167, 168 => 168, 169 => 169, 170 => 170,
                                       171 => 171, 172 => 172, 173 => 173, 174 => 174, 175 => 175, 177 => 177,
                                       179 => 179, 180 => 180, 183 => 183, 184 => 184, 185 => 185, 186 => 186,
                                       187 => 186, 189 => 186, 188 => 188, 190 => 190, 191 => 191, 192 => 192,);

    #line 225 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r0()
    {
        $this->root_buffer->prepend_array($this, $this->template_prefix);
        $this->root_buffer->append_array($this, $this->template_postfix);
        $this->_retvalue = $this->root_buffer->to_smarty_php($this);
    }

    #line 235 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r1()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor != null) {
            $this->current_buffer->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 242 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r2()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor != null) {
            // because of possible code injection
            $this->current_buffer->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 256 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r4()
    {
        if ($this->compiler->has_code) {
            $this->_retvalue = $this->mergePrefixCode($this->yystack[ $this->yyidx + 0 ]->minor);
        } else {
            $this->_retvalue = null;
        }
        $this->compiler->has_variable_string = false;
        $this->block_nesting_level = count($this->compiler->_tag_stack);
    }

    #line 267 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r5()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Text($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 271 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r6()
    {
        $code = $this->compiler->compileTag('private_php',
                                            array(array('code' => $this->yystack[ $this->yyidx + 0 ]->minor),
                                                  array('type' => $this->lex->phpType)), array());
        if ($this->compiler->has_code && !empty($code)) {
            $tmp = '';
            foreach ($this->compiler->prefix_code as $code) {
                $tmp .= $code;
            }
            $this->compiler->prefix_code = array();
            $this->_retvalue =
                new Smarty_Internal_ParseTree_Tag($this, $this->compiler->processNocacheCode($tmp . $code, true));
        } else {
            $this->_retvalue = null;
        }
    }

    #line 282 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r7()
    {
        $this->compiler->tag_nocache = true;
        $save = $this->template->compiled->has_nocache_code;
        $this->_retvalue = new Smarty_Internal_ParseTree_Tag($this,
                                                             $this->compiler->processNocacheCode("<?php echo '{$this->yystack[$this->yyidx + 0]->minor}';?>\n",
                                                                                                 $this->compiler,
                                                                                                 true));
        $this->template->compiled->has_nocache_code = $save;
    }

    #line 289 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r8()
    {
        $this->_retvalue = $this->compiler->processText($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 293 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r9()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 297 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r10()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 302 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r11()
    {
        $this->strip = true;
    }

    #line 306 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r12()
    {
        $this->strip = false;
    }

    #line 311 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r13()
    {
        $this->_retvalue = '';
    }

    #line 315 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r14()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 319 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r15()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 335 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r19()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 341 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r20()
    {
        $var =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' $');
        if (preg_match('/^(.*)(\s+nocache)$/', $var, $match)) {
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array('nocache'),
                                                           array('value' => $this->compiler->compileVariable('\'' .
                                                                                                             $match[ 1 ] .
                                                                                                             '\'')));
        } else {
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                           array('value' => $this->compiler->compileVariable('\'' .
                                                                                                             $var .
                                                                                                             '\'')));
        }
    }

    #line 351 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r21()
    {
        $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                       array('value' => $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 355 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r22()
    {
        $this->_retvalue =
            $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                        array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor));
    }

    #line 378 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r27()
    {
        $this->_retvalue = $this->compiler->compileTag('assign', array(array('value' => $this->yystack[ $this->yyidx +
        0 ]->minor), array('var' => '\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '\'')));
    }

    #line 386 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r29()
    {
        $this->_retvalue = $this->compiler->compileTag('assign',
                                                       array_merge(array(array('value' => $this->yystack[ $this->yyidx +
                                                       - 1 ]->minor), array('var' => '\'' .
                                                           substr($this->yystack[ $this->yyidx + - 3 ]->minor, 1) .
                                                           '\'')), $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 390 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r30()
    {
        $this->_retvalue = $this->compiler->compileTag('assign',
                                                       array_merge(array(array('value' => $this->yystack[ $this->yyidx +
                                                       - 1 ]->minor), array('var' => $this->yystack[ $this->yyidx +
                                                       - 3 ]->minor[ 'var' ])),
                                                                   $this->yystack[ $this->yyidx + 0 ]->minor),
                                                       array('smarty_internal_index' => $this->yystack[ $this->yyidx +
                                                       - 3 ]->minor[ 'smarty_internal_index' ]));
    }

    #line 395 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r31()
    {
        $tag =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length));
        if ($tag == 'strip') {
            $this->strip = true;
            $this->_retvalue = null;;
        } else {
            if (defined($tag)) {
                if ($this->security) {
                    $this->security->isTrustedConstant($tag, $this->compiler);
                }
                $this->_retvalue =
                    $this->compiler->compileTag('private_print_expression', array(), array('value' => $tag));
            } else {
                if (preg_match('/^(.*)(\s+nocache)$/', $tag, $match)) {
                    $this->_retvalue = $this->compiler->compileTag($match[ 1 ], array("'nocache'"));
                } else {
                    $this->_retvalue = $this->compiler->compileTag($tag, array());
                }
            }
        }
    }

    #line 417 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r32()
    {
        if (defined($this->yystack[ $this->yyidx + - 1 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + - 1 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                            array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                           $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 427 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r33()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                           array('value' => $this->yystack[ $this->yyidx + 0 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + 0 ]->minor, array());
        }
    }

    #line 440 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r34()
    {
        if (defined($this->yystack[ $this->yyidx + - 2 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + - 2 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                            array('value'        => $this->yystack[ $this->yyidx + - 2 ]->minor,
                                                  'modifierlist' => $this->yystack[ $this->yyidx + - 1 ]->minor));
        } else {
            $this->_retvalue = '<?php ob_start();?>' .
                $this->compiler->compileTag($this->yystack[ $this->yyidx + - 2 ]->minor,
                                            $this->yystack[ $this->yyidx + 0 ]->minor) . '<?php echo ';
            $this->_retvalue .= $this->compiler->compileTag('private_modifier', array(),
                                                            array('modifierlist'  => $this->yystack[ $this->yyidx +
                                                            - 1 ]->minor, 'value' => 'ob_get_clean()')) . ';?>';
        }
    }

    #line 453 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r35()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 3 ]->minor,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                       - 1 ]->minor));
    }

    #line 458 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r36()
    {
        $this->_retvalue = '<?php ob_start();?>' .
            $this->compiler->compileTag($this->yystack[ $this->yyidx + - 4 ]->minor,
                                        $this->yystack[ $this->yyidx + 0 ]->minor,
                                        array('object_method' => $this->yystack[ $this->yyidx + - 2 ]->minor)) .
            '<?php echo ';
        $this->_retvalue .= $this->compiler->compileTag('private_modifier', array(),
                                                        array('modifierlist'  => $this->yystack[ $this->yyidx +
                                                        - 1 ]->minor, 'value' => 'ob_get_clean()')) . ';?>';
    }

    #line 464 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r37()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 1 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag, array(),
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                       0 ]->minor));
    }

    #line 469 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r38()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 2 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                       - 1 ]->minor));
    }

    #line 474 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r39()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 1 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag, array(),
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                       0 ]->minor));
    }

    #line 485 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r41()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                          - 6 ]->minor),
                                                                                array('ifexp' => $this->yystack[ $this->yyidx +
                                                                                - 4 ]->minor),
                                                                                array('var' => $this->yystack[ $this->yyidx +
                                                                                - 2 ]->minor),
                                                                                array('step' => $this->yystack[ $this->yyidx +
                                                                                - 1 ]->minor))), 1);
    }

    #line 489 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r42()
    {
        $this->_retvalue = '=' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 497 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r44()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                          - 3 ]->minor),
                                                                                array('to' => $this->yystack[ $this->yyidx +
                                                                                - 1 ]->minor))), 0);
    }

    #line 501 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r45()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                          - 5 ]->minor),
                                                                                array('to' => $this->yystack[ $this->yyidx +
                                                                                - 3 ]->minor),
                                                                                array('step' => $this->yystack[ $this->yyidx +
                                                                                - 1 ]->minor))), 0);
    }

    #line 506 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r46()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 511 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r47()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                              array(array('from' => $this->yystack[ $this->yyidx +
                                                                              - 3 ]->minor),
                                                                                    array('item' => $this->yystack[ $this->yyidx +
                                                                                    - 1 ]->minor))));
    }

    #line 515 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r48()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                              array(array('from' => $this->yystack[ $this->yyidx +
                                                                              - 5 ]->minor),
                                                                                    array('item' => $this->yystack[ $this->yyidx +
                                                                                    - 1 ]->minor),
                                                                                    array('key' => $this->yystack[ $this->yyidx +
                                                                                    - 3 ]->minor))));
    }

    #line 528 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r51()
    {
        $this->_retvalue = $this->compiler->compileTag('setfilter', array(),
                                                       array('modifier_list' => array(array_merge(array($this->yystack[ $this->yyidx +
                                                       - 1 ]->minor), $this->yystack[ $this->yyidx + 0 ]->minor))));
    }

    #line 532 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r52()
    {
        $this->_retvalue = $this->compiler->compileTag('setfilter', array(),
                                                       array('modifier_list' => array_merge(array(array_merge(array($this->yystack[ $this->yyidx +
                                                       - 2 ]->minor), $this->yystack[ $this->yyidx + - 1 ]->minor)),
                                                                                            $this->yystack[ $this->yyidx +
                                                                                            0 ]->minor)));
    }

    #line 537 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r53()
    {
        $j = strrpos($this->yystack[ $this->yyidx + 0 ]->minor, '.');
        if ($this->yystack[ $this->yyidx + 0 ]->minor[ $j + 1 ] == 'c') {
            // {$smarty.block.child}
            $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);
        } else {
            // {$smarty.block.parent}
            $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileParentBlock($this->compiler);
        }
    }

    #line 550 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r54()
    {
        $tag =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' /');
        if ($tag == 'strip') {
            $this->strip = false;
            $this->_retvalue = null;
        } else {
            $this->_retvalue = $this->compiler->compileTag($tag . 'close', array());
        }
    }

    #line 559 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r55()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + 0 ]->minor . 'close', array());
    }

    #line 563 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r56()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 1 ]->minor . 'close', array(),
                                                       array('modifier_list' => $this->yystack[ $this->yyidx +
                                                       0 ]->minor));
    }

    #line 568 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r57()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 2 ]->minor . 'close', array(),
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                       0 ]->minor));
    }

    #line 572 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r58()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 3 ]->minor . 'close', array(),
                                                       array('object_method'         => $this->yystack[ $this->yyidx +
                                                       - 1 ]->minor, 'modifier_list' => $this->yystack[ $this->yyidx +
                                                       0 ]->minor));
    }

    #line 580 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r59()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
        $this->_retvalue[] = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 586 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r60()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 591 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r61()
    {
        $this->_retvalue = array();
    }

    #line 596 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r62()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                array($this->yystack[ $this->yyidx + - 2 ]->minor => $this->yystack[ $this->yyidx + 0 ]->minor);
        } else {
            $this->_retvalue =
                array($this->yystack[ $this->yyidx + - 2 ]->minor => '\'' . $this->yystack[ $this->yyidx + 0 ]->minor .
                    '\'');
        }
    }

    #line 607 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r63()
    {
        $this->_retvalue =
            array(trim($this->yystack[ $this->yyidx + - 1 ]->minor, " =\n\r\t") => $this->yystack[ $this->yyidx +
            0 ]->minor);
    }

    #line 615 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r65()
    {
        $this->_retvalue = '\'' . $this->yystack[ $this->yyidx + 0 ]->minor . '\'';
    }

    #line 627 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r68()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 2 ]->minor => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 640 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r70()
    {
        $this->yystack[ $this->yyidx + - 2 ]->minor[] = $this->yystack[ $this->yyidx + 0 ]->minor;
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor;
    }

    #line 645 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r71()
    {
        $this->_retvalue = array('var'   => '\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '\'',
                                 'value' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 652 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r73()
    {
        $this->_retvalue = array('var'   => $this->yystack[ $this->yyidx + - 2 ]->minor,
                                 'value' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 676 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r77()
    {
        $this->_retvalue =
            '$_smarty_tpl->getStreamVariable(\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '://' .
            $this->yystack[ $this->yyidx + 0 ]->minor . '\')';
    }

    #line 681 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r78()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . trim($this->yystack[ $this->yyidx + - 1 ]->minor) .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 695 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r81()
    {
        $this->_retvalue = $this->compiler->compileTag('private_modifier', array(),
                                                       array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor,
                                                             'modifierlist' => $this->yystack[ $this->yyidx +
                                                             0 ]->minor));
    }

    #line 701 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r82()
    {
        $this->_retvalue = (isset($this->yystack[ $this->yyidx + - 1 ]->minor[ 'pre' ]) ?
                $this->yystack[ $this->yyidx + - 1 ]->minor[ 'pre' ] : '') .
            $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor[ 'op' ] .
            $this->yystack[ $this->yyidx + 0 ]->minor .
            (isset($this->yystack[ $this->yyidx + - 1 ]->minor[ 'pre' ]) ? ')' : '');
    }

    #line 704 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r83()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + 0 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 708 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r84()
    {
        $this->_retvalue = 'in_array(' . $this->yystack[ $this->yyidx + - 2 ]->minor . ',' .
            $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 712 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r85()
    {
        $this->_retvalue = 'in_array(' . $this->yystack[ $this->yyidx + - 2 ]->minor . ',(array)' .
            $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 716 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r86()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 728 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r88()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 5 ]->minor . ' ? ' .
            $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '\'') .
            ' : ' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 732 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r89()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 5 ]->minor . ' ? ' . $this->yystack[ $this->yyidx + - 2 ]->minor . ' : ' .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 747 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r92()
    {
        $this->_retvalue = '!' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 768 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r97()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 772 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r98()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . '.';
    }

    #line 776 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r99()
    {
        $this->_retvalue = '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 781 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r100()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
        } else {
            $this->_retvalue = '\'' . $this->yystack[ $this->yyidx + 0 ]->minor . '\'';
        }
    }

    #line 798 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r102()
    {
        $this->_retvalue = "(" . $this->yystack[ $this->yyidx + - 1 ]->minor . ")";
    }

    #line 813 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r105()
    {
        self::$prefix_number ++;
        if ($this->yystack[ $this->yyidx + - 2 ]->minor[ 'var' ] == '\'smarty\'') {
            $this->compiler->prefix_code[] = '<?php $_tmp' . self::$prefix_number . ' = ' .
                $this->compiler->compileTag('private_special_variable', array(),
                                            $this->yystack[ $this->yyidx + - 2 ]->minor[ 'smarty_internal_index' ]) .
                ';?>';
        } else {
            $this->compiler->prefix_code[] = '<?php $_tmp' . self::$prefix_number . ' = ' .
                $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 2 ]->minor[ 'var' ]) .
                $this->yystack[ $this->yyidx + - 2 ]->minor[ 'smarty_internal_index' ] . ';?>';
        }
        $this->_retvalue = '$_tmp' . self::$prefix_number . '::' . $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] .
            $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
    }

    #line 824 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r106()
    {
        self::$prefix_number ++;
        $tmp = $this->compiler->appendCode('<?php ob_start();?>', $this->yystack[ $this->yyidx + 0 ]->minor);
        $this->compiler->prefix_code[] =
            $this->compiler->appendCode($tmp, '<?php $_tmp' . self::$prefix_number . '=ob_get_clean();?>');
        $this->_retvalue = '$_tmp' . self::$prefix_number;
    }

    #line 841 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r109()
    {
        if (!in_array(strtolower($this->yystack[ $this->yyidx + - 2 ]->minor), array('self', 'parent')) &&
            (!$this->security ||
                $this->security->isTrustedStaticClassAccess($this->yystack[ $this->yyidx + - 2 ]->minor,
                                                            $this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler))
        ) {
            if (isset($this->smarty->registered_classes[ $this->yystack[ $this->yyidx + - 2 ]->minor ])) {
                $this->_retvalue =
                    $this->smarty->registered_classes[ $this->yystack[ $this->yyidx + - 2 ]->minor ] . '::' .
                    $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] . $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
            } else {
                $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . '::' .
                    $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] . $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
            }
        } else {
            $this->compiler->trigger_template_error("static class '" . $this->yystack[ $this->yyidx + - 2 ]->minor .
                                                    "' is undefined or not allowed by security setting");
        }
    }

    #line 860 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r111()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 871 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r112()
    {
        $this->_retvalue =
            $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'');
    }

    #line 874 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r113()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ] == '\'smarty\'') {
            $smarty_var = $this->compiler->compileTag('private_special_variable', array(),
                                                      $this->yystack[ $this->yyidx +
                                                      0 ]->minor[ 'smarty_internal_index' ]);
            $this->_retvalue = $smarty_var;
        } else {
            // used for array reset,next,prev,end,current
            $this->last_variable = $this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ];
            $this->last_index = $this->yystack[ $this->yyidx + 0 ]->minor[ 'smarty_internal_index' ];
            $this->_retvalue = $this->compiler->compileVariable($this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ]) .
                $this->yystack[ $this->yyidx + 0 ]->minor[ 'smarty_internal_index' ];
        }
    }

    #line 887 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r114()
    {
        $this->_retvalue = '$_smarty_tpl->tpl_vars[' . $this->yystack[ $this->yyidx + - 2 ]->minor . ']->' .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 897 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r116()
    {
        $this->_retvalue =
            $this->compiler->compileConfigVariable("'" . $this->yystack[ $this->yyidx + - 1 ]->minor . "'");
    }

    #line 901 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r117()
    {
        $this->_retvalue = '(is_array($tmp = ' .
            $this->compiler->compileConfigVariable("'" . $this->yystack[ $this->yyidx + - 2 ]->minor . "'") .
            ') ? $tmp' . $this->yystack[ $this->yyidx + 0 ]->minor . ' :null)';
    }

    #line 905 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r118()
    {
        $this->_retvalue = $this->compiler->compileConfigVariable($this->yystack[ $this->yyidx + - 1 ]->minor);
    }

    #line 909 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r119()
    {
        $this->_retvalue =
            '(is_array($tmp = ' . $this->compiler->compileConfigVariable($this->yystack[ $this->yyidx + - 2 ]->minor) .
            ') ? $tmp' . $this->yystack[ $this->yyidx + 0 ]->minor . ' : null)';
    }

    #line 913 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r120()
    {
        $this->_retvalue = array('var' => '\'' . substr($this->yystack[ $this->yyidx + - 1 ]->minor, 1) . '\'',
                                 'smarty_internal_index' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 916 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r121()
    {
        $this->_retvalue = array('var'                   => $this->yystack[ $this->yyidx + - 1 ]->minor,
                                 'smarty_internal_index' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 929 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r123()
    {
        return;
    }

    #line 935 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r124()
    {
        $this->_retvalue =
            '[' . $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'') .
            ']';
    }

    #line 938 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r125()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + 0 ]->minor) . ']';
    }

    #line 942 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r126()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 2 ]->minor) . '->' .
            $this->yystack[ $this->yyidx + 0 ]->minor . ']';
    }

    #line 946 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r127()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue = '[' . $this->yystack[ $this->yyidx + 0 ]->minor . ']';
        } else {
            $this->_retvalue = "['" . $this->yystack[ $this->yyidx + 0 ]->minor . "']";
        }
    }

    #line 957 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r128()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + 0 ]->minor . ']';
    }

    #line 962 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r129()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + - 1 ]->minor . ']';
    }

    #line 967 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r130()
    {
        $this->_retvalue = '[' . $this->compiler->compileTag('private_special_variable', array(), '[\'section\'][\'' .
                                                                                       $this->yystack[ $this->yyidx +
                                                                                       - 1 ]->minor .
                                                                                       '\'][\'index\']') . ']';
    }

    #line 971 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r131()
    {
        $this->_retvalue = '[' . $this->compiler->compileTag('private_special_variable', array(), '[\'section\'][\'' .
                                                                                       $this->yystack[ $this->yyidx +
                                                                                       - 3 ]->minor . '\'][\'' .
                                                                                       $this->yystack[ $this->yyidx +
                                                                                       - 1 ]->minor . '\']') . ']';
    }

    #line 974 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r132()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + - 1 ]->minor . ']';
    }

    #line 980 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r134()
    {
        $this->_retvalue = '[' .
            $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + - 1 ]->minor, 1) . '\'') .
            ']';;
    }

    #line 996 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r138()
    {
        $this->_retvalue = '[]';
    }

    #line 1006 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r139()
    {
        $this->_retvalue = '\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'';
    }

    #line 1010 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r140()
    {
        $this->_retvalue = "''";
    }

    #line 1015 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r141()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 1 ]->minor . '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1023 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r143()
    {
        $var =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' $');
        $this->_retvalue = $this->compiler->compileVariable('\'' . $var . '\'');
    }

    #line 1029 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r144()
    {
        $this->_retvalue = '(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 1036 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r145()
    {
        if ($this->yystack[ $this->yyidx + - 1 ]->minor[ 'var' ] == '\'smarty\'') {
            $this->_retvalue = $this->compiler->compileTag('private_special_variable', array(),
                                                           $this->yystack[ $this->yyidx +
                                                           - 1 ]->minor[ 'smarty_internal_index' ]) .
                $this->yystack[ $this->yyidx + 0 ]->minor;
        } else {
            $this->_retvalue = $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 1 ]->minor[ 'var' ]) .
                $this->yystack[ $this->yyidx + - 1 ]->minor[ 'smarty_internal_index' ] .
                $this->yystack[ $this->yyidx + 0 ]->minor;
        }
    }

    #line 1045 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r146()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1050 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r147()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1055 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r148()
    {
        if ($this->security && substr($this->yystack[ $this->yyidx + - 1 ]->minor, 0, 1) == '_') {
            $this->compiler->trigger_template_error(self::Err1);
        }
        $this->_retvalue =
            '->' . $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1062 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r149()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue = '->{' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 1 ]->minor) .
            $this->yystack[ $this->yyidx + 0 ]->minor . '}';
    }

    #line 1069 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r150()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue =
            '->{' . $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor . '}';
    }

    #line 1076 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r151()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue = '->{\'' . $this->yystack[ $this->yyidx + - 4 ]->minor . '\'.' .
            $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor . '}';
    }

    #line 1084 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r152()
    {
        $this->_retvalue = '->' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1092 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r153()
    {
        if (!$this->security ||
            $this->security->isTrustedPhpFunction($this->yystack[ $this->yyidx + - 3 ]->minor, $this->compiler)
        ) {
            if (strcasecmp($this->yystack[ $this->yyidx + - 3 ]->minor, 'isset') === 0 ||
                strcasecmp($this->yystack[ $this->yyidx + - 3 ]->minor, 'empty') === 0 ||
                strcasecmp($this->yystack[ $this->yyidx + - 3 ]->minor, 'array') === 0 ||
                is_callable($this->yystack[ $this->yyidx + - 3 ]->minor)
            ) {
                $func_name = strtolower($this->yystack[ $this->yyidx + - 3 ]->minor);
                if ($func_name == 'isset') {
                    if (count($this->yystack[ $this->yyidx + - 1 ]->minor) == 0) {
                        $this->compiler->trigger_template_error('Illegal number of paramer in "isset()"');
                    }
                    $par = implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor);
                    if (strncasecmp($par, '$_smarty_tpl->smarty->ext->_config->_getConfigVariable',
                                    strlen('$_smarty_tpl->smarty->ext->_config->_getConfigVariable')) === 0
                    ) {
                        self::$prefix_number ++;
                        $this->compiler->prefix_code[] =
                            '<?php $_tmp' . self::$prefix_number . '=' . str_replace(')', ', false)', $par) . ';?>';
                        $isset_par = '$_tmp' . self::$prefix_number;
                    } else {
                        $isset_par = str_replace("')->value", "',null,true,false)->value", $par);
                    }
                    $this->_retvalue = $this->yystack[ $this->yyidx + - 3 ]->minor . "(" . $isset_par . ")";
                } elseif (in_array($func_name, array('empty', 'reset', 'current', 'end', 'prev', 'next'))) {
                    if (count($this->yystack[ $this->yyidx + - 1 ]->minor) != 1) {
                        $this->compiler->trigger_template_error('Illegal number of paramer in "empty()"');
                    }
                    if ($func_name == 'empty') {
                        $this->_retvalue = $func_name . '(' . str_replace("')->value", "',null,true,false)->value",
                                                                          $this->yystack[ $this->yyidx +
                                                                          - 1 ]->minor[ 0 ]) . ')';
                    } else {
                        $this->_retvalue = $func_name . '(' . $this->yystack[ $this->yyidx + - 1 ]->minor[ 0 ] . ')';
                    }
                } else {
                    $this->_retvalue = $this->yystack[ $this->yyidx + - 3 ]->minor . "(" .
                        implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ")";
                }
            } else {
                $this->compiler->trigger_template_error("unknown function \"" .
                                                        $this->yystack[ $this->yyidx + - 3 ]->minor . "\"");
            }
        }
    }

    #line 1131 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r154()
    {
        if ($this->security && substr($this->yystack[ $this->yyidx + - 3 ]->minor, 0, 1) == '_') {
            $this->compiler->trigger_template_error(self::Err1);
        }
        $this->_retvalue = $this->yystack[ $this->yyidx + - 3 ]->minor . "(" .
            implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ")";
    }

    #line 1138 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r155()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        self::$prefix_number ++;
        $this->compiler->prefix_code[] = '<?php $_tmp' . self::$prefix_number . '=' .
            $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + - 3 ]->minor, 1) . '\'') .
            ';?>';
        $this->_retvalue =
            '$_tmp' . self::$prefix_number . '(' . implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ')';
    }

    #line 1149 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r156()
    {
        $this->_retvalue =
            array_merge($this->yystack[ $this->yyidx + - 2 ]->minor, array($this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 1166 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r159()
    {
        $this->_retvalue = array_merge($this->yystack[ $this->yyidx + - 2 ]->minor,
                                       array(array_merge($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                         $this->yystack[ $this->yyidx + 0 ]->minor)));
    }

    #line 1170 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r160()
    {
        $this->_retvalue =
            array(array_merge($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 1178 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r162()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1186 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r163()
    {
        $this->_retvalue =
            array_merge($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1205 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r167()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor, '', 'method');
    }

    #line 1210 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r168()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor, 'method');
    }

    #line 1215 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r169()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor, '');
    }

    #line 1220 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r170()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor, 'property');
    }

    #line 1225 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r171()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + - 2 ]->minor,
                                 $this->yystack[ $this->yyidx + - 1 ]->minor .
                                 $this->yystack[ $this->yyidx + 0 ]->minor, 'property');
    }

    #line 1231 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r172()
    {
        $this->_retvalue[ 'op' ] = ' ' . trim($this->yystack[ $this->yyidx + 0 ]->minor) . ' ';
    }

    #line 1235 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r173()
    {
        static $lops = array('eq'          => array('op' => ' == ', 'pre' => null),
                             'ne'          => array('op' => ' != ', 'pre' => null),
                             'neq'         => array('op' => ' != ', 'pre' => null),
                             'gt'          => array('op' => ' > ', 'pre' => null),
                             'ge'          => array('op' => ' >= ', 'pre' => null),
                             'gte'         => array('op' => ' >= ', 'pre' => null),
                             'lt'          => array('op' => ' < ', 'pre' => null),
                             'le'          => array('op' => ' <= ', 'pre' => null),
                             'lte'         => array('op' => ' <= ', 'pre' => null),
                             'mod'         => array('op' => ' % ', 'pre' => null),
                             'and'         => array('op' => ' && ', 'pre' => null),
                             'or'          => array('op' => ' || ', 'pre' => null),
                             'xor'         => array('op' => ' xor ', 'pre' => null),
                             'isdivby'     => array('op' => ' % ', 'pre' => '!('),
                             'isnotdivby'  => array('op' => ' % ', 'pre' => '('),
                             'isevenby'    => array('op' => ' / ', 'pre' => '!(1 & '),
                             'isnotevenby' => array('op' => ' / ', 'pre' => '(1 & '),
                             'isoddby'     => array('op' => ' / ', 'pre' => '(1 & '),
                             'isnotoddby'  => array('op' => ' / ', 'pre' => '!(1 & '),);
        $op = strtolower(preg_replace('/\s*/', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $lops[ $op ];
    }

    #line 1261 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r174()
    {
        static $scond =
            array('iseven' => '!(1 & ', 'isnoteven' => '(1 & ', 'isodd' => '(1 & ', 'isnotodd' => '!(1 & ',);
        $op = strtolower(str_replace(' ', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $scond[ $op ];
    }

    #line 1275 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r175()
    {
        $this->_retvalue = 'array(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 1283 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r177()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . ',' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1291 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r179()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . '=>' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1295 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r180()
    {
        $this->_retvalue =
            '\'' . $this->yystack[ $this->yyidx + - 2 ]->minor . '\'=>' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1311 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r183()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor->to_smarty_php($this);
    }

    #line 1316 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r184()
    {
        $this->yystack[ $this->yyidx + - 1 ]->minor->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 1321 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r185()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Dq($this, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1325 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r186()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Code('(string)' . $this->yystack[ $this->yyidx + - 1 ]->minor);
    }

    #line 1333 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r188()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Code('(string)$_smarty_tpl->tpl_vars[\'' .
                                                              substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) .
                                                              '\']->value');
    }

    #line 1341 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r190()
    {
        $this->_retvalue =
            new Smarty_Internal_ParseTree_Code('(string)(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')');
    }

    #line 1345 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r191()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Tag($this, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1349 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r192()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_DqContent($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    private $_retvalue;

    public function yy_reduce($yyruleno)
    {
        if ($this->yyTraceFILE && $yyruleno >= 0 && $yyruleno < count(self::$yyRuleName)) {
            fprintf($this->yyTraceFILE, "%sReduce (%d) [%s].\n", $this->yyTracePrompt, $yyruleno,
                    self::$yyRuleName[ $yyruleno ]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (isset(self::$yyReduceMap[ $yyruleno ])) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[ $yyruleno ]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[ $yyruleno ][ 0 ];
        $yysize = self::$yyRuleInfo[ $yyruleno ][ 1 ];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i --) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!$this->yyTraceFILE && $yysize) {
                $this->yyidx ++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[ $this->yyidx ] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    public function yy_parse_failed()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sFail!\n", $this->yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    public function yy_syntax_error($yymajor, $TOKEN)
    {
        #line 207 "../smarty/lexer/smarty_internal_templateparser.y"

        $this->internalError = true;
        $this->yymajor = $yymajor;
        $this->compiler->trigger_template_error();
    }

    public function yy_accept()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sAccept!\n", $this->yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        #line 200 "../smarty/lexer/smarty_internal_templateparser.y"

        $this->successful = !$this->internalError;
        $this->internalError = false;
        $this->retvalue = $this->_retvalue;
    }

    public function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = - 1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            $this->yystack[] = $x;
        }
        $yyendofinput = ($yymajor == 0);

        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sInput %s\n", $this->yyTracePrompt, $this->yyTokenName[ $yymajor ]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL && !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt --;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if ($this->yyTraceFILE) {
                    fprintf($this->yyTraceFILE, "%sSyntax Error!\n", $this->yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[ $this->yyidx ]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit) {
                        if ($this->yyTraceFILE) {
                            fprintf($this->yyTraceFILE, "%sDiscard input token %s\n", $this->yyTracePrompt,
                                    $this->yyTokenName[ $yymajor ]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 && $yymx != self::YYERRORSYMBOL &&
                            ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE) {
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor == 0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}

