/*
 * Copyright 1997-98 by Pawel Krawczyk <kravietz@ceti.com.pl>
 *
 * See http://www.ceti.com.pl/~kravietz/progs/tacacs.html
 * for details.
 *
 * attrib.c  Procedures for handling internal list of attributes
 *			 for accounting and authorization functions. 
 */

#include <stdlib.h>
#include <string.h>

#include "tacplus.h"
#include "libtac.h"
#include "../server.h"

void tac_add_attrib(struct tac_attrib *attr, char *name, char *value) {
	struct tac_attrib *a;
	u_char l1, l2;

	a = attr;

	/* find last block in chain */
	while((a->attr != 0) && (a->next != 0)) {
		a = a->next;
	}
	
	/* fill the block */
	l1 = (u_char) strlen(name);
	l2 = (u_char) strlen(value);
	a->attr_len=l1+l2+1;
	a->attr = (char *) xmalloc(l1+l2+1);
	bcopy(name, a->attr, l1);
	*(a->attr+l1)='=';
	bcopy(value, (a->attr+l1+1), l2);

	/* allocate next structure */
	a->next=(struct tac_attrib *) xmalloc(sizeof(struct tac_attrib));
	
}

void tac_free_attrib(struct tac_attrib *attr) {
	struct tac_attrib *a;
	struct tac_attrib *b;

	a = attr;

	while(a->attr != 0 && a) {
		free(a->attr);
		b = a;
		a = a->next;
		free(b);
	}

}
