/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __REFERENCESIDEE__
#define __REFERENCESIDEE__

#include <src/global/global.h>

typedef struct referencesidee CONTENEUR(ReferencesIdee);

#include <src/donnees/sortie/denominationidee.h>
#include <src/donnees/idees/idees.h>

typedef struct referenceidee CONTENEUR_SCALAIRE(ReferenceIdee);

struct referenceidee
{
	STOCKAGE_SCALAIRE(TypeReference) type;
	//Type de la rfrence.
	STOCKAGE_SCALAIRE(NiveauHierarchique) niveau;
	//Niveau de l'ide destination.
	STOCKAGE(DenominationIdee) denomination;
	//Dnomination de la destination.
};
/* Cette structure sert  prciser une rfrence.
 * Cette structure sera utilise en interne. Elle
 * n'est donne qu' titre indicatif.
 */

struct referencesidee
{
	STOCKAGE_SCALAIRE(Taille) memoire;
	//Indique la place prise en mmoire.
	STOCKAGE_SCALAIRE(Taille) taille;
	//Indique la taille utilise du tableau.
	TABLEAU_(STOCKAGE_SCALAIRE(ReferenceIdee)) reference;
	//Les rfrences sont places dans ce tableau.
};
/* Structure servant  enregister toutes les rfrences
 * partant d'une ide.
 */

Resultat referencesidee_initialisation(TRAVAIL(ReferencesIdee) referencesidee);
/* Cre une structure d'enregistement de rfrences.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat referencesidee_ajout(TRAVAIL(ReferencesIdee) referencesidee , TRAVAIL_SCALAIRE(TypeReference) type , TRAVAIL(DenominationIdee) denomination , TRAVAIL_SCALAIRE(NiveauHierarchique) niveau);
/* Ajoute une rfrence dans le vecteur de rfrences.
 * Renvoie RESULTAT_ERREUR si referencesidee est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat referencesidee_taille(TRAVAIL(ReferencesIdee) referencesidee , REFERENCE_SCALAIRE(Taille) taille);
/* Renvoie le nombre de rfrences contenues dans la structure.
 * Renvoie RESULTAT_ERREUR si referencesidee est NULL.
 */

Resultat referencesidee_lecture(TRAVAIL(ReferencesIdee) referencesidee , TRAVAIL_SCALAIRE(Indice) indice , REFERENCE_SCALAIRE(TypeReference) type , REFERENCE(DenominationIdee) denomination , REFERENCE_SCALAIRE(NiveauHierarchique) niveau);
/* Lit une rfrence dans le vecteur de rfrences.
 * Renvoie RESULTAT_ERREUR si referencesidee est NULL.
 * Renvoie RESULTAT_ERREUR_DEPASSEMENT si l'indice est incorrect.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat referencesidee_recherche(TRAVAIL(ReferencesIdee) referencesidee , TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(Chaine) reference , COREFERENCE_SCALAIRE(Booleen) correct , REFERENCE_SCALAIRE(TypeReference) type , REFERENCE(DenominationIdee) denomination , REFERENCE_SCALAIRE(NiveauHierarchique) niveau);
/* Recherche une rfrence dans le vecteur de rfrences.
 * Le boolen indique si la recherche a aboutie.
 * Renvoie RESULTAT_ERREUR si referencesidee est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat referencesidee_copie(TRAVAIL(ReferencesIdee) referencesidee , TRAVAIL(ReferencesIdee) copie);
/* Ralise une copie des rfrences d'ide.
 * Si la copie tait non vide, elle est dtruite
 * avant la copie.
 * Renvoie RESULTAT_ERREUR si referencesidee est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat referencesidee_destruction(TRAVAIL(ReferencesIdee) referencesidee);
/* Dtruit les rfrences d'ide.
 */

#endif
