/*	Multiwriter_IOException

PIRL CVS ID: Multiwriter_IOException.java,v 1.4 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Utilities;

import	java.io.IOException;
import	java.util.Vector;

/**	A <i>Multiwriter_IOException</i> is an IOException that may carry
	multiple IOExceptions from multiple exception sources.
<p>
	This exception is used when an IOExceptions might occur from more
	than one source but the first occurance of an exception will not be
	thrown. In this case all the exceptions that occurred can be
	accumulated in a Multiwriter_IOException which is then thrown after
	processing of all the sources has been completed. Each IOException
	is paired with the source of the exception.
<p>
	@author		Bradford Castalia - UA/PIRL
	@version	1.4
	@see		PIRL.Utilities.Styled_Multiwriter
*/
public class Multiwriter_IOException
	extends IOException
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Utilities.Multiwriter_IOException (1.4 2012/04/16 06:18:24)";

/**	The list of source objects that have thrown an exception.
*/
public Vector
	Sources		= new Vector (2);

/**	The list of IOExceptions that were thrown.
<p>
	Each exception occurs at the same position in the list as the position
	of the source in the {@link #Sources} list that caused the exception.
*/
public Vector
	Exceptions	= new Vector (2);

/**	Construct a Multiwriter_IOException with an explanatory message.
<p>
	@param	message	A String explaining the exception.
*/
public Multiwriter_IOException
	(
	String	message
	)
{super (message);}

/**	Construct a Multiwriter_IOException with no explanatory message.
*/
public Multiwriter_IOException ()
{}

}
