/*	Theater_List

PIRL CVS ID: Theater_List.java,v 1.8 2012/04/16 06:04:12 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package PIRL.Conductor.Maestro;

import	PIRL.Conductor.Colors;

import	javax.swing.JComboBox;
import	javax.swing.JList;
import	javax.swing.ListCellRenderer;
import	javax.swing.JLabel;
import	javax.swing.BorderFactory;
import	java.awt.Component;
import	java.awt.Color;
import	java.awt.Font;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;
import	java.awt.Toolkit;


/**	A <i>Theater_List</i> is a list view of a Theater_List_Model.
<p>
	@author	Bradford Castalia, UA/PIRL
	@version 1.8
*/
public class Theater_List
	extends JComboBox
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Conductor.Maestro.Theater_List (1.8 2012/04/16 06:04:12)";


private Font
	Emphasis_Font;

private static final Toolkit
	TOOLKIT							= Toolkit.getDefaultToolkit ();

private static final String
	NL					= System.getProperty ("line.separator");


//  DEBUG control.
private static final int
	DEBUG_OFF			= 0,
	DEBUG_CONSTRUCTOR	= 1 << 0,
	DEBUG_ACCESSORS		= 1 << 1,
	DEBUG_RENDERER		= 1 << 2,
	DEBUG_ALL			= -1,

	DEBUG				= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
public Theater_List
	(
	Theater_List_Model	list_model
	)
{
super (list_model);
if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		(">>> Theater_List");

setEditable (true);
Emphasis_Font = getFont ().deriveFont (Font.BOLD);

setRenderer (new Theater_List_Renderer ());

getEditor ().addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{Editor_Action ();}});

if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("<<< Theater_List");
}


private void Editor_Action ()
{
String
	location = (String)getEditor ().getItem ();
if (location == null ||
	location.length () == 0)
	{
	getEditor ().setItem
		(((Theater_List_Model)getModel ()).getSelectedItem ());
	TOOLKIT.beep ();
	}
}

/*==============================================================================
	Theater_List_Renderer
*/
private class Theater_List_Renderer
	extends JLabel
	implements ListCellRenderer
{
public Theater_List_Renderer ()
{
setOpaque (true);
setBorder (BorderFactory.createEmptyBorder (3, 0, 3, 0));
}

public Component getListCellRendererComponent
	(
	JList	list,
	Object	value,
	int		index,
	boolean	selected,
	boolean	focused
	)
{
if ((DEBUG & DEBUG_RENDERER) != 0)
	System.out.println
		(">>> Theater_List_Renderer:" + NL
		+"    value - " + value + NL
		+"    index - " + index + NL
		+"    selected - " + selected);
Color
	color = Colors.TABLE;
if (index >=0)
	{
	if (((Theater_List_Model)list.getModel ()).Opened (index))
		color = Colors.OPENED_THEATER;
	else
		color = Colors.CLOSED_THEATER;
	}

Font
	font = list.getFont ();
if (selected)
	{
	color = Colors.Selected_Color (selected, color);
	font = Emphasis_Font;
	}
setFont (font);
setBackground (color);
setValue (value);
return this;
}


public void setValue
	(
	Object	value
	)
{setText ((value == null) ? "" : value.toString ());}

}	//	Theater_List_Renderer



}
