/*
Copyright (c) 1990 Regents of the University of California.
All rights reserved.
 */
/* VxWorks provides its own version of malloc, and we can't use this
   one because VxWorks does not provide sbrk.  So we have a hook to
   not compile this code.  */

#ifdef MALLOC_PROVIDED

int _dummy_mstats = 1;

#else

/*
FUNCTION
<<mallinfo>>, <<malloc_stats>>, <<mallopt>>---malloc support

INDEX
	mallinfo
INDEX
	malloc_stats
INDEX
	mallopt
INDEX
	_mallinfo_r
INDEX
	_malloc_stats_r
INDEX
	_mallopt_r

SYNOPSIS
	#include <malloc.h>
	struct mallinfo mallinfo(void);
	void malloc_stats(void);
	int mallopt(int <[parameter]>, <[value]>);

	struct mallinfo _mallinfo_r(void *<[reent]>);
	void _malloc_stats_r(void *<[reent]>);
	int _mallopt_r(void *<[reent]>, int <[parameter]>, <[value]>);

DESCRIPTION
<<mallinfo>> returns a structure describing the current state of
memory allocation.  The structure is defined in malloc.h.  The
following fields are defined: <<arena>> is the total amount of space
in the heap; <<ordblks>> is the number of chunks which are not in use;
<<uordblks>> is the total amount of space allocated by <<malloc>>;
<<fordblks>> is the total amount of space not in use; <<keepcost>> is
the size of the top most memory block.

<<malloc_stats>> print some statistics about memory allocation on
standard error.

<<mallopt>> takes a parameter and a value.  The parameters are defined
in malloc.h, and may be one of the following: <<M_TRIM_THRESHOLD>>
sets the maximum amount of unused space in the top most block before
releasing it back to the system in <<free>> (the space is released by
calling <<_sbrk_r>> with a negative argument); <<M_TOP_PAD>> is the
amount of padding to allocate whenever <<_sbrk_r>> is called to
allocate more space.

The alternate functions <<_mallinfo_r>>, <<_malloc_stats_r>>, and
<<_mallopt_r>> are reentrant versions.  The extra argument <[reent]>
is a pointer to a reentrancy structure.

RETURNS
<<mallinfo>> returns a mallinfo structure.  The structure is defined
in malloc.h.

<<malloc_stats>> does not return a result.

<<mallopt>> returns zero if the parameter could not be set, or
non-zero if it could be set.

PORTABILITY
<<mallinfo>> and <<mallopt>> are provided by SVR4, but <<mallopt>>
takes different parameters on different systems.  <<malloc_stats>> is
not portable.

*/

#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>

#if !defined (_ELIX_LEVEL) || _ELIX_LEVEL >= 2

/* mstats is now compatibility code.  It used to be real, for a
   previous version of the malloc routines.  It now just calls
   malloc_stats.  */

#ifndef _REENT_ONLY

void
mstats (char *s)
{
  fprintf (stderr, "Memory allocation statistics %s\n", s);
  malloc_stats ();
}

#endif

#endif /* !_ELIX_LEVEL || _ELIX_LEVEL >= 2 */

#endif /* ! defined (MALLOC_PROVIDED) */
