# -*- coding: utf-8 -*-
# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Alexandre Moore (http://nuovext.pwsp.net/).

# Follows PEP8

from core import ct, models
from lib.reverse_translation import _t

#no need to lazily import these as they are always imported
import re

METHODS = [_t('All'), 'Exif', 'Iptc', _t('One')]


class Action(models.Action):
    label = _t('Delete Tags')
    author = 'Juho Vepsäläinen, Stani'
    email = 'bebraw@gmail.com'
    version = '0.1'
    tags = [_t('metadata')]
    __doc__ = _t('Delete Exif or Iptc tags')

    def apply(self, photo, setting, cache):
        info = photo.info
        method = self.get_field('Method', info)
        if method == METHODS[-1]:  # One
            tag = self.get_field('Tag', info)
            del info[tag]
        elif method == 'all':
            for tag in info:
                del info[tag]
        else:
            for tag in info:
                if tag.startswith(method):
                    del info[tag]
        return photo

    def interface(self, fields):
        fields[_t('Method')] = self.ChoiceField(METHODS[0], METHODS)
        fields[_t('Tag')] = self.ExifItpcField('Exif_Image_ImageDescription',
            choices=self.EXIF_IPTC)

    def get_relevant_field_labels(self):
        """If this method is present, Phatch will only show relevant
        fields.

        :returns: list of the field labels which are relevant
        :rtype: list of strings

        .. note::

            It is very important that the list of labels has EXACTLY
            the same order as defined in the interface method.
        """
        relevant = ['Method']
        if self.get_field_string('Method') == 'One':
            relevant.append('Tag')
        return relevant

    icon = \
'x\xda\x01\xc3\x0c<\xf3\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0czIDATh\x81\xed\x99{pT\xd7}\xc7?\xe7\xdes\xf7\xae\
\xdeZ!,\x01\x02\x83,\xc0\xf8\x81\xb1\xb1\xa7\x18c\xa8\xad\xd8n\xdc\x10bO\xed\
\x8c\x0b\xd8\xcd\xa41\xad\x9d:i\x9b\xc4M2C m\x1d\x93\xa4cC\x8b]\xdb`\xc7\x86\
\t\x01\xc6\x06\xc6IZb\xc7\xd8\x80 \x90\x01\x05\x0b\xbdX!\t\tI iWZ\xed"i\x1fw\
O\xff\xb8wW\xab\xc7\na\xecI;\xd33sg\xef\xdd\xfb\xfa~\x7f\xe7\xfb\xfb\xfe\xce\
9W(\xa5\xf8\xbf\xdc\xb4?6\x80\xabm\xffO\xe0\x8f\xdd\xe4\'\xbdq\xc5\x8a\x15S\
\xa7O\x9f\xbe\xb8\xac\xac\xec\xde\x81\x81\x01\xbf\xd7\xeb}\xdf\xe7\xf3\x9d\
\xd8\xb7o_\xf0\xd3\x04x\xb9&\xc6Kb!\x84H=VJ\xa9g\x9eyf\xe5\xb2e\xcb6\x95\x96\
\x96\x16\xf4\xf7\xf7\xd3\xda\xda\x8a\xae\xeb\x14\x16\x16\x12\x8b\xc5\xf0z\
\xbd\x95\x87\x0e\x1dZ\xbdc\xc7\x8e\xea\xcf\x1c=i\x088\xc0\x05\xb6\xc4\x04@yy\
\xf95\x0f>\xf8\xe0\xaf\x16.\\x\xcb\xc1\x83\x079v\xec\x18\x96e\r\x0e\x0e\x0e\
\xb6\x02\xd2\xedv\x17\xba\xdd\xee\x9cE\x8b\x161s\xe6\xccxee\xe5\x1b\x1b6l\
\xf8\x9a\xfa\x8cmn\x94\x84\x1c\xf0:`\x00&`dff\xca%K\x96\xec/**\xbaq\xd3\xa6M\
\x91\x86\x86\x86\xfd\x1d\x1d\x1dg}>_g<\x1e\xb7\x00\x0b\xd0<\x1e\x8f\xa7\xab\
\xab\xeb\xfe\x92\x92\x92\xdb\xca\xcb\xcb\xbf\xbaf\xcd\x9an!\xc4w?K\x12\xc3\
\x088\xe05 \x03\xc8\x03\n\xa6<\xc0\xb5\xcb<_\xfcJYY\xd9\x8d\xbbw\xef\xee;z\
\xf4\xe8;\x9d\x9d\x9d\xb5\xc09\xe0\x02\xd0\t\x0c\x00\x99===y\x15\x15\x15\xd5\
3f\xccX$\xa5|r\xfe\xfc\xf9\xdfY\xb1b\xc5a!\xc4\xaf\xae\x84\xc4\xf9G\x1f\xcd(\
\xd9\xb5k`"\xd7\x0e\x93\x90\x10"\x01~\xf2\xa2\xed\xfc\xadf\xb2 \xbbT\xdc\xb7\
t\xffz\xceu4Z\x15rG-Y\xe1\x0b\xee"\xce\xebY\x045\x93\x88f\x10\xd5$Q!\x89\x9c\
y\x81_v\x1e\xc0\x0f\x14\xcf\x9e={\xf5\x03\x0f<\xf0\xf4\xc0\xc0\xc0\x89\xad[\
\xb7\xde\xa5\x94\x8aN\x04P\xd3\xea\xd5w\x0b\xa5v*!\x9e\x98\xb5m\xdb{\x13&\
\x90"\x9d|\xe9a\xde\x83u|$\x04B5\xe6\xb3\xe4\xe0\xf7\xf8]\xd1\x1bX\x9f\xaf\
\x1d\xf7a\xd6%\xda\x9a\xb7\xf1\x0f\xa7\xd7r\x1c\xc8[\xbe|\xf9\xcf\x8a\x8a\
\x8a\xe6n\xd9\xb2e\xaaR\xaa\xf7r`\xda\x9exbR\xcc\xb2\xfe\xa0\xa0\x04\x88\x03\
\xff2s\xf6\xec\xf5\xfc\xe0\x07\xf1t\xf7\xa4\xd6\x01\x81-\xa9\xecI\xb7r\xbd\
\x10v\xf2\x1a\xcdE\xf4\x06z\xe9\x087Y\x03\xe7Q*\xed\xa3@\xcfbZ\xd9\x93b\xfb\
\x92}\xdaS\xc0@[[\xdb\x1e\xa5T\xc6\xbcy\xf3n\x17B\xe8\xe3\xa2\x17BD,\xebM\
\x07|\x02\xdb\xda&\xaf\xf77g\x1f\x7f\xfc\x9aq\t\xa4\xb8\x8e\t\xe4eL\xa7,qA\
\xb0^\xc4\x02\x81\xde\xf0\xd1\'\x07w\xff\xf6N^l\xdaJC<6\xc6\xfb\xd1\xd0\x91\
\xe8\x9aaLY\xec\xfa\xf6\x17*\xdd\xaf\x06\xcd\xce\xc6`0H<\x1e\xbf\x160F\xdarj\
;\xb7j\xd5\xdf\x0b\xf8\xf3\xd1\xcf\xa5\\\x8f\xc7+\x9bV\xae\\\x9a\x96\x00C\
\xd1\xcf\x00\n<\x0bX\x08`\x85\xa1\xfdh\x7fSx0bN\x992\xa5\xd1\nSS\xf5}v\xf5\
\x9e$0\x12\xb8\x14\x06\xba0\x90\xc2\x85\x8eAN\x89\xb9l\xc1[\xa1\x9fv\r\x9c\
\xaf\t\x06\x83n\xe7\xd9\xdaX$\x1aW\xad\xbaC)\xf5|:r\xc0T\xdd\xe5\xfa\xa0m\
\xcd\x9au\xa3\x08\xa4D\xdf\x05d\x03\xd7\xe4\xcd\xb7\t\xe8&h\xb3{\x84\xcf\xe7\
c\xce\x9c9K\xb0\xdd&lNF\x17\x88$\xf0\x04h\x89\x0b\x89},\x85\x8bL\x8fYT\xb2\
\xa5aN\xe9\xfa\xc0\x9d\x80\x07\xc8\x04d*\x89\xc6G\x1f\xcd\xd3`\'\xb6m\x8f\
\xd9\x84\x10\xb8\xf2\xf2\xfa\xfc55_J\xd7\x03:\xb6|<%\x7f\xc1"\xd7$\xf2\x93\
\xd4\x9f\n\x96v\x8b\x96\xa0i\xba\xee\x98s_\xd1\x8a\xdb_\xe5K\xd9\xb3\xb4l\
\x1d;\xe2:\x86\x03\xde\x18\xea\x05\xe7X\xc7\xc0\xa5\x9b\xf2\xfa\x87\x0bW~\
\xb9\xaa\xf8\x8di\xf7\x19\xd79Ar\t!4!\x84\xd0M\xf35`\xd68\xd1\xc7\xe5\xf1\
\x0c\xfakjL\xa5\xd4-\x1f/]z\xdb0r\x0e\t\x13(\x04nX\xfc6/\xe5\xce\xa5\xd4\x1c\
\x916*\x86\xd2\xa4\x10\x1a:\x9a\xd0\xd1\xb07\x1d\x99<\x16h\xce\xaf@\x13\xf6\
\xb1p\xfe\x05A\xb8?\xdaQ\xbb\xb3\xeb\x1bG\xbf\x15:\x08\x04\xbd\x8f=\xf6WR\
\xd36\x8f\x07\xde\xc8\xca"\x1c\x08\xf8C\xe7\xcf\x17\x00(\xd8|\xcb\xe1\xc3_O%\
\xa0c\xeb\xb3\xb8\xf4ox\xe4\xba\xbf\xe69\x99\x0b\xae\xfc\xe1\x0f\xb2\x81Ht!\
\x93\xe0\x13dtt4$\x1a\x1aBh\xce9-I@\xa0\x91Tj\\E[\xff\xe0\xdbx\xef\xda\xd2\
\xf7\x96\xcf\x9a\xb5\x0fp\xa7\x03\xafI\x89\x9e\x91\xd1\xe3\xab\xaa\xf2\xa4\
\xfc\xdd\x93k\x18Sg\x1e80\x08#l\xd4]@\x8e\x8a\xdb\xda\x1f\x0e^\xb3\xa5"\xa4\
\xad{G.R\x0cIE\x17\xd2\x91\x8f+\xe5\xbf\xa1|\x90\xb80pahnc\xeeM\xd3\xbfu\xf7\
\xad\xd3\xf6\x8c\x07\xde\xd1}\xc8_S\xe3\x19q\xca\xd3\x17\x8b=\x94$i\xf7\nq Z\
\xf3\x1cG\x02\xd5\xd4k)\x04\x12.cGZ:\xfb\xd2\xd9w\xf2 E\xf7\xa9nd\xe0J\xe6\
\x87\x9eLn\x83{vM!\xbf\xd7\x95\x99\x0e<\x80+??\xda[_\x9f\xa5,k\xf4\xc9x\xfc\
\xab#\tX\xd8\x0e\xe3\xaf\xdb\xc0\xcf/5b\xa9\xb8-\x9b\xe1\xe0\x8d\x11\xe0\xe5\
\xb0\x84M$u\xb2\x17R{\xc0q\xaay\xc7\xf3\x99{,g<\xec\xc8\x8c\x0c\x06}\xbex$\
\x14\x1a\xbbn\x08\xb1\xb4\xe6\x9e{\xb2\xc1\xd6\xbfpH\x00h\x91n\xe2F.\x05\xe6\
$\xca\xccl\x89t\xc9\x14\xf0\xba\x03V&\xc1\xdb\xfb\t22yN\x13\xd2\xce\x19\x12\
\xbf:\x05\x9dn\xee\x7fe\x12\x9a\x95\xb6\x9e!t\x1d\xdd4\x07{\xbd\xde\xb4\xf2R\
\xb0\xfe\xe6\x83\x07\xdf\x07\xd0\x9cQb\x1c\x08\x03=@\xcb\x99M\xec\x8a\xf4\
\xd0\xdew\xd6"\xdc5\xd4\x0b\x12\xc3v\x1ea\x0c\x01s\xf6e\x8a\x9c\x86[\xab\x1d\
}3fr\xef\xd6|d8=x\x00#?7\xe6\xaf\xa9I\x0b>\xae\xd4\xc1\xbd\x15\x15?J\x1c\xa7\
&\xb1\x05\xf4\x03]X\x9c\xf5\xbe\xc4\x9b\xaeBe\x85\xba\x06\x084G\xd1\x95L\x01\
\xaf\x8f\x96P\xaa\xb4\x90\x18)\xb2\x91\x18\xdc\xf1N\x0e\x9e\xb6\xf1g\xb0\xd2\
\x93K_C\xa3\x1cS\xf76\xf8\x9e\xdd\x17/>\xbd\xce.\x86Z\x92@J/D\x80 p\xa1\xf3}\
\x8et\x1f\xe1\x90Y\xac\x18\x88\x85\xe8\xa8\r@D\x1b\x05\xde\xb6R\x99\x8cz\xc2\
\x8d4\x87\x8c\xc4`\xee\xf1\x1c\xe6\x1et\x8d\x0f\xde\xed&\xda\xd3\xa7"\x81@\
\xbaK\xd4G~\xff\xda\xe7\xce\x9e\ra\xdb\xbe\x14\t\x16#H\x0cbK\xa9\xed\xe3\xef\
\xf2\x96\xd5\x8f\xdf\x9c\x0c\xf1\xec~\xce\xd5w0\xd8k%\x93:UB\xc9a\x05\xc3\
\x1dI\n\x17\x99\xf5aDq>\xe9\xc6rB\xd3P\x86T\xc1\xe6\xe6\xb4\xfa\xaa\xbfti\
\xef7\xeb\xeaNb\x17]\x99\x08\xfe\xc8e\x15\x05\xc4\xb0\xa5\xe4\x8b\xf6\xd2\
\xd4\xb0\x91m2\x03\xcc\x02\xd0\'Ehnm\xc6\xdf\xda\xe7\xc8I&\xab\xb1\x9eL\xda\
\xd1\xb9\xe0}\xc4E\xe5\x7f\xef\xc1\x9a\x9a\x83f\x8c\x1e\xf2\xc8\xbc<\x15\xa8\
\xadK\x0b\xde\x17\x8d6\x7f\xad\xaaj\x87\x83\xd7\xc2VJl\x14\x81\x11R\xea\x03.\
4\xfe\x8c\x0f}\xbf\xe3\xa4f\x82\xcb\x03\xee\xe28\x1d\xa1s4\xd6\xb6\xa0b"\xe9\
BZ2\x91\xe5\xa8^\xd033\xf1=>\x9d\xdf\xff\xf8ez\xdca\xf4\xec\xac\xe4;\x8d\xdc\
\\\x15:wN\xc4cc\x8c\xd1\x81\x88R\xe1\xb5^\xef\x96\x80e\xf5\x03\x01\xa0\x17\
\xdb\xf2-\xa5\x94\x1a\xb5\xb0\xe5\x90\xb0H\x91\xd2\xa9gy\xdd\xea\xa7_\x18 \
\xb3\xc1\xbc\x06\x82\xe6EN\x9f\xfe\x98p(\xea\x94:\xc3\x91\x961$\xad\x94^\x88\
|e>\xd6\x94,\xea\xfes\x07uu\'P\xb9\xd9\x96\xeev\x13\x0b\x85D\xd8\xefO\x17|\
\xb6\xb7\xb7\xef=\xdc\xd3\xe3\x05\xda\x81\x0e\'\xb0\xd1\xc4\x1c;\xdd\xca\x9c\
\x02\xa2\xc0%\xa0;\xd4@}\xe3\xeb\xbc-4\xd0\x0c\x90Y\xe0\x9a\x04VA\x90\xca\
\x86ct_\xf4\xa5\x80\xd7\xed\xa8\xa7\x0c9t!\xd1\\&\xa1\xa7o\x05\xc0\xff\xd1\t\
*w\xee\x12a\xb0\x02\x8d\x8d\xa3\xdf\xee\xe4\xca\x89@\xe0\xd4\xc6\xe6\xe6w\
\x813\xd8\x8b\x08\x81T\xf0i\t\x8c\x90R\x00\xb8P\xfb\xaf\xbc\x1b\xa8\xa6\x01\
\x01B\x07\xdd\r\x86\x07dq\x94\x9a\xce\xdfS\xe7\xadE\xc45\xa4pjE\xb2j;\x95YH\
\x8e\xfcY7\xfb\x97\x13\x8f\tT\xd4\xdf\xa3U\xbd\xfd\xb6\xd2\xb3\xb2\x86\xc0\
\x18\x06\x99\xd3\xa6\xe1.,\xc4\x17\x8d\xfa\x9e\xad\xaf\x7f\x118\x0549\x91\
\x8f\x8d\\\xddH\xbb6\xea\\\x18\xc3\x19b\x00\xe7\xab\xbe\xcf\x16+L4ABs\x81\
\x91\x03f\x91\xa2-^GE\xd5\x01"\x83\x91QU[C\xe7\xd8\x85\xfd\x9c\xf1\xd6\xf5\
\xedi\xe1\xb5\xffPl\xee\x83\x9eHo\xaf\xf4\x87\xc3\x83B\xd3\xd0\xa4$g\xfat\
\x88\xc5\xf0ut\x04_niY\xd7\x15\x8d\x1ev\xc0\x07\x95R\xa3\xc0\xc3\xc4\x96\x16\
u\xec\x99\xd4d`\xce\x82\x8d<u\xedc|a\x88)\xc4c\x10\x0fC4\x00"\x90\xc9\xe2Y\
\xf73\xa5`::\x12\x81\xe0P\xdb\xbbT\x1d\xf6\xb6\xd7\xac\xe7\xe5\xfeV*\x01\xdf\
\x0c(\xfc;X7+7w\xfe\xf5\x8b\x17\xeb\x86\xcb\xa5E\x82ANvt\x9c}\xa3\xa3\xe3\
\x9f>\x0c\x04*\x9c\xc0E\xc6[S\x1a\x97\x80CB\xc3\x9e\xee\xe5\x00\xd3t\x177\
\x95\x1f\xe1\xa7\x193(N%\xa1\xe2\x10\x8f@,\x04\x11\x9f\xc6-\x85wqc\xc9\xed\
\x1cn\xdf\xc7\xc9w\x1aO\x9f^\xc7\xab\xf1\x08\xd5@\x0b\xb69\x08\xa0\xe8\x1f\
\xe1\x9b\x0f-[\xf6\xb0\x19\x8b\xe5\xfd\xa6\xb5\xf5\xd7\xcf\xb5\xb4\xac\xbd\
\x04\xcd@\x08\xc7i\xc6\xc57\x01\x02\xa9\xb3\xb6\x02\xa0\xb4\xe4!>\x7f\xdbK|G\
\xe8)\x12T\xa0\x14\xa8\x18X\xfd\x10\r\x81\xa9\xb2\xd4\x99\xed\x97>8\xf3\x02\
\xbf\x00\xea\x80V\x07\xfc \xb6\xd3\xb9\x80\x82\xefM\x9d\xba\xdc\xe3\xf1\xe4\
\x7f\xbb\xba\xfa\xe7\x80\x0f\x18P\xe3.\xe0\x0c\xb5\xcb~\x1fHI\xe8(\xf60\xe3\
\xe2\xf9=\x1c\xb9\xf8\x01G\x863\x05\xa1\x81\x90\xa0\xdb.\xa5\x1av]\xda{\xe6\
\x05\xb6b\'bs\x02\x1cv2&\xac\xda\xf7\xde\x86\xf6\xb6=?\xac\xee\x03\xba\x80\
\xfe\x89\x82\x9f\x10\x81\x14\x12\xa9\xb5\xa1\xfd\xd47x3\xecg\xd4\xc0Eh 4T\
\xd3\x16v\xd7m`;v\xe4\xcfc\xeby\xd0\x01\x9f\x00\xe8\xbak/_/.\xe7\x9d\x82\x85\
\xfcd\xde3\\7Q\xe0WD \xc1\x03\xdb\x95.\x01\xdd\x83\xdd46\xfc;;F]d\xa1\xbc\
\x9b\xd8Y\xf3\xcf\xec\x00\x1a\xb0\x0bP\x00{\xb8n)\xa5\x94\xb0[\xc6\x9f\xfe\
\x96M\x85w\xf2\x13M"\xf5L2\xa7\xfe%\xafbK\xf5\xd3\'0\xd60\xa3a3\xef\xf9OP\
\x95\x02>^\xfb<{j\x7f\xc4\xbb\xd8z\xef\xc2\x96]\x18\x88\'\xc0\x03\x19\xf7|\
\xc8\x96\xbc\x9by\x12\x01\xd1>\xa2\xed\xbf\xe6l\xf3[\x1c\xc2v\xbd\t\xb7\xcb&\
\xf1\xa8\x1blWr\x01\xf9\xc0\x8c\xdc\x1b\xf8\x93\xa5\xff\xc5\x06=\x83\x8c\x0b\
\xfb\xa9>\xb6\x9a\xb7\x80j\xec\xe8wb\xf7XL)\x15w\xc0\xbb\xcb+x=\xa3\x84\x87\
\xbb+h\xef:\xc0\xa1\xe6_\xb0\xcb\nr\n{\x9c\x13\xba\xa2\xef\tJ\xa9+\xda\x18Z\
\x86\xcc\xc1^\x90\xfa\xdc\xcd\xcf\xb3mE\'jE\'\xea\xee_r<c*_\x06n\xc2^k2\xb1g\
~\x00\xf2\x8e\xd7Xy\xc3Z6\x9a\x85|\x11\x98\x89\xfd\x1d\xc2L\x04\xf3J\xb7+\
\xee\x01\xa7\x17\x04C\xb5a\nP\xf6\xb9\xe3\xfc8k&\xb3\x01\xa2\xbd\xb4\x9d}\
\x85g\xeb\xff\x8d\x0f\xb1\x93>\xac\x94\xb2\x9c\xfbL\xe7\xde(v\x91\x9a\xb0\
\xe3\x8c\xd5>\xd1g\xd6\x94aF?\xb6\xbb\xb4U\xff\x90\xcd\xca"\n s\x98|\xed*V\
\xe6. \x13\xe7\x1b\x9b\x10B(\xbb\r*\xa5\x82\xce\xefU\x81\x87O\x90\x03\xc9\
\x1b\x87\x86\x19\x19\xd8\x05\xaex\xe1+<\xa2bh\xde\x179\x10\xf4\xd2\x8c\x9d\
\x03}\xd8\x91\x1e{\xa2{\x95\xed\x13\x13\x80aRr\x03\xb9\xd8\x0b\xb7\x12\xdbuB\
\xce\x96\xf0\xfe\xcf\xe4C\xdfU\x11\x80\xa4+\xe9\xd8\xced04\xed\x8b:\x9b\x85\
\xad\xba\xff\xb5\x04\x12s\xd9\xc47\xe5\xc4B\x99\xc2\xf1\xfe\xabz\xc1\xe5\xde\
\xffi=\x7f\xac\xaf\xfa\x9f\xca\x83/\xd3\xfe\x07\x86\xca\x84\xfb\xbaCM\xa5\
\x00\x00\x00\x00IEND\xaeB`\x82\xb4kX\xbe'
