# Changes of Note

- `filter.ferry` now creates output dimensions with the same type as the input dimension. It also takes an arrow '=>' in addition to '=' in the `--dimension` specification.
- `filters.hexbin` now falls back to slow boundary creation if no bounds information exists to do fast boundary creation.
- Dimension names can now contain the forward slash ('/') character.
- `readers.gdal` and `filters.colorization` now attempt to create dimensions with the type of the associated raster.
- The Python PDAL extension code was removed from the PDAL source tree to its own [repository](https://github.com/PDAL/python).
- The JAVA PDAL interface was remove from the PDAL source tree to its own [repository](https://github.com/PDAL/java).
- `pdal pipeline`and `pdal translate` now use stream mode if the operation being performed is streamable.  An option `--nostream` has been added to both commands to prevent the use of stream mode.  The `--stream` option of `pdal pipeline` is now obsolete and ignored.
- A new interface has been provided for the creation of plugins requiring less boilerplate code. There has been no API change.
- Stages and pipelines can now be tested to check whether they are streamable.

# Enhancements

- Added options `--timegap` and `--speedmin` to `readers.mbio` to allow configuration of which points should be read.
- Added support for compression schemes (xz, lzma, zstd) and created a standardized interface (#1722).
- `writers.bpf` now supports the option `auto` for the `coord_id` option to allow the UTM zone to be set from the spatial reference if possible (#1723).
- Added the ability read stage-specific options from a file with the `--option_file` option (#1641).
- Replace the GDAL point-in-polygon with a much faster implementation in `filters.crop`.
- Add a `--reverse` option to `filters.mortonorder` to provide a point ordering for good dispersal.
- `readers.bpf` now supports the TCR (ECEF - earth centered, earth fixed) coordinate system.
- Added option `--use_eb_vlr` to allow `readers.las` to interpret an extra bytes VLR as if the file were version 1.4 even if it's using an earlier LAS version.
- `readers.text` added options `--header` and `--skip` to provide an alternative header line and to allow skipping lines before reading the header, respectively.
- `writers.text` now supports the ability to specify individual dimension precision using a colon (':') and integer following the dimension name in the `--order` option.
- `readers.numpy` adds support for reading from Numpy (.npy) save files.
- `pdal info` now provides the `--enumerate` option.  See the documentation for [filters.stats](https://pdal.io/stages/filters.stats.html) for details.
- Added a general option `--logtiming` to cause log output to contain the elapsed time from the start of the program. (#1882)

# Documentation

- Added a description of the Alpine Linux environment used for Travis and Docker.
- Updated the documentation for building PDAL on Windows.
- Added an example of how to loop files with PowerShell.
- Corrected output shown in the documentation for `filters.hexbin`.
- Reorganized the stages landing page to make it easier to find. (#1880)

# New stages

- `readers.greyhound` - Allows reading points from a source using the [greyhound](https://github.com/hobu/greyhound) protocol.
- `filters.neighborclassifier` - Re-classifies points based on the classification of neighboring points.

# Removed stages

- `filters.computerange` - Use `filters.python` to simulate the functionality.

# Bug fixes

- `filters.range` now always rejects NaN values as out of range.
- Changed the default `--timegap` value in `readers.mbio` from 0 to 1 second.
- Fixed a bug when reading pointers from metadata on some OSX systems.
- Fixed a problem in `pdal translate` where overriding a reader or writer from a pipeline wouldn't create the proper pipeline.
- Fixed a problem where multiple LASzip VLRs would get written to LAS files (#1726).
- Fixed an installation problem with the Python extension.
- Fixed a bug in `writers.tindex` that could cause a crash if the output file wasn't LAS.
- Fixed JSON output from `filters.hexbin` when density/area can't be calculated.
- Fixed a problem where output might be tagged with the wrong SRS when using `filters.reprojection` in stream mode. (#1877)
- PDAL_DRIVER_PATH would be improperly parsed on Windows systems when the path contained colons. Windows builds now use the semicolon as the path separator. (#1889)
- Convert NaN and infinite double values to proper strings for output as JSON.
- Synthetic, keypoint and withheld flags are now added to the classification dimension for version 1.0 - 1.3 files in `readers.las`.
- Support missed case supporting points with color but no density in `filters.poisson`.
- Throw an error if the input file can't be opened in `readers.ply`.
- The `--stdin` option for `kernels.tindex` didn't work. Now it does. Various other fixes were made.
- `writers.gdal` now throws an error if an attempt is made to write an output file with no points available.
- A build error that would be generated if lazsip was not found, even if it was not requested, has been resolved.
- A build error that would be generated if Python was found but not requested has been resolved.
- PDAL defaults to using [normal CMake interface](https://cmake.org/cmake/help/v3.11/policy/CMP0022.html) linking (#1890)
- Fixed an issue where dimensions from `readers.pcd` and `writers.pcd` could get confused with dimensions from `readers.sbet` and `writers.sbet`.
- Fixed index computation in `filters.voxelcentroidnearestneighbor` and `filters.voxelcenternearestneighbor` #1901
- Fixed libdl linking #1900


