//=======================================================================
// pkgset.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_PKGSET_H
#define GPACO_PKGSET_H

#include <vector>
#include <iosfwd>

namespace Gpaco {

class Pkg;

class PkgSet : public std::vector<Pkg*>
{
	public:

	PkgSet();
	~PkgSet();

	PkgSet& operator+=(Pkg*);
	PkgSet& operator-=(Pkg*);

	float sizeInst() const	{ return mSizeInst; }
 
	bool hasPkg(std::string const& pkgName);

	private:

	float mSizeInst;

};

}	// namespace Gpaco


#endif  // GPACO_PKGSET_H
